/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.block;

import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockPileBase
extends BlockPartialBase {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)7);
    private static final AxisAlignedBB[] AABB_ARRAY = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), field_185505_j};

    public BlockPileBase(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public int getLevel(IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockPileBase) {
            return 8 - (Integer)blockState.func_177229_b((IProperty)LEVEL);
        }
        return 0;
    }

    public IBlockState setLevel(IBlockState blockState, int level) {
        if (blockState.func_177230_c() instanceof BlockPileBase) {
            return blockState.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(8 - MathHelper.func_76125_a((int)level, (int)1, (int)8)));
        }
        return blockState;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (!willHarvest && !world.field_72995_K) {
            int level = this.getLevel(state);
            if (level == 1) {
                world.func_175698_g(pos);
            } else {
                IBlockState newState = this.setLevel(state, level - 1);
                world.func_180501_a(pos, newState, 11);
            }
        }
        return willHarvest;
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        int level = this.getLevel(state);
        if (!world.field_72995_K) {
            ItemStack drop = this.getDrop(world, pos, state);
            StackHelper.spawnStackOnTop((World)world, (ItemStack)drop, (BlockPos)pos, (double)((double)(level * 2) / 16.0));
        }
        if (level == 1) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        } else {
            IBlockState newState = this.setLevel(state, level - 1);
            world.func_180501_a(pos, newState, world.field_72995_K ? 11 : 3);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
    }

    protected abstract ItemStack getDrop(World var1, BlockPos var2, IBlockState var3);

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_ARRAY[this.getLevel(state) - 1];
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return true;
        }
        return this.getLevel(state) == 8;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.getLevel(state) == 8;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)7)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }
}

