/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.config;

import com.codetaylor.mc.athenaeum.util.PacketHelper;
import com.codetaylor.mc.pyrotech.library.config.ConfigSerializer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SCPacketConfigUpdate
implements IMessage,
IMessageHandler<SCPacketConfigUpdate, IMessage> {
    private static final Logger LOGGER = LogManager.getLogger(SCPacketConfigUpdate.class);
    private Class<?>[] configClasses;
    private Map<String, Map<String, byte[]>> serializedConfigs;

    public SCPacketConfigUpdate() {
    }

    public SCPacketConfigUpdate(Class<?>[] configClasses) {
        this.configClasses = configClasses;
    }

    public void fromBytes(ByteBuf buffer) {
        this.serializedConfigs = new HashMap<String, Map<String, byte[]>>();
        int configCount = buffer.readInt();
        for (int i = 0; i < configCount; ++i) {
            String className = PacketHelper.readString((ByteBuf)buffer);
            int fieldCount = buffer.readInt();
            HashMap<String, byte[]> fieldMap = new HashMap<String, byte[]>();
            for (int j = 0; j < fieldCount; ++j) {
                String fieldName = PacketHelper.readString((ByteBuf)buffer);
                int payloadLength = buffer.readInt();
                byte[] payload = new byte[payloadLength];
                buffer.readBytes(payloadLength);
                fieldMap.put(fieldName, payload);
            }
            this.serializedConfigs.put(className, fieldMap);
        }
    }

    public void toBytes(ByteBuf buffer) {
        this.serializedConfigs = ConfigSerializer.INSTANCE.serialize(this.configClasses, LOGGER);
        buffer.writeInt(this.serializedConfigs.size());
        for (Map.Entry<String, Map<String, byte[]>> entry : this.serializedConfigs.entrySet()) {
            String className = entry.getKey();
            Map<String, byte[]> fieldMap = entry.getValue();
            PacketHelper.writeString((String)className, (ByteBuf)buffer);
            buffer.writeInt(fieldMap.size());
            for (Map.Entry<String, byte[]> fieldEntry : fieldMap.entrySet()) {
                PacketHelper.writeString((String)fieldEntry.getKey(), (ByteBuf)buffer);
                buffer.writeInt(fieldEntry.getValue().length);
                buffer.writeBytes(fieldEntry.getValue());
            }
        }
    }

    public IMessage onMessage(SCPacketConfigUpdate message, MessageContext ctx) {
        ConfigSerializer.INSTANCE.deserialize(message.serializedConfigs, LOGGER);
        return null;
    }
}

