/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.blockrenderer;

import com.codetaylor.mc.pyrotech.library.blockrenderer.IBulkRenderItemSupplier;
import com.codetaylor.mc.pyrotech.library.blockrenderer.RenderItemData;
import com.codetaylor.mc.pyrotech.library.blockrenderer.Rendering;
import com.codetaylor.mc.pyrotech.library.blockrenderer.Util;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class BlockRenderer {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final IBulkRenderItemSupplier bulkRenderItemSupplier;
    private boolean pendingBulkRender;
    private int pendingBulkRenderSize;
    private int size;
    private float oldZLevel;

    public BlockRenderer(IBulkRenderItemSupplier bulkRenderItemSupplier) {
        this.bulkRenderItemSupplier = bulkRenderItemSupplier;
    }

    public void render(int size) {
        this.pendingBulkRenderSize = size;
        this.pendingBulkRender = true;
    }

    public void onFrameStart() {
        if (this.pendingBulkRender) {
            this.bulkRender(this.bulkRenderItemSupplier, this.pendingBulkRenderSize);
            this.pendingBulkRender = false;
        }
    }

    private void bulkRender(IBulkRenderItemSupplier renderItemSupplier, int size) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiIngameMenu());
        Object toRender = renderItemSupplier.get();
        File folder = new File("renders/" + DATE_FORMAT.format(new Date()) + "/");
        this.setUpRenderState(size);
        this.renderItemStacks(size, (List<RenderItemData>)toRender, folder);
        this.tearDownRenderState();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void renderItemStacks(int size, List<RenderItemData> renderItemDataList, File folder) {
        int rendered = 0;
        long lastUpdate = 0L;
        for (RenderItemData data : renderItemDataList) {
            if (Keyboard.isKeyDown((int)1)) break;
            ItemStack itemStack = data.getItemStack();
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            for (RenderItemData.Offset offset : data.getOffsets()) {
                images.add(this.render(itemStack, offset));
            }
            BufferedImage image = this.combineImages(images, data.getOffsets(), size);
            try {
                this.writeImage(folder, image, itemStack.func_82833_r());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++rendered;
            if (Minecraft.func_71386_F() - lastUpdate <= 33L) continue;
            this.tearDownRenderState();
            this.renderLoading(String.format("Rendering %1$s items", renderItemDataList.size()), String.format("(%1$s/%2$s, %3$s to go)", rendered, renderItemDataList.size(), renderItemDataList.size() - rendered), itemStack, (float)rendered / (float)renderItemDataList.size());
            lastUpdate = Minecraft.func_71386_F();
            this.setUpRenderState(size);
        }
        if (rendered >= renderItemDataList.size()) {
            this.renderLoading(String.format("Rendered %1$s items", renderItemDataList.size()), "", null, 1.0f);
        } else {
            this.renderLoading("Rendering Cancelled", String.format("(%1$s/%2$s, %3$s to go)", rendered, renderItemDataList.size(), renderItemDataList.size() - rendered), null, (float)rendered / (float)renderItemDataList.size());
        }
    }

    private BufferedImage combineImages(List<BufferedImage> images, List<RenderItemData.Offset> offsets, int size) {
        if (images.size() != offsets.size()) {
            throw new RuntimeException("Images and offsets don't match!");
        }
        int xMax = Integer.MIN_VALUE;
        int xMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        for (RenderItemData.Offset offset : offsets) {
            int x = offset.getStitchX();
            int y = offset.getStitchY();
            if (x + 1 > xMax) {
                xMax = x + 1;
            }
            if (x < xMin) {
                xMin = x;
            }
            if (y + 1 > yMax) {
                yMax = y + 1;
            }
            if (y >= yMin) continue;
            yMin = y;
        }
        int width = (xMax - xMin) * size;
        int height = (yMax - yMin) * size;
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int i = 0; i < images.size(); ++i) {
            BufferedImage bufferedImage = images.get(i);
            RenderItemData.Offset offset = offsets.get(i);
            for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                    result.setRGB(x + offset.getStitchX() * size, y + offset.getStitchY() * size, bufferedImage.getRGB(x, y));
                }
            }
        }
        return result;
    }

    private void renderLoading(String title, String subtitle, ItemStack is, float progress) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147110_a().func_147609_e();
        GlStateManager.func_179094_E();
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        mc.field_71460_t.func_78478_c();
        Rendering.drawBackground(res.func_78326_a(), res.func_78328_b());
        Rendering.drawCenteredString(mc.field_71466_p, title, res.func_78326_a() / 2, res.func_78328_b() / 2 - 24, -1);
        Rendering.drawRect(res.func_78326_a() / 2 - 50, res.func_78328_b() / 2 - 1, res.func_78326_a() / 2 + 50, res.func_78328_b() / 2 + 1, -16772864);
        Rendering.drawRect(res.func_78326_a() / 2 - 50, res.func_78328_b() / 2 - 1, res.func_78326_a() / 2 - 50 + (int)(progress * 100.0f), res.func_78328_b() / 2 + 1, -11141291);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        Rendering.drawCenteredString(mc.field_71466_p, subtitle, res.func_78326_a(), res.func_78328_b() - 20, -1);
        if (is != null) {
            try {
                List list = is.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        list.set(i, is.func_77953_t().field_77937_e + (String)list.get(i));
                        continue;
                    }
                    list.set(i, TextFormatting.GRAY + (String)list.get(i));
                }
                FontRenderer font = is.func_77973_b().getFontRenderer(is);
                if (font == null) {
                    font = mc.field_71466_p;
                }
                int width = 0;
                for (String s : list) {
                    int j = font.func_78256_a(s);
                    if (j <= width) continue;
                    width = j;
                }
                GlStateManager.func_179109_b((float)(res.func_78326_a() - width / 2 - 12), (float)(res.func_78328_b() + 30), (float)0.0f);
                Rendering.drawHoveringText(list, 0, 0, font);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        mc.func_175601_h();
        mc.func_147110_a().func_147610_a(false);
    }

    private BufferedImage render(ItemStack itemStack, RenderItemData.Offset offset) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175599_af().func_180450_b(itemStack, offset.getRenderX() * 16, offset.getRenderY() * 16);
        GlStateManager.func_179121_F();
        try {
            return Util.createFlipped(this.readPixels(this.size, this.size));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void writeImage(File folder, BufferedImage img, String displayName) throws IOException {
        String filename = Util.sanitize(displayName).toLowerCase().replaceAll(" ", "_");
        File f = new File(folder, filename + ".png");
        int i = 2;
        while (f.exists()) {
            f = new File(folder, filename + "_" + i + ".png");
            ++i;
        }
        Files.createParentDirs((File)f);
        f.createNewFile();
        ImageIO.write((RenderedImage)img, "PNG", f);
    }

    private void setUpRenderState(int desiredSize) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        this.size = Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), desiredSize);
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        float scale = (float)this.size / (16.0f * (float)res.func_78325_e());
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(scale * 100.0f)));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)770, (int)1);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
    }

    private void tearDownRenderState() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179119_h();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = this.oldZLevel;
    }

    public BufferedImage readPixels(int width, int height) {
        GL11.glReadBuffer((int)1029);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)(Minecraft.func_71410_x().field_71440_d - height), (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buf);
        BufferedImage img = new BufferedImage(width, height, 2);
        int[] pixels = new int[width * height];
        buf.asIntBuffer().get(pixels);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        return img;
    }
}

