/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library;

import com.codetaylor.mc.athenaeum.recipe.IRecipeSingleOutput;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class CompostBinRecipeBase<T extends IForgeRegistryEntry<T>>
extends IForgeRegistryEntry.Impl<T>
implements IRecipeSingleOutput {
    private final ItemStack input;
    private final ItemStack output;
    private final int compostValue;

    public CompostBinRecipeBase(ItemStack output, ItemStack input) {
        this.input = input;
        this.output = output;
        this.compostValue = this.calculateCompostValue(input);
    }

    public CompostBinRecipeBase(ItemStack output, ItemStack input, int compostValue) {
        this.input = input;
        this.output = output;
        this.compostValue = compostValue;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public int getCompostValue() {
        return this.compostValue;
    }

    public int calculateCompostValue(ItemStack input) {
        Item item = input.func_77973_b();
        if (item instanceof ItemFood) {
            int min = ModuleTechBasicConfig.COMPOST_BIN.GENERATED_FOOD_COMPOST_VALUE_RANGE[0];
            int max = ModuleTechBasicConfig.COMPOST_BIN.GENERATED_FOOD_COMPOST_VALUE_RANGE[1];
            float hunger = Math.max(0.0f, Math.min(1.0f, (float)((ItemFood)item).func_150905_g(input) / 20.0f));
            float saturation = Math.max(0.0f, Math.min(1.0f, hunger * ((ItemFood)item).func_150906_h(input) * 2.0f / 20.0f));
            float scalar = (saturation + hunger) * 0.5f;
            return Math.max(min, Math.min(max, (int)((float)(max - min) * scalar + (float)min)));
        }
        return 1;
    }

    public boolean matches(ItemStack input) {
        if (this.input.func_77973_b() == input.func_77973_b()) {
            int i = this.input.func_77960_j();
            return i == Short.MAX_VALUE || i == input.func_77960_j();
        }
        return false;
    }

    public boolean matches(ItemStack input, ItemStack output) {
        if (!this.matches(input)) {
            return false;
        }
        if (this.output.func_77973_b() == output.func_77973_b()) {
            return this.output.func_77960_j() == output.func_77960_j();
        }
        return false;
    }
}

