/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateLangFiles {
    public static final Logger LOGGER = LogManager.getLogger(UpdateLangFiles.class);

    public static void main(String ... args) {
        new LangFileUpdater("pyrotech", "en_us.lang", ".", new FileLocator(), new Converter(), new Writer()).update();
    }

    public static class Writer {
        public void write(Path path, List<String> toWrite) throws IOException {
            Files.write(path, toWrite, new OpenOption[0]);
        }
    }

    public static class Reader {
        public List<String> read(Path path, List<String> result) throws IOException {
            try (BufferedReader br = new BufferedReader(new FileReader(path.toFile()));){
                List list = br.lines().collect(Collectors.toCollection(() -> result));
                return list;
            }
        }
    }

    public static class PropertiesReader {
        public Properties read(Path path) throws IOException {
            Properties subProperties = new Properties();
            subProperties.load(Files.newBufferedReader(path));
            return subProperties;
        }
    }

    public static class FileLocator {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<Path> locate(Path langPath, Predicate<? super Path> filter) {
            try (Stream<Path> paths = Files.walk(langPath, new FileVisitOption[0]);){
                List<Path> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filter).sorted().collect(Collectors.toList());
                return list;
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
                return Collections.emptyList();
            }
        }
    }

    public static class PathFilter
    implements Predicate<Path> {
        private final String masterFilePathString;

        public PathFilter(String masterFilePathString) {
            this.masterFilePathString = masterFilePathString;
        }

        @Override
        public boolean test(Path path) {
            String pathString = path.toString();
            return pathString.endsWith(".lang") && !pathString.endsWith(this.masterFilePathString);
        }
    }

    public static class Converter {
        public void convert(Path subFilePath, Path outputPath, List<String> masterList, Writer writer) {
            Properties subProperties;
            try {
                subProperties = new PropertiesReader().read(subFilePath);
            }
            catch (IOException e) {
                LOGGER.error("Unable to load lang file: " + subFilePath, (Throwable)e);
                return;
            }
            ArrayList<String> outputList = new ArrayList<String>(masterList.size());
            ArrayList<String> newKeys = new ArrayList<String>();
            for (String masterLine : masterList) {
                String masterLineTrimmed = masterLine.trim();
                if (masterLineTrimmed.length() == 0) {
                    outputList.add("");
                    continue;
                }
                if (masterLineTrimmed.startsWith("#")) {
                    outputList.add(masterLineTrimmed);
                    continue;
                }
                String[] split = masterLineTrimmed.split("=");
                String property = subProperties.getProperty(split[0]);
                if (property == null) {
                    outputList.add(masterLineTrimmed);
                    newKeys.add(split[0]);
                    continue;
                }
                outputList.add(split[0] + "=" + property);
            }
            try {
                outputPath = outputPath.resolve(subFilePath);
                writer.write(outputPath, outputList);
                LOGGER.info("Wrote " + newKeys.size() + " new lines to " + outputPath + "\n" + String.join((CharSequence)"\n", newKeys));
            }
            catch (IOException e) {
                LOGGER.error("Failed to write file: " + outputPath, (Throwable)e);
            }
        }
    }

    public static class LangFileUpdater {
        private final Path langPath;
        private final Path masterFilePath;
        private final Path outputPath;
        private FileLocator fileLocator;
        private Converter converter;
        private Writer writer;

        public LangFileUpdater(String modId, String masterLangFile, String outputPath, FileLocator fileLocator, Converter converter, Writer writer) {
            this.langPath = Paths.get("src/main/resources/assets/" + modId + "/lang/", new String[0]);
            this.masterFilePath = this.langPath.resolve(masterLangFile);
            this.outputPath = Paths.get(outputPath, new String[0]);
            this.fileLocator = fileLocator;
            this.converter = converter;
            this.writer = writer;
        }

        public void update() {
            List<String> masterList;
            try {
                masterList = new Reader().read(this.masterFilePath, new ArrayList<String>());
            }
            catch (IOException e) {
                LOGGER.error("Unable to read master file: " + this.masterFilePath, (Throwable)e);
                return;
            }
            List<Path> langFileList = this.fileLocator.locate(this.langPath, new PathFilter(this.masterFilePath.toString()));
            for (Path path : langFileList) {
                this.converter.convert(path, this.outputPath, masterList, this.writer);
            }
        }
    }
}

