/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.littlestructure;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ModelImporter
extends LittleStructurePremade {
    public String model;
    public String gridSize;
    public String precision;
    public String texFile;
    public boolean useMtl;
    public int color;
    public boolean useTex;
    public String maxSize;
    public ItemStack baseBlock;
    public Slot output;

    public ModelImporter(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
        this.gridSize = ItemMultiTiles.currentContext.size + "";
        this.precision = "0.05";
        this.useMtl = false;
        this.color = -1;
        this.useTex = true;
        this.maxSize = this.gridSize;
        this.baseBlock = new ItemStack((Block)LittleTiles.dyeableBlock);
        this.output = new Slot((IInventory)new InventoryBasic("out", false, 1), 0, 197, 81);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.model = nbt.func_74779_i("lt_model");
        this.gridSize = nbt.func_74764_b("lt_grid") ? nbt.func_74779_i("lt_grid") : this.gridSize;
        this.precision = nbt.func_74764_b("lt_prec") ? nbt.func_74779_i("lt_prec") : this.precision;
        this.texFile = nbt.func_74779_i("lt_tex");
        this.useMtl = nbt.func_74764_b("lt_mtl") ? nbt.func_74767_n("lt_mtl") : this.useMtl;
        this.color = nbt.func_74764_b("lt_col") ? nbt.func_74762_e("lt_col") : this.color;
        this.useTex = nbt.func_74764_b("lt_useTex") ? nbt.func_74767_n("lt_useTex") : this.useTex;
        this.maxSize = nbt.func_74764_b("lt_size") ? nbt.func_74779_i("lt_size") : this.maxSize;
        this.output.field_75224_c.func_70299_a(0, new ItemStack(nbt.func_74775_l("lt_slot")));
        this.baseBlock = nbt.func_74764_b("lt_base") ? new ItemStack(nbt.func_74775_l("lt_base")) : this.baseBlock;
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("lt_model", this.model);
        nbt.func_74778_a("lt_grid", this.gridSize);
        nbt.func_74778_a("lt_prec", this.precision);
        nbt.func_74778_a("lt_tex", this.texFile);
        nbt.func_74768_a("lt_col", this.color);
        nbt.func_74757_a("lt_useTex", this.useTex);
        nbt.func_74757_a("lt_mtl", this.useMtl);
        nbt.func_74778_a("lt_size", this.maxSize);
        if (!this.output.field_75224_c.func_70301_a(0).func_190926_b()) {
            nbt.func_74782_a("lt_slot", (NBTBase)this.output.field_75224_c.func_70301_a(0).serializeNBT());
        }
        nbt.func_74782_a("lt_base", (NBTBase)this.baseBlock.serializeNBT());
    }

    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack itemInHand, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!world.field_72995_K) {
            this.sendUpdatePacket();
            LittleStructureGuiHandler.openGui((String)"modelimporter", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)player, (LittleStructure)this);
        }
        return true;
    }
}

