/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.timardo.lt3dimporter.LT3DImporter;
import net.timardo.lt3dimporter.Utils;
import net.timardo.lt3dimporter.importer.ColoredTexture;
import net.timardo.lt3dimporter.importer.ConvertedModel;
import net.timardo.lt3dimporter.importer.ITexture;
import net.timardo.lt3dimporter.importer.ImportException;
import net.timardo.lt3dimporter.importer.MtlTexture;
import net.timardo.lt3dimporter.importer.NormalTexture;
import net.timardo.lt3dimporter.importer.Triangle;
import net.timardo.lt3dimporter.littlestructure.ModelImporter;
import net.timardo.lt3dimporter.network.PacketStructureImporterNBT;
import net.timardo.lt3dimporter.obj3d.LightObj;
import net.timardo.lt3dimporter.obj3d.LightObjGroup;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwjgl.util.Color;

public class Importer
implements Runnable {
    private String model;
    private String tex;
    private Color col;
    private int size;
    private int grid;
    private float precision;
    private ItemStack base;
    private boolean isTex;
    private boolean useMtl;
    private EntityPlayer player;
    private ModelImporter structure;

    public Importer(String modelFile, String texName, Color color, int maxSize, int grid, float minprecision, ItemStack baseBlock, boolean texture, boolean useMtl, EntityPlayer player, ModelImporter s) {
        this.model = modelFile;
        this.tex = texName;
        this.col = color;
        this.size = maxSize;
        this.grid = grid;
        this.precision = minprecision;
        this.base = baseBlock;
        this.isTex = texture;
        this.useMtl = useMtl;
        this.player = player;
        this.structure = s;
    }

    @Override
    public void run() {
        NBTTagCompound tag = null;
        if (this.isTex && this.tex.isEmpty() && !this.useMtl) {
            Utils.postMessage((ICommandSender)this.player, TextFormatting.RED + "Empty texture field!");
            return;
        }
        LT3DImporter.logger.debug("prepare for some waiting...");
        long time = System.currentTimeMillis();
        try {
            tag = this.convertModelToRecipe();
        }
        catch (ImportException ie) {
            Utils.postMessage((ICommandSender)this.player, TextFormatting.RED + ie.getReason());
            return;
        }
        LT3DImporter.logger.debug("done in " + (System.currentTimeMillis() - time) + "ms");
        PacketStructureImporterNBT nbtPacket = new PacketStructureImporterNBT();
        NBTTagCompound packetNBT = new NBTTagCompound();
        packetNBT.func_74757_a("item", true);
        packetNBT.func_74782_a("loc", (NBTBase)new StructureLocation((LittleStructure)this.structure).write());
        packetNBT.func_74782_a("recipe_nbt", (NBTBase)tag);
        nbtPacket.setNBT(packetNBT);
        PacketHandler.sendPacketToServer((CreativeCorePacket)nbtPacket);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NBTTagCompound convertModelToRecipe() throws ImportException {
        HashMap<String, ITexture> texMap;
        LightObj obj;
        block32: {
            void var7_21;
            Iterator<String> iterator;
            String rootDir;
            ArrayList<Mtl> arrayList;
            block31: {
                block30: {
                    FileInputStream objInputStream = null;
                    obj = null;
                    if (this.model.startsWith("\"") || this.model.endsWith("\"")) {
                        this.model = this.model.replace("\"", "");
                    }
                    if (this.tex.startsWith("\"") || this.tex.endsWith("\"")) {
                        this.tex = this.tex.replace("\"", "");
                    }
                    try {
                        objInputStream = new FileInputStream(this.model);
                    }
                    catch (FileNotFoundException | NullPointerException e) {
                        LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        throw new ImportException("Cannot read model file! Does it exist?");
                    }
                    try {
                        obj = ObjReader.read(objInputStream, new LightObj());
                    }
                    catch (IOException e) {
                        LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        throw new ImportException("Unreadable model file! Is it in .obj format?");
                    }
                    try {
                        ((InputStream)objInputStream).close();
                    }
                    catch (IOException | NullPointerException e) {
                        LT3DImporter.logger.error("Error closing the objInputStream! If you are getting this error too often, please, open an issue on GitHub (link on CurseForge). Include this info:" + System.lineSeparator() + ExceptionUtils.getStackTrace((Throwable)e));
                        Utils.postMessage((ICommandSender)this.player, TextFormatting.RED + "Error closing the objInputStream! Check log!");
                    }
                    obj = ObjUtils.triangulate(obj, new LightObj(true));
                    texMap = new HashMap<String, ITexture>();
                    if (!this.isTex) break block30;
                    if (this.useMtl) {
                        arrayList = new ArrayList<Mtl>();
                        rootDir = FilenameUtils.getFullPath((String)new File(this.model).getAbsolutePath());
                        iterator = obj.getMtlFileNames().iterator();
                        break block31;
                    } else {
                        try {
                            NormalTexture normalTexture = new NormalTexture(this.tex);
                            for (int i = 0; i < obj.getNumMaterialGroups(); ++i) {
                                texMap.put(((LightObjGroup)obj.getMaterialGroup(i)).getName(), normalTexture);
                            }
                        }
                        catch (IOException iOException) {
                            LT3DImporter.logger.error("Error loading texture, file '" + this.tex + "' is in unsupported format! Full stacktrace below:");
                            LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)iOException));
                            throw new ImportException("Error loading texture file! Is it in supported format? (JPEG, PNG, BMP)");
                        }
                    }
                }
                ColoredTexture coloredTexture = new ColoredTexture(ColorUtils.RGBAToInt((Color)this.col));
                for (int i = 0; i < obj.getNumMaterialGroups(); ++i) {
                    texMap.put(((LightObjGroup)obj.getMaterialGroup(i)).getName(), coloredTexture);
                }
                break block32;
            }
            while (iterator.hasNext()) {
                String string = iterator.next();
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(rootDir + string);
                }
                catch (FileNotFoundException e) {
                    LT3DImporter.logger.error("Error loading texture, file '" + rootDir + string + "' doesn't exist! Full stacktrace below:");
                    LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new ImportException("One or more MTL files declared in the obj file do not exist!");
                }
                List<Mtl> mtls0 = null;
                try {
                    mtls0 = MtlReader.read(stream);
                }
                catch (IOException e) {
                    LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new ImportException("There was a problem reading an MTL file, check log!");
                }
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException | NullPointerException e) {
                    LT3DImporter.logger.error("Error closing the stream! If you are getting this error too often, please, open an issue on GitHub (link on CurseForge). Include this info:" + System.lineSeparator() + ExceptionUtils.getStackTrace((Throwable)e));
                    Utils.postMessage((ICommandSender)this.player, TextFormatting.RED + "Error closing the stream! Check log!");
                }
                arrayList.addAll(mtls0);
            }
            if (arrayList.isEmpty()) {
                throw new ImportException("No MTL entry declared in this .obj file!");
            }
            HashMap<String, Mtl> mtlMap = new HashMap<String, Mtl>();
            for (Mtl mtl : arrayList) {
                if (mtlMap.containsKey(mtl.getName())) {
                    throw new ImportException("Duplicate material found in declared MTL files! (" + mtl.getName() + ")");
                }
                mtlMap.put(mtl.getName(), mtl);
            }
            boolean bl = false;
            while (var7_21 < obj.getNumMaterialGroups()) {
                String material = ((LightObjGroup)obj.getMaterialGroup((int)var7_21)).getName();
                try {
                    texMap.put(material, new MtlTexture((Mtl)mtlMap.get(material), rootDir));
                }
                catch (IOException e) {
                    LT3DImporter.logger.error("Error loading texture, file '" + ((Mtl)mtlMap.get(material)).getMapKd() + "' is in unsupported format! Full stacktrace below:");
                    LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    throw new ImportException("Error loading one or more texture files declared in the MTL file! Is it in supported format? (JPEG, PNG, BMP)");
                }
                ++var7_21;
            }
        }
        double[] dArray = obj.getSides();
        double ratio = (double)this.size / Math.max(dArray[0], Math.max(dArray[1], dArray[2]));
        LittleGridContext littleGridContext = LittleGridContext.get((int)this.grid);
        ConvertedModel outputModel = new ConvertedModel(texMap, littleGridContext, obj, ratio, this.base);
        int i = 0;
        while (i < obj.getNumMaterialGroups()) {
            LightObjGroup group = (LightObjGroup)obj.getMaterialGroup(i);
            for (Triangle t : group.triangles) {
                t.calcBlocks(this.precision, ratio, outputModel, group.getName());
            }
            ++i;
        }
        return this.fastSavePreview(outputModel);
    }

    private NBTTagCompound fastSavePreview(ConvertedModel model) {
        NBTTagCompound ret = new NBTTagCompound();
        model.context.set(ret);
        int minX = (int)Math.round(model.obj.boxCoords[3] * model.ratio);
        int minY = (int)Math.round(model.obj.boxCoords[4] * model.ratio);
        int minZ = (int)Math.round(model.obj.boxCoords[5] * model.ratio);
        int maxX = (int)Math.round(model.obj.boxCoords[0] * model.ratio);
        int maxY = (int)Math.round(model.obj.boxCoords[1] * model.ratio);
        int maxZ = (int)Math.round(model.obj.boxCoords[2] * model.ratio);
        new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).writeToNBT("size", ret);
        new LittleVec(minX, minY, minZ).writeToNBT("min", ret);
        if (model.blocks.size() >= LittlePreview.lowResolutionMode) {
            ret.func_74782_a("pos", (NBTBase)model.previews);
        } else {
            ret.func_82580_o("pos");
        }
        NBTTagList list = new NBTTagList();
        for (Integer color : model.colorMap.keySet()) {
            List<LittlePreview> pList = model.colorMap.get(color);
            ArrayList<LittlePreview> tileList = new ArrayList<LittlePreview>(pList);
            LittlePreview grouping = tileList.remove(0);
            NBTTagCompound groupNBT = null;
            Iterator<LittlePreview> iterator2 = tileList.iterator();
            while (iterator2.hasNext()) {
                LittlePreview preview = iterator2.next();
                if (groupNBT == null) {
                    groupNBT = grouping.startNBTGrouping();
                }
                grouping.groupNBTTile(groupNBT, preview);
                iterator2.remove();
            }
            if (groupNBT == null) {
                NBTTagCompound nbt = new NBTTagCompound();
                grouping.writeToNBT(nbt);
                list.func_74742_a((NBTBase)nbt);
                continue;
            }
            list.func_74742_a(groupNBT);
        }
        ret.func_74782_a("tiles", (NBTBase)list);
        ret.func_74768_a("count", model.blocks.size());
        return ret;
    }
}

