/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.importer;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public interface ITexture {
    public static final int MIN_TEXTURE_SIZE = 512;

    public int colorTile(double[] var1);

    default public BufferedImage resizeTextureIfNeeded(BufferedImage input) {
        if (input == null) {
            return null;
        }
        int height = input.getHeight();
        int width = input.getWidth();
        if (width <= 512 || height <= 512) {
            int multiplier = 1;
            multiplier = width < height ? (int)Math.ceil(512.0f / (float)width) : (int)Math.ceil(512.0f / (float)height);
            BufferedImage resized = new BufferedImage(width * multiplier, height * multiplier, 2);
            Graphics2D g = resized.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.drawImage(input, 0, 0, width * multiplier, height * multiplier, null);
            g.dispose();
            input = resized;
        }
        return input;
    }
}

