/*
 * Decompiled with CFR 0.152.
 */
package net.timardo.lt3dimporter.exporter;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlWriter;
import de.javagl.obj.Mtls;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjWriter;
import de.javagl.obj.Objs;
import de.javagl.obj.ReadableObj;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.timardo.lt3dimporter.LT3DImporter;
import net.timardo.lt3dimporter.Utils;
import net.timardo.lt3dimporter.obj3d.LightObjFace;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Exporter
implements Runnable {
    private static final List<EnumFacing> FACINGS = Arrays.asList(EnumFacing.field_82609_l);
    private EntityPlayer player;
    private ItemStack blueprint;
    private Obj obj = Objs.create();
    private List<Mtl> mtls = new ArrayList<Mtl>();
    private Map<Integer, Map<Long, Integer>> vertices = new HashMap<Integer, Map<Long, Integer>>();
    private Map<Long, Integer> textureCoords = new HashMap<Long, Integer>();
    private Map<String, Map<Integer, Integer>> textures = new HashMap<String, Map<Integer, Integer>>();
    private Map<Long, Map<Long, Map<String, Integer>>> uniqueFaces = new HashMap<Long, Map<Long, Map<String, Integer>>>();
    private Map<String, Map<Long, Map<Long, List<int[]>>>> materialGroups = new HashMap<String, Map<Long, Map<Long, List<int[]>>>>();
    private Map<String, Boolean> materialDuplicateFaceRemoveMap = new HashMap<String, Boolean>();
    private String outputFolder;
    private String outputFileName;

    public Exporter(EntityPlayer sender, ItemStack blueprint, String outputFolder, String outputFileName) {
        this.player = sender;
        this.blueprint = blueprint;
        this.outputFolder = outputFolder;
        this.outputFileName = outputFileName;
        if (this.outputFolder.startsWith("\"") || this.outputFolder.endsWith("\"")) {
            this.outputFolder = this.outputFolder.replace("\"", "");
        }
    }

    @Override
    public void run() {
        this.exportModel(this.blueprint);
        try {
            String fullPath = this.outputFolder + (this.outputFolder.isEmpty() ? "" : File.separator) + this.outputFileName;
            File folder = new File(this.outputFolder);
            folder.mkdirs();
            FileOutputStream mtlOutputStream = new FileOutputStream(fullPath + ".mtl");
            MtlWriter.write(this.mtls, mtlOutputStream);
            FileOutputStream objOutputStream = new FileOutputStream(fullPath + ".obj");
            this.obj.setMtlFileNames(Arrays.asList(this.outputFileName + ".mtl"));
            ObjWriter.write((ReadableObj)this.obj, objOutputStream);
            ((OutputStream)mtlOutputStream).close();
            ((OutputStream)objOutputStream).close();
        }
        catch (IOException e) {
            LT3DImporter.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        Utils.postMessage((ICommandSender)this.player, "Exported");
    }

    public void exportModel(ItemStack stack) {
        int verticesCount = 0;
        ArrayList cubes = LittlePreview.getCubes((ItemStack)stack, (boolean)false);
        for (int i = 0; i < cubes.size(); ++i) {
            final RenderBox cube = (RenderBox)cubes.get(i);
            IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(cube.getBlockState());
            ArrayList quads = new ArrayList();
            FACINGS.forEach(facing -> quads.addAll(CreativeBakedModel.getBakedQuad(null, (RenderBox)cube, null, (BlockPos)cube.getOffset(), (IBlockState)cube.getBlockState(), (IBakedModel)blockModel, null, (EnumFacing)facing, (long)0L, (boolean)false)));
            boolean useTintIndex = false;
            HashMap faces = new HashMap();
            for (BakedQuad bakedQuad : quads) {
                if (!bakedQuad.func_178212_b()) continue;
                useTintIndex = true;
                break;
            }
            for (BakedQuad bakedQuad : quads) {
                int[] vertexData = bakedQuad.func_178209_a();
                VertexFormat format = bakedQuad.getFormat();
                int index = 0;
                int uvOffset = format.func_177344_b(0) / 4;
                HashMap<Integer, 1> uniqueVertices = new HashMap<Integer, 1>();
                int[] vertexIndices = new int[4];
                int[] texCoordIndices = new int[4];
                int duplicateOffset = 0;
                for (int j = 0; j < 4; ++j) {
                    index = format.func_181719_f() * j;
                    float x = Float.intBitsToFloat(vertexData[index]);
                    float y = Float.intBitsToFloat(vertexData[index + 1]);
                    float z = Float.intBitsToFloat(vertexData[index + 2]);
                    int xI = Float.floatToRawIntBits(x);
                    final long yzL = (long)Float.floatToRawIntBits(y) << 32 | (long)Float.floatToRawIntBits(z) & 0xFFFFFFFFL;
                    if (uniqueVertices.containsKey(xI)) {
                        if (((Set)uniqueVertices.get(xI)).contains(yzL)) {
                            if (--duplicateOffset < -1) break;
                            vertexIndices = Arrays.copyOf(vertexIndices, 4 + duplicateOffset);
                            texCoordIndices = Arrays.copyOf(texCoordIndices, 4 + duplicateOffset);
                            continue;
                        }
                        ((Set)uniqueVertices.get(xI)).add(yzL);
                    } else {
                        uniqueVertices.put(xI, new HashSet<Long>(){
                            {
                                this.add(yzL);
                            }
                        });
                    }
                    float u = bakedQuad.func_187508_a().func_188537_a(Float.intBitsToFloat(vertexData[index + uvOffset])) / 16.0f % 1.0f;
                    float v = bakedQuad.func_187508_a().func_188536_b(Float.intBitsToFloat(vertexData[index + uvOffset + 1])) / 16.0f % 1.0f;
                    Long uv = (long)Float.floatToRawIntBits(u) << 32 | (long)Float.floatToRawIntBits(v) & 0xFFFFFFFFL;
                    if (!this.vertices.containsKey(xI)) {
                        this.vertices.put(xI, new HashMap());
                    }
                    if (!this.vertices.get(xI).containsKey(yzL)) {
                        this.vertices.get(xI).put(yzL, verticesCount);
                        ++verticesCount;
                        this.obj.addVertex(x, y, z);
                    }
                    if (!this.textureCoords.containsKey(uv)) {
                        this.textureCoords.put(uv, this.textureCoords.size());
                        this.obj.addTexCoord(u, 1.0f - v);
                    }
                    vertexIndices[j + duplicateOffset] = this.vertices.get(xI).get(yzL);
                    texCoordIndices[j + duplicateOffset] = this.textureCoords.get(uv);
                }
                if (duplicateOffset < -1) continue;
                Long firstTwo = (long)vertexIndices[0] << 32 | (long)vertexIndices[1] & 0xFFFFFFFFL;
                Long lastTwo = (long)vertexIndices[2] << 32 | (long)(vertexIndices.length == 3 ? -1 : vertexIndices[3]) & 0xFFFFFFFFL;
                if (!faces.containsKey(firstTwo)) {
                    faces.put(firstTwo, new HashMap());
                }
                if (!((Map)faces.get(firstTwo)).containsKey(lastTwo)) {
                    ((Map)faces.get(firstTwo)).put(lastTwo, new ArrayList());
                }
                ((ArrayList)((Map)faces.get(firstTwo)).get(lastTwo)).add(new Tuple((Object)texCoordIndices, (Object)bakedQuad));
            }
            for (Map.Entry entry : faces.entrySet()) {
                long firstTwo = (Long)entry.getKey();
                for (Map.Entry secondMap : ((Map)entry.getValue()).entrySet()) {
                    long lastTwo = (Long)secondMap.getKey();
                    ArrayList duplicateFaces = (ArrayList)secondMap.getValue();
                    ArrayList<BufferedImage> faceTextures = new ArrayList<BufferedImage>();
                    String matName = "";
                    for (Tuple singleFace : duplicateFaces) {
                        BakedQuad quad = (BakedQuad)singleFace.func_76340_b();
                        TextureAtlasSprite sprite = quad.func_187508_a();
                        String iconName = sprite.func_94215_i();
                        String materialName = iconName.substring(0, iconName.indexOf(58)) + "_" + iconName.substring(iconName.lastIndexOf(47) + 1);
                        int baseBlockColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(cube.getBlockState(), (IBlockAccess)this.player.func_130014_f_(), new BlockPos(32, 64, 285), quad.func_178211_c()) | 0xFF000000;
                        int alpha = ColorUtils.getAlpha((int)cube.color);
                        int cubeColorOnly = cube.color | 0xFF000000;
                        int finalColor = Utils.multiplyColor((cubeColorOnly != -1 || cubeColorOnly == -1 && alpha != 255) && baseBlockColor != -1 ? Utils.multiplyColor(-6710887, cube.color) : cube.color, cubeColorOnly != -1 && baseBlockColor != -1 ? -1 : baseBlockColor);
                        int[][] textureData = sprite.func_147965_a(0);
                        int[] rawFinalTextureData = new int[textureData[0].length];
                        int alphaColor = alpha << 24 | 0xFFFFFF;
                        for (int k = 0; k < textureData[0].length; ++k) {
                            rawFinalTextureData[k] = Utils.multiplyColor(textureData[0][k], alpha != 255 && (cube.color | 0xFF000000) != -1 || !useTintIndex || useTintIndex && quad.func_178212_b() ? finalColor : alphaColor);
                        }
                        BufferedImage image2 = new BufferedImage(sprite.func_94211_a(), sprite.func_94216_b(), 2);
                        image2.setRGB(0, 0, sprite.func_94211_a(), sprite.func_94216_b(), rawFinalTextureData, 0, sprite.func_94211_a());
                        matName = matName + materialName;
                        faceTextures.add(image2);
                    }
                    boolean buildTexture = false;
                    if (this.textures.containsKey(matName)) {
                        if (!this.textures.get(matName).containsKey(cube.color)) {
                            this.textures.get(matName).put(cube.color, this.textures.get(matName).size());
                            buildTexture = true;
                        }
                    } else {
                        this.textures.put(matName, (Map<Integer, Integer>)new HashMap<Integer, Integer>(){
                            {
                                this.put(cube.color, 0);
                            }
                        });
                        buildTexture = true;
                    }
                    matName = matName + "_" + cube.color;
                    if (buildTexture) {
                        BufferedImage finalTexture = new BufferedImage(((BufferedImage)faceTextures.get(0)).getWidth(), ((BufferedImage)faceTextures.get(0)).getHeight(), 2);
                        Graphics graphics = finalTexture.getGraphics();
                        faceTextures.forEach(image -> graphics.drawImage((Image)image, 0, 0, null));
                        graphics.dispose();
                        String texturePath = "textures/" + matName.substring(0, matName.indexOf(95)) + "/" + matName.substring(matName.indexOf(95) + 1) + ".png";
                        File textureFile = new File((this.outputFolder.isEmpty() ? "" : this.outputFolder + File.separator) + texturePath);
                        textureFile.mkdirs();
                        try {
                            ImageIO.write((RenderedImage)finalTexture, "png", textureFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        Mtl currentMaterial = Mtls.create(matName);
                        currentMaterial.setKa(1.0f, 1.0f, 1.0f);
                        currentMaterial.setKd(1.0f, 1.0f, 1.0f);
                        currentMaterial.setD(1.0f);
                        currentMaterial.setMapKd(texturePath);
                        this.mtls.add(currentMaterial);
                    }
                    int[] sortedVertexIndices = Utils.heapSort(new int[]{(int)(firstTwo >> 32), (int)firstTwo, (int)(lastTwo >> 32), (int)lastTwo});
                    Long firstTwoSorted = (long)sortedVertexIndices[0] << 32 | (long)sortedVertexIndices[1] & 0xFFFFFFFFL;
                    Long lastTwoSorted = (long)sortedVertexIndices[2] << 32 | (long)(sortedVertexIndices.length == 3 ? -1 : sortedVertexIndices[3]) & 0xFFFFFFFFL;
                    if (!this.uniqueFaces.containsKey(firstTwoSorted)) {
                        this.uniqueFaces.put(firstTwoSorted, new HashMap());
                    }
                    if (!this.uniqueFaces.get(firstTwoSorted).containsKey(lastTwoSorted)) {
                        this.uniqueFaces.get(firstTwoSorted).put(lastTwoSorted, new HashMap());
                    }
                    if (!this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).containsKey(matName)) {
                        this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).put(matName, 1);
                    } else {
                        this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).put(matName, this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).get(matName) + 1);
                    }
                    if (!this.materialGroups.containsKey(matName)) {
                        this.materialGroups.put(matName, new HashMap());
                        this.materialDuplicateFaceRemoveMap.put(matName, !(cube.block instanceof BlockLeaves));
                    }
                    if (!this.materialGroups.get(matName).containsKey(firstTwo)) {
                        this.materialGroups.get(matName).put(firstTwo, new HashMap());
                    }
                    if (!this.materialGroups.get(matName).get(firstTwo).containsKey(lastTwo)) {
                        this.materialGroups.get(matName).get(firstTwo).put(lastTwo, new ArrayList());
                    }
                    this.materialGroups.get(matName).get(firstTwo).get(lastTwo).add((int[])((Tuple)duplicateFaces.get(0)).func_76341_a());
                }
            }
        }
        for (Map.Entry<String, Map<Long, Map<Long, List<int[]>>>> material : this.materialGroups.entrySet()) {
            int leavesIndex = 0;
            this.obj.setActiveMaterialGroupName(material.getKey());
            this.obj.setActiveGroupNames(Collections.singletonList(material.getKey()));
            for (Map.Entry<Long, Map<Long, List<int[]>>> firstMap : material.getValue().entrySet()) {
                long firstTwo = firstMap.getKey();
                for (Map.Entry<Long, List<int[]>> secondMap : firstMap.getValue().entrySet()) {
                    long lastTwo = secondMap.getKey();
                    int[] vertexIndices = new int[]{(int)(firstTwo >> 32), (int)firstTwo, (int)(lastTwo >> 32), (int)lastTwo};
                    int[] sortedVertexIndices = Utils.heapSort(vertexIndices);
                    Long firstTwoSorted = (long)sortedVertexIndices[0] << 32 | (long)sortedVertexIndices[1] & 0xFFFFFFFFL;
                    Long lastTwoSorted = (long)sortedVertexIndices[2] << 32 | (long)(sortedVertexIndices.length == 3 ? -1 : sortedVertexIndices[3]) & 0xFFFFFFFFL;
                    if (this.materialDuplicateFaceRemoveMap.get(material.getKey()).booleanValue() && this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).get(material.getKey()) > 1) continue;
                    if (!this.materialDuplicateFaceRemoveMap.get(material.getKey()).booleanValue() && this.uniqueFaces.get(firstTwoSorted).get(lastTwoSorted).get(material.getKey()) > 1) {
                        this.obj.setActiveGroupNames(Collections.singletonList(material.getKey() + leavesIndex++));
                    }
                    if (vertexIndices[3] == -1) {
                        vertexIndices = Arrays.copyOf(vertexIndices, 3);
                    }
                    Iterator<int[]> iterator = secondMap.getValue().iterator();
                    while (iterator.hasNext()) {
                        int[] otherData;
                        int[] texCoordIndices = otherData = iterator.next();
                        LightObjFace objFace = new LightObjFace(vertexIndices, texCoordIndices, null);
                        this.obj.addFace(objFace);
                    }
                }
            }
        }
    }
}

