/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.obj;

import de.javagl.obj.DefaultObj;
import de.javagl.obj.Obj;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Objs {
    public static Obj create() {
        return new DefaultObj();
    }

    public static Obj createFromIndexedTriangleData(IntBuffer indices, FloatBuffer vertices, FloatBuffer texCoords, FloatBuffer normals) {
        float y;
        float x;
        int i;
        int numTriangles = indices.capacity() / 3;
        int numVertices = vertices.capacity() / 3;
        Obj obj = Objs.create();
        for (i = 0; i < numVertices; ++i) {
            float x2 = vertices.get(i * 3 + 0);
            float y2 = vertices.get(i * 3 + 1);
            float z = vertices.get(i * 3 + 2);
            obj.addVertex(x2, y2, z);
        }
        if (texCoords != null) {
            int numTexCoords = texCoords.capacity() / 2;
            for (int i2 = 0; i2 < numTexCoords; ++i2) {
                x = texCoords.get(i2 * 2 + 0);
                y = texCoords.get(i2 * 2 + 1);
                obj.addTexCoord(x, y);
            }
        }
        if (normals != null) {
            int numNormals = normals.capacity() / 3;
            for (int i3 = 0; i3 < numNormals; ++i3) {
                x = normals.get(i3 * 3 + 0);
                y = normals.get(i3 * 3 + 1);
                float z = normals.get(i3 * 3 + 2);
                obj.addNormal(x, y, z);
            }
        }
        for (i = 0; i < numTriangles; ++i) {
            int i0 = indices.get(i * 3 + 0);
            int i1 = indices.get(i * 3 + 1);
            int i2 = indices.get(i * 3 + 2);
            int[] v = new int[]{i0, i1, i2};
            int[] vt = null;
            int[] vn = null;
            if (texCoords != null) {
                vt = v;
            }
            if (normals != null) {
                vn = v;
            }
            obj.addFace(v, vt, vn);
        }
        return obj;
    }

    private Objs() {
    }
}

