/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures.city;

import java.util.Random;
import net.minecraft.world.World;
import techguns.util.BlockUtils;
import techguns.util.MathUtil;
import techguns.world.structures.WorldgenStructure;
import techguns.world.structures.city.GenericCity;

public class GenericCitySegment {
    int x;
    int y;
    int z;
    int sizeX;
    int sizeZ;
    int roadWidth;
    boolean isCenter;
    GenericCitySegment rootSegment;
    private float rootRadiusSquared;
    GenericCitySegment[] subSegments;
    boolean subAlignment = false;
    int direction = 0;
    GenericCity cityType;
    WorldgenStructure.BiomeColorType colorType;
    public Random rand;
    int splitStep;

    public GenericCitySegment(GenericCity cityType, int x, int y, int z, int sizeX, int sizeZ, int roadWidth, int direction, WorldgenStructure.BiomeColorType colorType, Random rand, GenericCitySegment rootSegment) {
        this.cityType = cityType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.roadWidth = roadWidth;
        this.direction = direction;
        this.colorType = colorType;
        this.rand = rand;
        if (rootSegment == null) {
            this.rootSegment = this;
            this.rootRadiusSquared = (float)MathUtil.Vec2.substract(new MathUtil.Vec2(this.x, this.z), new MathUtil.Vec2((float)this.x + (float)this.sizeX / 2.0f, (float)this.z + (float)this.sizeZ / 2.0f)).lenSquared();
        } else {
            this.rootSegment = rootSegment;
        }
    }

    public void setBlocks(World world, Random rnd) {
        if (this.subSegments != null && this.subSegments.length >= 2) {
            for (int i = 0; i < this.subSegments.length; ++i) {
                int heightDif;
                int y2;
                int y1;
                this.subSegments[i].setBlocks(world, rnd);
                if (i >= this.subSegments.length - 1) continue;
                if (this.subAlignment) {
                    y1 = BlockUtils.getGroundY(world, this.x, this.subSegments[i].z + this.subSegments[i].sizeZ);
                    y2 = BlockUtils.getGroundY(world, this.x + this.sizeX, this.subSegments[i].z + this.subSegments[i].sizeZ + this.roadWidth);
                    heightDif = y2 - y1;
                    this.cityType.roadType.setRoadBlocks(world, this.x, this.y, this.subSegments[i].z + this.subSegments[i].sizeZ, this.roadWidth, this.sizeX, heightDif, this.subAlignment, this.colorType);
                    continue;
                }
                y1 = BlockUtils.getGroundY(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.z);
                y2 = BlockUtils.getGroundY(world, this.subSegments[i].x + this.subSegments[i].sizeX + this.roadWidth, this.z + this.sizeZ);
                heightDif = y2 - y1;
                this.cityType.roadType.setRoadBlocks(world, this.subSegments[i].x + this.subSegments[i].sizeX, this.y, this.z, this.roadWidth, this.sizeZ, heightDif, this.subAlignment, this.colorType);
            }
        } else {
            this.cityType.placeStructure(world, this, rnd);
        }
    }

    public boolean generateSubSegments() {
        int size2;
        int size;
        if (this.sizeX >= this.sizeZ) {
            size = this.sizeX;
            size2 = this.sizeZ;
            this.subAlignment = false;
        } else {
            size = this.sizeZ;
            size2 = this.sizeX;
            this.subAlignment = true;
        }
        if (size <= 0) {
            return false;
        }
        double s = Math.sqrt((double)(size - this.cityType.minSubSegmentSize) / (double)(this.cityType.maxSubSegmentSize - this.cityType.minSubSegmentSize));
        if (size2 < this.cityType.minSubSegmentSize || size < this.cityType.maxSubSegmentSize && (double)this.rand.nextFloat() > s * 0.75 + (double)(this.getCenterFactor() * 0.25f)) {
            this.subSegments = null;
            return false;
        }
        int count = 2;
        if (this != this.rootSegment && (double)this.rand.nextFloat() >= 0.5) {
            count = Math.max(2, Math.round(1.0f + this.rand.nextFloat() * 0.5f * (((float)size - (float)(this.cityType.minSubSegmentSize + 1) / 2.0f) / (float)(this.roadWidth + 2))));
        }
        double[] parts = new double[count];
        double sum = 0.0;
        for (int i = 0; i < count; ++i) {
            parts[i] = 1.0 + (double)this.rand.nextFloat();
            sum += parts[i];
        }
        int sizeTotal = 0;
        this.subSegments = new GenericCitySegment[count];
        int x1 = this.x;
        int z1 = this.z;
        for (int i = 0; i < count; ++i) {
            int dir;
            int splitSize;
            if (i >= count - 1) {
                splitSize = size - sizeTotal;
                dir = this.subAlignment ? 1 : 0;
            } else {
                splitSize = (int)Math.round(parts[i] / sum * (double)(size - this.roadWidth * count));
                dir = this.subAlignment ? 3 : 2;
            }
            int nextRoadWidth = this.cityType.roadWidth[Math.min(this.cityType.roadWidth.length - 1, this.splitStep + 1)];
            this.subSegments[i] = !this.subAlignment ? new GenericCitySegment(this.cityType, x1 + sizeTotal, this.y, z1, splitSize, this.sizeZ, nextRoadWidth, dir, this.colorType, this.rand, this.rootSegment) : new GenericCitySegment(this.cityType, x1, this.y, z1 + sizeTotal, this.sizeX, splitSize, nextRoadWidth, dir, this.colorType, this.rand, this.rootSegment);
            sizeTotal += splitSize + this.roadWidth;
            if (this.isCenter && this.splitStep <= 1 && i == (count - 1) / 2) {
                this.subSegments[i].isCenter = true;
            } else if (this.isCenter && i == count - 1) {
                this.subSegments[i].isCenter = true;
            }
            this.subSegments[i].splitStep = this.splitStep + 1;
            this.subSegments[i].generateSubSegments();
        }
        return true;
    }

    public float getCenterFactor() {
        float f = 0.0f;
        float segmentX = (float)this.x + (float)this.sizeX / 2.0f;
        float segmentZ = (float)this.z + (float)this.sizeZ / 2.0f;
        MathUtil.Vec2 vSeg = new MathUtil.Vec2(segmentX, segmentZ);
        float rootX = (float)this.rootSegment.x + (float)this.rootSegment.sizeX / 2.0f;
        float rootZ = (float)this.rootSegment.z + (float)this.rootSegment.sizeZ / 2.0f;
        MathUtil.Vec2 vRoot = new MathUtil.Vec2(rootX, rootZ);
        return 1.0f - (float)(MathUtil.Vec2.substract(vRoot, vSeg).lenSquared() / (double)this.rootSegment.rootRadiusSquared);
    }

    public boolean isBorderSegment() {
        boolean isBorderX = this.x <= this.rootSegment.x || this.x + this.sizeX >= this.rootSegment.x + this.rootSegment.sizeX;
        boolean isBorderZ = this.z <= this.rootSegment.z || this.z + this.sizeZ >= this.rootSegment.z + this.rootSegment.sizeZ;
        return isBorderX || isBorderZ;
    }
}

