/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures.city;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.MBlock;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;
import techguns.world.structures.city.BuildingStyle;
import techguns.world.structures.city.Staircase;

public class CityBuildingType {
    public static CityBuildingType building1;
    public static CityBuildingType building2;
    public static CityBuildingType building3;
    public static CityBuildingType building4;
    public static CityBuildingType building5;
    public static CityBuildingType building6;
    BuildingStyle style;
    int wall_x = 2;
    int wall_y = 5;
    int wall_z = 1;
    int wall_el = 1;
    int section_height = 4;
    int floor_height = 1;
    int yOffset = 0;
    int[][] wallPattern;
    int[][] doorPattern;
    int doorWidth = 1;
    int doorOffset = 1;
    MBlock ladder;
    MBlock lamp;
    boolean roofLikeFloor = false;
    int roofBorderIndex = 0;

    public CityBuildingType(int wall_x, int wall_y, int wall_z, int section_height, int floor_height, BuildingStyle style) {
        this.wall_x = wall_x;
        this.wall_y = wall_y;
        this.wall_z = wall_z;
        this.section_height = section_height;
        this.floor_height = floor_height;
        this.yOffset = 0;
        this.style = style;
        this.ladder = new MBlock(TGBlocks.LADDER_0, 0);
        this.lamp = new MBlock(TGBlocks.LAMP_0, 1);
    }

    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType) {
        int y;
        int i;
        ArrayList<MBlock> blocklist = this.style.rollVariation();
        MBlock[] stairType = this.style.rollStairVariation();
        MBlock stairs = stairType[0];
        MBlock stairs_2 = stairType[1];
        int stairsdir = direction;
        if ((direction == 0 || direction == 2) && sizeX - 2 < this.wall_y + 1 || (direction == 1 || direction == 3) && sizeZ - 2 < this.wall_y + 1) {
            stairsdir = (stairsdir + 1) % 4;
        }
        int segX = (sizeX - this.wall_el) / this.wall_x;
        int sx = segX * this.wall_x + this.wall_el;
        int segZ = (sizeZ - this.wall_el) / this.wall_x;
        int sz = segZ * this.wall_x + this.wall_el;
        int segY = sizeY / this.wall_y;
        int sy = segY * this.wall_y;
        boolean isSmall = Math.max(sx - 2, sz - 2) < this.wall_y + 1 || Math.min(sx, sz) < 4;
        for (int i2 = 0; i2 < segY; ++i2) {
            int y2 = posY + this.yOffset + i2 * this.wall_y;
            this.placeFloor(world, posX + 1, y2, posZ + 1, sx - 2, this.floor_height, sz - 2, direction, colorType, blocklist);
            if (i2 >= 1) {
                this.placeLamps(world, posX + 1, y2 - 1, posZ + 1, sx - 2, 1, sz - 2, direction, colorType);
            }
            this.placeWall(world, posX, y2, posZ, segX, 1, 0, 0, colorType, i2 == 0 && direction == 0, blocklist);
            this.placeWall(world, posX + sx - 1, y2, posZ, segZ, 0, 1, 1, colorType, i2 == 0 && direction == 1, blocklist);
            this.placeWall(world, posX + sx - 1, y2, posZ + sz - 1, segX, -1, 0, 2, colorType, i2 == 0 && direction == 2, blocklist);
            this.placeWall(world, posX, y2, posZ + sz - 1, segZ, 0, -1, 3, colorType, i2 == 0 && direction == 3, blocklist);
        }
        int y2 = posY + this.yOffset + segY * this.wall_y;
        if (!this.roofLikeFloor) {
            this.placeFloor(world, posX, y2, posZ, sx, 1, sz, direction, colorType, blocklist);
        } else {
            this.placeFloor(world, posX + 1, y2, posZ + 1, sx - 2, 1, sz - 2, direction, colorType, blocklist);
        }
        this.placeLamps(world, posX + 1, y2 - 1, posZ + 1, sx - 2, 1, sz - 2, direction, colorType);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        MBlock block = blocklist.get(0);
        MBlock block2 = blocklist.get(this.roofBorderIndex);
        for (int i3 = 0; i3 < sx; ++i3) {
            for (int j = 0; j < sz; ++j) {
                if (i3 != 0 && i3 != sx - 1 && j != 0 && j != sz - 1) continue;
                block.setBlock(world, p.func_181079_c(posX + i3, y2 + 1, posZ + j), 0);
                if (!this.roofLikeFloor) continue;
                block2.setBlock(world, p.func_181079_c(posX + i3, y2, posZ + j), 0);
            }
        }
        int dx = 0;
        int dz = 0;
        int px = 0;
        int pz = 0;
        switch (stairsdir) {
            case 0: {
                dx = 0;
                dz = -1;
                px = posX + sx - 2;
                pz = posZ + sz - 2;
                break;
            }
            case 1: {
                dx = 1;
                dz = 0;
                px = posX + 1;
                pz = posZ + sz - 2;
                break;
            }
            case 2: {
                dx = 0;
                dz = 1;
                px = posX + 1;
                pz = posZ + 1;
                break;
            }
            case 3: {
                dx = -1;
                dz = 0;
                px = posX + sx - 2;
                pz = posZ + 1;
            }
        }
        for (i = 0; i < segY - 1; ++i) {
            y = posY + this.yOffset + i * this.wall_y;
            if (!isSmall) {
                if (i % 2 == 1) {
                    Staircase.placeStaircase(world, px + dx, y + 1, pz + dz, this.wall_y, (stairsdir + 2) % 4, true, colorType, stairs, stairs_2);
                    continue;
                }
                Staircase.placeStaircase(world, px, y + 1, pz, this.wall_y, (stairsdir + 2) % 4, false, colorType, stairs, stairs_2);
                continue;
            }
            for (int j = 0; j < this.wall_y; ++j) {
                if (j < this.wall_y - 1) {
                    p.func_181079_c(px - dx, y + i + 1, pz - dz);
                    block.setBlock(world, p, 0);
                }
                p.func_181079_c(px, y + j + 1, pz);
                this.ladder.setBlock(world, p, (stairsdir - 1) % 4);
            }
        }
        for (i = 0; i < this.wall_y; ++i) {
            y = posY + this.yOffset + (segY - 1) * this.wall_y;
            if (i < this.wall_y - 1) {
                p.func_181079_c(px - dx, y + i + 1, pz - dz);
                block.setBlock(world, p, 0);
            }
            p.func_181079_c(px, y + i + 1, pz);
            this.ladder.setBlock(world, p, (stairsdir - 1) % 4);
        }
        world.func_175656_a((BlockPos)p.func_181079_c(px, y2 + 1, pz), Blocks.field_150415_aT.func_176223_P());
    }

    public void placeLamps(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType) {
        int density = 3;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int ix = (sizeX - 1) % density;
        int iz = (sizeZ - 1) % density;
        for (int x = posX + ix / 2; x < posX + sizeX - (1 - ix / 2); x += density) {
            for (int z = posZ + iz / 2; z < posZ + sizeZ - (1 - iz / 2); z += density) {
                this.lamp.setBlock(world, p.func_181079_c(x, posY, z), 0);
            }
        }
    }

    public void placeWall(World world, int posX, int posY, int posZ, int segments, int dx, int dz, int direction, WorldgenStructure.BiomeColorType colorType, boolean placeDoor, ArrayList<MBlock> blocklist) {
        int mid = segments / 2;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int i = 0; i < segments; ++i) {
            int offset;
            int l;
            int j;
            if (placeDoor && i == mid) {
                for (j = 0; j < this.wall_x; ++j) {
                    for (l = 1; l <= this.wall_y; ++l) {
                        int b = this.doorPattern[this.wall_y - l][j];
                        offset = i * this.wall_x + j;
                        MBlock block = b >= 0 ? blocklist.get(b) : new MBlock(Blocks.field_150350_a, 0);
                        block.setBlock(world, p.func_181079_c(posX + offset * dx, posY + l - 1, posZ + offset * dz), direction);
                    }
                }
                int offset2 = i * this.wall_x + this.doorOffset;
                for (int k = 0; k < this.doorWidth; ++k) {
                    EnumFacing doorFacing = EnumFacing.field_176754_o[(direction + 3) % 4];
                    ItemDoor.func_179235_a((World)world, (BlockPos)p.func_181079_c(posX + (offset2 + k) * dx, posY + 1, posZ + (offset2 + k) * dz), (EnumFacing)doorFacing, (Block)Blocks.field_180413_ao, (boolean)false);
                }
                continue;
            }
            for (j = 0; j < this.wall_x; ++j) {
                for (l = 1; l <= this.wall_y; ++l) {
                    MBlock block = blocklist.get(this.wallPattern[this.wall_y - l][j]);
                    offset = i * this.wall_x + j;
                    block.setBlock(world, p.func_181079_c(posX + offset * dx, posY + l - 1, posZ + offset * dz), direction);
                }
            }
        }
    }

    public void placeFloor(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, ArrayList<MBlock> blocklist) {
        MBlock block = blocklist.get(2);
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int x = posX; x < posX + sizeX; ++x) {
            for (int z = posZ; z < posZ + sizeZ; ++z) {
                block.setBlock(world, p.func_181079_c(x, posY, z), 0);
            }
        }
    }

    static {
        ArrayList<MBlock> stoneWalls = new ArrayList<MBlock>();
        stoneWalls.add(MBlockRegister.STONE_BRICKS_PANEL);
        stoneWalls.add(MBlockRegister.STONE_BRICKS_SMALL);
        stoneWalls.add(MBlockRegister.COBBLESTONE_1);
        stoneWalls.add(MBlockRegister.COBBLESTONE_2);
        stoneWalls.add(MBlockRegister.COBBLESTONE_3);
        stoneWalls.add(MBlockRegister.ANDESITE_3);
        ArrayList<MBlock> stoneFloors = new ArrayList<MBlock>();
        stoneFloors.add(MBlockRegister.COBBLESTONE_7);
        stoneFloors.add(MBlockRegister.STONE_BRICKS_SUNKEN);
        stoneFloors.add(new MBlock(Blocks.field_150348_b, 6));
        stoneFloors.add(new MBlock(Blocks.field_150348_b, 3));
        stoneFloors.add(new MBlock(Blocks.field_150348_b, 2));
        ArrayList<MBlock> stoneBorder = new ArrayList<MBlock>();
        stoneBorder.add(MBlockRegister.ANDESITE_11);
        stoneBorder.add(MBlockRegister.ANDESITE_4);
        stoneBorder.add(MBlockRegister.COBBLESTONE_13);
        stoneBorder.add(MBlockRegister.COBBLESTONE_15);
        stoneBorder.add(MBlockRegister.ANDESITE1_0);
        ArrayList<MBlock> glassPanes = new ArrayList<MBlock>();
        glassPanes.add(new MBlock(Blocks.field_150410_aZ, 0));
        BuildingStyle stoneBuilding = new BuildingStyle(stoneWalls, glassPanes, stoneFloors, stoneBorder);
        MBlock[] woodStair = new MBlock[]{new MBlock(Blocks.field_150476_ad, 0), MBlockRegister.BARRACKS_WOOD_SCAFFOLD};
        stoneBuilding.addStairStyle(woodStair);
        BuildingStyle factoryBuilding = new BuildingStyle(MBlockRegister.FACTORY_PLATE, new MBlock((Block)Blocks.field_150397_co, 8), MBlockRegister.FACTORY_WIREFRAME);
        factoryBuilding.addStairStyle(woodStair);
        ArrayList<MBlock> brickWalls = new ArrayList<MBlock>();
        brickWalls.add(MBlockRegister.BRICKS_WIDE);
        ArrayList<MBlock> brickBorders = new ArrayList<MBlock>();
        brickBorders.add(MBlockRegister.BRICKS_WEATHERED);
        BuildingStyle brickBuilding = new BuildingStyle(brickWalls, glassPanes, stoneFloors, brickBorders);
        brickBuilding.addStairStyle(woodStair);
        ArrayList<MBlock> labWalls = new ArrayList<MBlock>();
        labWalls.add(MBlockRegister.LABORATORY_WALL);
        ArrayList<MBlock> labWindows = new ArrayList<MBlock>();
        labWindows.add(new MBlock((Block)Blocks.field_150397_co, 0));
        ArrayList<MBlock> labFloors = new ArrayList<MBlock>();
        labFloors.add(MBlockRegister.LABORATORY_FLOOR);
        ArrayList<MBlock> labBorders = new ArrayList<MBlock>();
        labBorders.add(MBlockRegister.LABORATORY_BORDER);
        ArrayList<MBlock> labDoorDecoration = new ArrayList<MBlock>();
        labDoorDecoration.add(MBlockRegister.LABORATORY_DECORATION);
        MBlock[] labStair = new MBlock[]{new MBlock(Blocks.field_150370_cb, 0), (MBlock)labWalls.get(0)};
        BuildingStyle labBuilding = new BuildingStyle(labWalls, labWindows, labFloors, labBorders, labDoorDecoration);
        labBuilding.addStairStyle(labStair);
        ArrayList<MBlock> limeWalls = new ArrayList<MBlock>();
        limeWalls.add(MBlockRegister.LIME_WALL);
        ArrayList<MBlock> limeFloors = new ArrayList<MBlock>();
        limeFloors.add(MBlockRegister.LIME_FLOOR);
        ArrayList<MBlock> limeBorders = new ArrayList<MBlock>();
        limeBorders.add(MBlockRegister.LIME_BORDER);
        ArrayList<MBlock> limeDoorDecoration = new ArrayList<MBlock>();
        limeDoorDecoration.add(MBlockRegister.LIME_DECORATION);
        BuildingStyle limeBuilding = new BuildingStyle(limeWalls, glassPanes, limeFloors, limeBorders, limeDoorDecoration);
        limeBuilding.addStairStyle(woodStair);
        building1 = new CityBuildingType(2, 5, 1, 4, 1, stoneBuilding);
        CityBuildingType.building1.wallPattern = new int[][]{{0, 0}, {0, 1}, {0, 1}, {0, 0}, {3, 3}};
        CityBuildingType.building1.doorPattern = new int[][]{{0, 0}, {0, 0}, {0, -1}, {0, -1}, {3, 3}};
        CityBuildingType.building1.roofLikeFloor = true;
        CityBuildingType.building1.roofBorderIndex = 3;
        CityBuildingType.building1.doorWidth = 1;
        CityBuildingType.building1.doorOffset = 1;
        building2 = new CityBuildingType(3, 4, 1, 3, 1, factoryBuilding);
        CityBuildingType.building2.wallPattern = new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 0, 0}, {2, 2, 2}};
        CityBuildingType.building2.doorPattern = new int[][]{{0, 0, 0}, {0, -1, -1}, {0, -1, -1}, {2, 2, 2}};
        CityBuildingType.building2.doorWidth = 2;
        CityBuildingType.building2.doorOffset = 1;
        building3 = new CityBuildingType(3, 4, 1, 3, 1, stoneBuilding);
        CityBuildingType.building3.wallPattern = new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 0, 0}, {3, 3, 3}};
        CityBuildingType.building3.doorPattern = new int[][]{{0, 0, 0}, {0, -1, -1}, {0, -1, -1}, {3, 3, 3}};
        CityBuildingType.building3.roofLikeFloor = true;
        CityBuildingType.building3.roofBorderIndex = 3;
        CityBuildingType.building3.doorWidth = 2;
        CityBuildingType.building3.doorOffset = 1;
        building4 = new CityBuildingType(3, 4, 1, 3, 1, brickBuilding);
        CityBuildingType.building4.wallPattern = new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 0, 0}, {3, 3, 3}};
        CityBuildingType.building4.doorPattern = new int[][]{{0, 0, 0}, {0, -1, -1}, {0, -1, -1}, {3, 3, 3}};
        CityBuildingType.building4.doorWidth = 2;
        CityBuildingType.building4.doorOffset = 1;
        CityBuildingType.building4.roofLikeFloor = true;
        CityBuildingType.building4.roofBorderIndex = 3;
        building5 = new CityBuildingType(3, 5, 1, 4, 1, labBuilding);
        CityBuildingType.building5.wallPattern = new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 1, 1}, {0, 0, 0}, {3, 3, 3}};
        CityBuildingType.building5.doorPattern = new int[][]{{0, 0, 0}, {0, 4, 4}, {0, -1, -1}, {0, -1, -1}, {3, 3, 3}};
        CityBuildingType.building5.doorWidth = 2;
        CityBuildingType.building5.doorOffset = 1;
        CityBuildingType.building5.roofLikeFloor = true;
        CityBuildingType.building5.roofBorderIndex = 3;
        building6 = new CityBuildingType(3, 4, 1, 3, 1, limeBuilding);
        CityBuildingType.building6.wallPattern = new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 0, 0}, {3, 3, 3}};
        CityBuildingType.building6.doorPattern = new int[][]{{0, 0, 0}, {0, -1, -1}, {0, -1, -1}, {3, 3, 3}};
        CityBuildingType.building6.doorWidth = 2;
        CityBuildingType.building6.doorOffset = 1;
        CityBuildingType.building6.roofLikeFloor = true;
        CityBuildingType.building6.roofBorderIndex = 3;
    }
}

