/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import techguns.util.BlockUtils;
import techguns.world.EnumLootType;

public abstract class WorldgenStructure {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int centX;
    public int centZ;
    public boolean canSwapXZ;
    public boolean removeJunkOnWorldspawn = false;
    public static BiomeDictionary.Type[] coldTypes = new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY};
    public static BiomeDictionary.Type[] sandTypes;
    public static BiomeDictionary.Type[] netherTypes;
    public EnumLootType lootTier = EnumLootType.TIER0;
    protected int heightdiffLimit = 3;

    public WorldgenStructure() {
        this(0, 0, 0, 0, 0, 0);
    }

    protected int getStep() {
        return 4;
    }

    public WorldgenStructure(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public WorldgenStructure setXZSize(int x, int z) {
        this.sizeX = x;
        this.sizeZ = z;
        this.centX = (int)((float)this.sizeX / 2.0f);
        this.centZ = (int)((float)this.sizeZ / 2.0f);
        return this;
    }

    public WorldgenStructure setXYZSize(int x, int y, int z) {
        this.sizeX = x;
        this.sizeY = y;
        this.sizeZ = z;
        this.centX = (int)((float)this.sizeX / 2.0f);
        this.centZ = (int)((float)this.sizeZ / 2.0f);
        return this;
    }

    public int getSizeX(Random rnd) {
        return this.sizeX;
    }

    public int getSizeZ(Random rnd) {
        return this.sizeZ;
    }

    public int getSizeY(Random rnd) {
        return this.sizeY;
    }

    public WorldgenStructure setSwapXZ(boolean b) {
        this.canSwapXZ = b;
        return this;
    }

    public abstract void setBlocks(World var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, BiomeColorType var9, Random var10);

    public static int[] rotatePoint(int x, int z, int direction, int centerX, int centerZ) {
        int a = x - centerX;
        int b = z - centerZ;
        for (int i = 0; i < direction; ++i) {
            int a2 = a;
            a = b;
            b = -a2;
        }
        x = a + centerX;
        z = b + centerZ;
        return new int[]{x, z};
    }

    public void spawnStructureWorldgen(World world, int chunkX, int chunkZ, int sizeX, int sizeY, int sizeZ, Random rnd, Biome biome) {
        int offsetZ;
        int direction = rnd.nextInt(4);
        int sizeXr = direction == 0 || direction == 2 ? sizeX : sizeZ;
        int sizeZr = direction == 0 || direction == 2 ? sizeZ : sizeX;
        int centerX = (int)((float)sizeX / 2.0f);
        int centerZ = (int)((float)sizeZ / 2.0f);
        int[] p0 = WorldgenStructure.rotatePoint(0, 0, direction, centerX, centerZ);
        int[] p1 = WorldgenStructure.rotatePoint(sizeX, 0, direction, centerX, centerZ);
        int[] p2 = WorldgenStructure.rotatePoint(0, sizeZ, direction, centerX, centerZ);
        int[] p3 = WorldgenStructure.rotatePoint(sizeX, sizeZ, direction, centerX, centerZ);
        int minX = Math.min(Math.min(p0[0], p1[0]), Math.min(p2[0], p3[0]));
        int minZ = Math.min(Math.min(p0[1], p1[1]), Math.min(p2[1], p3[1]));
        int x = minX + chunkX * 16;
        int z = minZ + chunkZ * 16;
        int offsetX = this.getRotationShiftX(direction);
        int y = BlockUtils.getValidSpawnYArea(world, x + offsetX, z + (offsetZ = this.getRotationShiftZ(direction)), sizeXr, sizeZr, this.heightdiffLimit, this.getStep());
        if (y < 0) {
            return;
        }
        if (this.removeJunkOnWorldspawn) {
            BlockUtils.removeJunkInArea(world, x - 1, z - 1, sizeXr + 2, sizeZr + 2);
        }
        this.setBlocks(world, x, y - 1, z, sizeX, sizeY, sizeZ, direction, WorldgenStructure.getBiomeColorTypeFromBiome(biome), rnd);
    }

    public void spawnStructureCaveWorldgen(World world, int chunkX, int chunkZ, int sizeX, int sizeY, int sizeZ, Random rnd, Biome biome) {
        int direction = rnd.nextInt(4);
        int sizeXr = direction == 0 || direction == 2 ? sizeX : sizeZ;
        int sizeZr = direction == 0 || direction == 2 ? sizeZ : sizeX;
        int centerX = (int)((float)sizeX / 2.0f);
        int centerZ = (int)((float)sizeZ / 2.0f);
        int[] p0 = WorldgenStructure.rotatePoint(0, 0, direction, centerX, centerZ);
        int[] p1 = WorldgenStructure.rotatePoint(sizeX, 0, direction, centerX, centerZ);
        int[] p2 = WorldgenStructure.rotatePoint(0, sizeZ, direction, centerX, centerZ);
        int[] p3 = WorldgenStructure.rotatePoint(sizeX, sizeZ, direction, centerX, centerZ);
        int minX = Math.min(Math.min(p0[0], p1[0]), Math.min(p2[0], p3[0]));
        int minZ = Math.min(Math.min(p0[1], p1[1]), Math.min(p2[1], p3[1]));
        int x = minX + chunkX * 16;
        int z = minZ + chunkZ * 16;
        int offsetX = this.getRotationShiftX(direction);
        int offsetZ = this.getRotationShiftZ(direction);
        int y = BlockUtils.getCaveHeight(world, chunkX, chunkZ, 10, 20, 100);
        if (y < 0) {
            return;
        }
        this.setBlocks(world, x, y - 1, z, sizeX, sizeY, sizeZ, direction, WorldgenStructure.getBiomeColorTypeFromBiome(biome), rnd);
    }

    protected static BiomeColorType getBiomeColorTypeFromBiome(Biome biome) {
        if (WorldgenStructure.isInBiomeList(coldTypes, biome)) {
            return BiomeColorType.SNOW;
        }
        if (WorldgenStructure.isInBiomeList(sandTypes, biome)) {
            return BiomeColorType.DESERT;
        }
        if (WorldgenStructure.isInBiomeList(netherTypes, biome)) {
            return BiomeColorType.NETHER;
        }
        return BiomeColorType.WOODLAND;
    }

    private static boolean isInBiomeList(BiomeDictionary.Type[] list, Biome biome) {
        for (int i = 0; i < list.length; ++i) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)list[i])) continue;
            return true;
        }
        return false;
    }

    protected int getRotationShiftX(int direction) {
        return 0;
    }

    protected int getRotationShiftZ(int direction) {
        return 0;
    }

    public static EnumFacing directionToFacing(int direction) {
        switch (direction) {
            case 0: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.EAST;
            }
            case 3: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.NORTH;
    }

    protected static int rollBlockIndex(Random rnd, int totalWeight, int[] weights) {
        int roll = rnd.nextInt(totalWeight + 1);
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (roll > (sum += weights[i])) continue;
            return i;
        }
        return weights.length;
    }

    static {
        BiomeDictionary.Type[] typeArray = new BiomeDictionary.Type[3];
        typeArray[0] = BiomeDictionary.Type.SANDY;
        typeArray[1] = BiomeDictionary.Type.BEACH;
        typeArray[2] = BiomeDictionary.Type.MESA;
        sandTypes = typeArray;
        netherTypes = new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER};
    }

    public static enum BiomeColorType {
        WOODLAND,
        SNOW,
        DESERT,
        NETHER;

    }
}

