/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.world.structures.WorldgenStructure;

public class WatchTowerSmall
extends WorldgenStructure {
    int towerSize = 3;

    public WatchTowerSmall(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int towerSize) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.towerSize = towerSize;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        if (sizeX >= this.towerSize + 2) {
            posX += (sizeX - this.towerSize) / 2;
        }
        if (sizeZ >= this.towerSize + 2) {
            posZ += (sizeZ - this.towerSize) / 2;
        }
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        for (int y = 1; y < sizeY - 1; ++y) {
            world.func_175656_a((BlockPos)p.func_181079_c(posX, posY + y, posZ), Blocks.field_180407_aO.func_176223_P());
            world.func_175656_a((BlockPos)p.func_181079_c(posX + this.towerSize - 1, posY + y, posZ), Blocks.field_180407_aO.func_176223_P());
            world.func_175656_a((BlockPos)p.func_181079_c(posX, posY + y, posZ + this.towerSize - 1), Blocks.field_180407_aO.func_176223_P());
            world.func_175656_a((BlockPos)p.func_181079_c(posX + this.towerSize - 1, posY + y, posZ + this.towerSize - 1), Blocks.field_180407_aO.func_176223_P());
            if (y >= sizeY - 3) continue;
            for (int x = 1; x < this.towerSize - 1; ++x) {
                for (int z = 1; z < this.towerSize - 1; ++z) {
                    world.func_175656_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), Blocks.field_150344_f.func_176223_P());
                }
            }
        }
        BlockUtils.fillBlocksHollow(world, p.func_181079_c(posX, posY + sizeY - 4, posZ), this.towerSize, 2, this.towerSize, Blocks.field_180407_aO.func_176223_P());
        BlockUtils.fillBlocks(world, p.func_181079_c(posX, posY + sizeY - 1, posZ), this.towerSize, 1, this.towerSize, TGBlocks.CAMONET_TOP.func_176223_P());
        int xoffset = 0;
        int zoffset = 0;
        int meta = 0;
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = 1;
                meta = 4;
                break;
            }
            case 1: {
                xoffset = 1;
                zoffset = 0;
                meta = 2;
                break;
            }
            case 2: {
                xoffset = this.towerSize - 1;
                zoffset = this.towerSize - 2;
                meta = 5;
                break;
            }
            case 3: {
                xoffset = this.towerSize - 2;
                zoffset = this.towerSize - 1;
                meta = 3;
            }
        }
        for (int y = 1; y < sizeY - 3; ++y) {
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY + y, posZ + zoffset), Blocks.field_150468_ap.func_176203_a(meta), 3);
        }
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY + sizeY - 3, posZ + zoffset), Blocks.field_180390_bo.func_176203_a((direction + 1) % 4), 3);
    }
}

