/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.entities.npcs.Ghastling;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.util.MBlockVanillaSpawner;
import techguns.world.dungeon.presets.specialblocks.MBlockChestLoottable;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class NetherGhastSpawner
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/factory_building");
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public NetherGhastSpawner() {
        super(10, 14, 10, 10, 14, 10);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int centerX;
        int centerZ;
        int hoffset = -2;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeFoundationNether(world, blocks, blockList, posX, posY + hoffset, posZ, centerX, centerZ, direction, 0, 16);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY + hoffset, posZ, centerX, centerZ, direction, 0, this.lootTier, colorType);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY + hoffset, posZ, centerX, centerZ, direction, 1, this.lootTier, colorType);
    }

    static {
        blockList.add(MBlockRegister.NETHERRACK_C2);
        blockList.add(MBlockRegister.AIR);
        blockList.add(MBlockRegister.NETHERRACK_C1);
        blockList.add(MBlockRegister.NETHERRACK_ROCKY);
        blockList.add(new MBlock(Blocks.field_150426_aN, 0));
        blockList.add(new MBlock(TGBlocks.NETHER_METAL, 3));
        blockList.add(new MBlock(Blocks.field_150411_aY, 0));
        blockList.add(new MBlock((Block)Blocks.field_150465_bP, 1));
        blockList.add(new MBlock(Blocks.field_150425_aM, 0));
        blockList.add(new MBlockVanillaSpawner(Ghastling.class));
        blockList.add(MBlockRegister.NETHERRACK_C12);
        blockList.add(MBlockRegister.NETHERRACK_C8);
        blockList.add(new MBlockChestLoottable((Block)Blocks.field_150486_ae, 3, CHEST_LOOT));
        blocks = BlockUtils.loadStructureFromFile("nether_ghast_spawner");
    }
}

