/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.items.ItemTGDoor2x1;
import techguns.util.MBlock;
import techguns.world.BlockRotator;
import techguns.world.EnumLootType;
import techguns.world.structures.MBlockRegister;
import techguns.world.structures.WorldgenStructure;

public class Bunker
extends WorldgenStructure {
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("techguns", "chests/militarybase_bunker");
    MBlock groundBlock = new MBlock(TGBlocks.CONCRETE, 1);
    MBlock stairsblock = new MBlock(Blocks.field_150446_ar, 0);
    MBlock wallBlock = new MBlock(TGBlocks.CONCRETE, 0);
    MBlock roofBlock = new MBlock(TGBlocks.CONCRETE, 2);
    MBlock sandbags = new MBlock(TGBlocks.SANDBAGS, 0);
    MBlock ladder = new MBlock(TGBlocks.LADDER_0, 0);
    MBlock[] crateBlocks = MBlockRegister.crates;
    MBlock lantern = new MBlock(Blocks.field_150426_aN, 0);
    MBlock lamps = new MBlock(TGBlocks.LAMP_0, 0);
    int type = 0;

    public Bunker(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int type) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.type = type;
        this.lootTier = EnumLootType.TIER1;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, WorldgenStructure.BiomeColorType colorType, Random rnd) {
        int dz;
        int dx;
        int zoffset;
        int xoffset;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        if (sizeX <= 4 && sizeZ >= 5) {
            if (direction == 0 || direction == 2) {
                direction = (direction + 1) % 4;
            }
        } else if (sizeZ <= 4 && sizeX >= 5 && (direction == 1 || direction == 3)) {
            direction = (direction + 1) % 4;
        }
        switch (direction) {
            case 0: {
                posX += 2;
                sizeX -= 2;
                break;
            }
            case 1: {
                posZ += 2;
                sizeZ -= 2;
                break;
            }
            case 2: {
                sizeX -= 2;
                break;
            }
            case 3: {
                sizeZ -= 2;
            }
        }
        EnumFacing facing = Bunker.directionToFacing(direction);
        for (int y = -1; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    if (y == -1) {
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.groundBlock.getState(), 2);
                        continue;
                    }
                    if (y == 0) {
                        if (x == 0 || x == sizeX - 1 || z == 0 || z == sizeZ - 1) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.wallBlock.getState(), 2);
                            continue;
                        }
                        world.func_175698_g((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z));
                        continue;
                    }
                    if (y == 1) {
                        if (this.type == 2 || this.type == 3) {
                            if (x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.wallBlock.getState(), 2);
                            continue;
                        }
                        if ((x != 0 && x != sizeX - 1 || z != 0 && z != sizeZ - 1 && z % 3 != 0) && (x != 0 && x != sizeX - 1 && x % 3 != 0 || z != 0 && z != sizeZ - 1)) continue;
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.wallBlock.getState(), 2);
                        continue;
                    }
                    if (y == 2) {
                        if (x == 0 || x == sizeX - 1 || z == 0 || z == sizeZ - 1) {
                            world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.wallBlock.getState(), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.roofBlock.getState(), 2);
                        continue;
                    }
                    if (y != 3 || this.type != 1 && this.type != 3 || x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                    world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.sandbags.getState(), 2);
                }
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 2;
                dx = -1;
                dz = 0;
                break;
            }
            case 1: {
                xoffset = sizeX / 2;
                zoffset = 0;
                dx = 0;
                dz = -1;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 2;
                dx = 1;
                dz = 0;
                break;
            }
            default: {
                xoffset = sizeX / 2;
                zoffset = sizeZ - 1;
                dx = 0;
                dz = 1;
            }
        }
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 1, posZ + zoffset));
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 0, posZ + zoffset));
        ItemTGDoor2x1.placeDoor(world, (BlockPos)p.func_181079_c(posX + xoffset, posY + 0, posZ + zoffset), facing, (Block)TGBlocks.BUNKER_DOOR, true);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : 0), posY + 0, posZ + zoffset + (dz == 0 ? 1 : 0)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : 0), posY + 1, posZ + zoffset + (dz == 0 ? 1 : 0)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : 0), posY + 0, posZ + zoffset + (dz == 0 ? -1 : 0)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : 0), posY + 1, posZ + zoffset + (dz == 0 ? -1 : 0)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : dx), posY - 1, posZ + zoffset + (dz == 0 ? 1 : dz)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : dx), posY - 1, posZ + zoffset + (dz == 0 ? -1 : dz)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : dx * 2), posY - 1, posZ + zoffset + (dz == 0 ? 1 : dz * 2)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : dx * 2), posY - 1, posZ + zoffset + (dz == 0 ? -1 : dz * 2)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : dx), posY + 0, posZ + zoffset + (dz == 0 ? 1 : dz)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : dx), posY + 0, posZ + zoffset + (dz == 0 ? -1 : dz)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : dx * 2), posY + 0, posZ + zoffset + (dz == 0 ? 1 : dz * 2)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : dx * 2), posY + 0, posZ + zoffset + (dz == 0 ? -1 : dz * 2)), this.wallBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? 1 : dx), posY + 2, posZ + zoffset + (dz == 0 ? 1 : dz)), BlockRotator.getWithFacing(this.lamps.getState(), facing.func_176734_d()), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + (dx == 0 ? -1 : dx), posY + 2, posZ + zoffset + (dz == 0 ? -1 : dz)), BlockRotator.getWithFacing(this.lamps.getState(), facing.func_176734_d()), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY - 1, posZ + zoffset), this.groundBlock.getState(), 2);
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx, posY - 1, posZ + zoffset + dz), this.groundBlock.getState(), 2);
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset + dx, posY + 0, posZ + zoffset + dz));
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset + dx, posY + 1, posZ + zoffset + dz));
        world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx * 2, posY + 0, posZ + zoffset + dz * 2), BlockRotator.getWithFacing(this.stairsblock.getState(), facing), 2);
        world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset + dx * 2, posY + 1, posZ + zoffset + dz * 2));
        if (this.type == 2 || this.type == 3) {
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset - dx, posY + 1, posZ + zoffset - dz), BlockRotator.getWithFacing(this.lamps.getState(), EnumFacing.UP), 2);
            this.setCrateBlocks(world, p, posX + 2, posY, posZ + 2, sizeX - 4, 2, sizeZ - 4);
        } else {
            world.func_180501_a((BlockPos)p.func_181079_c(posX + sizeX / 2, posY + 1, posZ + sizeZ / 2), BlockRotator.getWithFacing(this.lamps.getState(), EnumFacing.UP), 2);
        }
        if (this.type == 1 || this.type == 3) {
            int meta = 0;
            EnumFacing ladderFacing = EnumFacing.NORTH;
            switch (direction) {
                case 0: {
                    xoffset = sizeX - 2;
                    zoffset = sizeZ - 2;
                    dx = 1;
                    dz = 0;
                    meta = 2;
                    ladderFacing = EnumFacing.WEST;
                    break;
                }
                case 1: {
                    zoffset = sizeZ - 2;
                    xoffset = 1;
                    dx = 0;
                    dz = 1;
                    meta = 0;
                    ladderFacing = EnumFacing.NORTH;
                    break;
                }
                case 2: {
                    xoffset = 1;
                    zoffset = 1;
                    dx = -1;
                    dz = 0;
                    meta = 3;
                    ladderFacing = EnumFacing.EAST;
                    break;
                }
                case 3: {
                    xoffset = sizeX - 2;
                    zoffset = 1;
                    dx = 0;
                    dz = -1;
                    meta = 1;
                    ladderFacing = EnumFacing.SOUTH;
                }
            }
            world.func_175698_g((BlockPos)p.func_181079_c(posX + xoffset, posY + 2, posZ + zoffset));
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset + dx, posY + 1, posZ + zoffset + dz), this.wallBlock.getState(), 2);
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY + 0, posZ + zoffset), BlockRotator.getWithFacing(this.ladder.getState(), ladderFacing), 2);
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY + 1, posZ + zoffset), BlockRotator.getWithFacing(this.ladder.getState(), ladderFacing), 2);
            world.func_180501_a((BlockPos)p.func_181079_c(posX + xoffset, posY + 2, posZ + zoffset), BlockRotator.getWithFacing(this.ladder.getState(), ladderFacing), 2);
        }
    }

    private void setCrateBlocks(World world, BlockPos.MutableBlockPos p, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        Random r = world.field_73012_v;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                float chestroll = r.nextFloat();
                BlockChest chest = null;
                if (chestroll <= 0.1f) {
                    chest = Blocks.field_150486_ae;
                }
                if (chest == null) {
                    for (int y = 0; y < sizeY; ++y) {
                        if (world.func_175623_d((BlockPos)p.func_181079_c(posX + x, posY + y - 1, posZ + z)) || !((double)r.nextFloat() > 0.5)) continue;
                        int index = r.nextInt(this.crateBlocks.length);
                        world.func_180501_a((BlockPos)p.func_181079_c(posX + x, posY + y, posZ + z), this.crateBlocks[index].getState(), 2);
                    }
                    continue;
                }
                int meta = r.nextInt(4);
                world.func_175656_a((BlockPos)p.func_181079_c(posX + x, posY, posZ + z), BlockRotator.getRotatedHorizontal(chest.func_176223_P(), meta));
                TileEntity tile = world.func_175625_s((BlockPos)p);
                if (tile == null || !(tile instanceof TileEntityChest)) continue;
                ((TileEntityChest)tile).func_189404_a(CHEST_LOOT, world.field_73012_v.nextLong());
            }
        }
    }
}

