/*
 * Decompiled with CFR 0.152.
 */
package techguns.world.dungeon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.tileentities.TGSpawnerTileEnt;
import techguns.world.dungeon.IDungeonPath;
import techguns.world.dungeon.TemplateSegment;
import techguns.world.dungeon.presets.IDungeonPreset;

public class MazeDungeonPath
implements IDungeonPath {
    Random rand;
    PathSegment[][][] dungeonVolume;
    List<PathSegment> dungeonList;
    private int nextRoomID = 1;
    int sX;
    int sY;
    int sZ;
    public int startSegmentCount = 1;
    public int startHeightLevel = 0;
    public float chanceStraight = 0.5f;
    public float chanceRamp = 0.25f;
    public float chanceRoom = 0.25f;
    public float chanceFork = 0.2f;
    public float chanceUp = 0.5f;
    public int minRoomArea = 4;
    public int maxRoomArea = 16;
    public int minRoomWidth = 2;
    public int maxRoomWidth = 5;
    public boolean usePillars = true;
    public boolean useFoundations = true;
    public boolean useRoof = false;
    public boolean useBottomLayer = false;
    public int entranceRampLength = 0;
    private int rampPlaced = 0;
    private int numSegments = 0;
    protected EnumFacing startFacing = null;
    protected BlockPos startPos = null;

    public MazeDungeonPath(int sX, int sY, int sZ, Random rand) {
        this.sX = sX;
        this.sY = sY;
        this.sZ = sZ;
        this.rand = rand;
        this.dungeonVolume = new PathSegment[sX][sY][sZ];
        this.dungeonList = new ArrayList<PathSegment>();
    }

    @Override
    public int getNumSegments() {
        return this.numSegments;
    }

    @Override
    public void generatePath() {
        int startZ;
        int startX;
        if (this.useBottomLayer) {
            --this.sY;
        }
        int startY = (this.sY + this.startHeightLevel) % this.sY;
        switch (this.rand.nextInt(4)) {
            case 0: {
                startX = 0;
                startZ = this.sZ / 2;
                this.startFacing = EnumFacing.func_176737_a((float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 1: {
                startX = this.sX - 1;
                startZ = this.sZ / 2;
                this.startFacing = EnumFacing.func_176737_a((float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case 2: {
                startX = this.sX / 2;
                startZ = 0;
                this.startFacing = EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            default: {
                startX = this.sX / 2;
                startZ = this.sZ - 1;
                this.startFacing = EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
        int startDir = this.startFacing.func_176736_b();
        this.entranceRampLength = Math.min(this.entranceRampLength, startY);
        this.startPos = new BlockPos(startX, startY, startZ);
        this.generateSegment(startX, startY, startZ, startDir, null);
    }

    @Override
    public EnumFacing getEntranceRotation() {
        return this.startFacing;
    }

    @Override
    public BlockPos getStartPos() {
        return this.startPos;
    }

    @Override
    public void generateSegment(int x, int y, int z, int dir, PathSegment prev) {
        Vec3i elevPos;
        int dy;
        int nextDir;
        EnumFacing facing = EnumFacing.func_176731_b((int)dir);
        PathSegment segment = new PathSegment(x, y, z);
        if (prev != null) {
            segment.setConnection(facing.func_176734_d(), true);
            prev.setConnection(facing, true);
        } else {
            segment.isEntrance = true;
        }
        this.addSegment(segment);
        int maxRolls = 3;
        int roll = 0;
        boolean success = false;
        boolean canRollAgain = true;
        boolean fork = false;
        if (this.rampPlaced < this.entranceRampLength) {
            nextDir = dir;
            Vec3i nextPos = segment.getNextPos(nextDir);
            EnumFacing nextFacing = EnumFacing.func_176731_b((int)nextDir);
            Vec3i offset = nextFacing.func_176730_m();
            dy = -1;
            elevPos = new Vec3i(x, y + dy, z);
            Vec3i elevNextPos = new Vec3i(x + offset.func_177958_n(), y + dy, z + offset.func_177952_p());
            if (this.isWithinBounds(nextPos) && this.isWithinBounds(elevNextPos)) {
                PathSegment rampDummy = new PathSegment(elevPos.func_177958_n(), elevPos.func_177956_o(), elevPos.func_177952_p());
                this.addSegment(rampDummy);
                segment.isRamp = true;
                rampDummy.isRamp = true;
                segment.elevation = -1;
                rampDummy.elevation = 1;
                rampDummy.rampRotation = nextFacing.func_176734_d().func_176736_b();
                this.generateSegment(elevNextPos.func_177958_n(), elevNextPos.func_177956_o(), elevNextPos.func_177952_p(), nextDir, rampDummy);
                success = true;
            }
            ++this.rampPlaced;
        }
        while (!success && roll++ < maxRolls) {
            if (segment.isEntrance) {
                nextDir = dir;
                canRollAgain = false;
            } else {
                nextDir = this.getRandomDir(dir);
            }
            EnumFacing nextFacing = EnumFacing.func_176731_b((int)nextDir);
            Vec3i nextPos = segment.getNextPos(nextDir);
            if (this.isWithinBounds(nextPos)) {
                if (dir == nextDir && !segment.isEntrance && !fork && this.rand.nextFloat() < this.chanceRamp) {
                    float f = this.rand.nextFloat();
                    dy = f < this.chanceUp ? 1 : -1;
                    elevPos = new Vec3i(x, y + dy, z);
                    if (this.isWithinBounds(elevPos) && !this.isOccupied(elevPos)) {
                        Vec3i offset = nextFacing.func_176730_m();
                        Vec3i elevNextPos = new Vec3i(x + offset.func_177958_n(), y + dy, z + offset.func_177952_p());
                        boolean cont = false;
                        if (!this.isOccupied(elevNextPos)) {
                            success = true;
                            cont = true;
                        } else {
                            PathSegment seg = this.get(elevNextPos);
                            if (seg != null && !seg.isRamp && !seg.isEntrance) {
                                seg.setConnection(nextFacing.func_176734_d(), true);
                                success = true;
                                cont = false;
                            }
                        }
                        if (success) {
                            canRollAgain = false;
                            PathSegment rampDummy = new PathSegment(elevPos.func_177958_n(), elevPos.func_177956_o(), elevPos.func_177952_p());
                            this.addSegment(rampDummy);
                            segment.isRamp = true;
                            rampDummy.isRamp = true;
                            if (dy == 1) {
                                segment.elevation = 1;
                                rampDummy.elevation = -1;
                                segment.rampRotation = nextDir;
                            } else {
                                segment.elevation = -1;
                                rampDummy.elevation = 1;
                                rampDummy.rampRotation = nextFacing.func_176734_d().func_176736_b();
                            }
                            if (cont) {
                                this.generateSegment(elevNextPos.func_177958_n(), elevNextPos.func_177956_o(), elevNextPos.func_177952_p(), nextDir, rampDummy);
                            }
                        }
                    }
                } else if (!this.isOccupied(nextPos)) {
                    if (this.rand.nextFloat() < this.chanceRoom) {
                        int area = this.minRoomArea + this.rand.nextInt(this.maxRoomArea - this.minRoomArea);
                        boolean b = this.tryGrowRoom(nextPos, segment, nextFacing, this.minRoomWidth + this.rand.nextInt(this.maxRoomWidth - this.minRoomWidth), this.minRoomWidth + this.rand.nextInt(this.maxRoomWidth - this.minRoomWidth), area);
                        if (b) {
                            success = true;
                        } else {
                            this.generateSegment(nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p(), nextDir, segment);
                            success = true;
                        }
                    } else {
                        this.generateSegment(nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p(), nextDir, segment);
                        success = true;
                    }
                } else {
                    PathSegment seg = this.get(nextPos);
                    if (seg != null && !seg.isRamp && !seg.isEntrance) {
                        segment.setConnection(nextFacing, true);
                        seg.setConnection(EnumFacing.func_176731_b((int)nextDir).func_176734_d(), true);
                        success = true;
                    }
                }
            }
            if (!success || !canRollAgain || !(this.rand.nextFloat() < this.chanceFork)) continue;
            success = false;
            fork = true;
        }
    }

    private boolean tryGrowRoom(Vec3i pos, PathSegment prev, EnumFacing dir, int maxWidth, int maxLength, int preferredArea) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Vec3i vFront = dir.func_176730_m();
        Vec3i vRight = dir.func_176746_e().func_176730_m();
        Vec3i vLeft = dir.func_176735_f().func_176730_m();
        int bestl = 0;
        int bestw_l = 0;
        int bestw_r = 0;
        float bestValue = Float.MAX_VALUE;
        int maxw_l = Integer.MAX_VALUE;
        int maxw_r = Integer.MAX_VALUE;
        boolean stopL = false;
        for (int l = 0; l < maxLength && !stopL; ++l) {
            float aspect_ratio;
            Vec3i pos_;
            Vec3i posF = new Vec3i(x + vFront.func_177958_n() * l, y, z + vFront.func_177952_p() * l);
            if (!this.isWithinBounds(posF) || this.isOccupied(posF)) {
                stopL = true;
                break;
            }
            boolean stop = false;
            int w_l = 0;
            int w_r = 0;
            while (w_l < maxWidth && w_l < maxw_l && !stop) {
                pos_ = new Vec3i(x + vLeft.func_177958_n() * (w_l + 1) + vFront.func_177958_n() * l, y, z + vLeft.func_177952_p() * (w_l + 1) + vFront.func_177952_p() * l);
                if (!this.isWithinBounds(pos_) || this.isOccupied(pos_)) {
                    stop = true;
                    maxw_l = w_l;
                    continue;
                }
                ++w_l;
            }
            stop = false;
            while (w_r < maxWidth && w_r < maxw_r && !stop) {
                pos_ = new Vec3i(x + vRight.func_177958_n() * (w_r + 1) + vFront.func_177958_n() * l, y, z + vRight.func_177952_p() * (w_r + 1) + vFront.func_177952_p() * l);
                if (!this.isWithinBounds(pos_) || this.isOccupied(pos_)) {
                    stop = true;
                    maxw_r = w_r;
                    continue;
                }
                ++w_r;
            }
            int area = (w_l + w_r + 1) * (l + 1);
            float area_ratio = (float)Math.max(area, preferredArea) / (float)Math.min(area, preferredArea);
            float value = area_ratio + (aspect_ratio = (float)Math.max(w_l + w_r + 1, l + 1) / (float)Math.min(w_l + w_r + 1, l + 1));
            if (!(value < bestValue)) continue;
            bestValue = value;
            bestl = l;
            bestw_l = w_l;
            bestw_r = w_r;
        }
        if (bestl < 2 || bestw_l + bestw_r + 1 < 2) {
            return false;
        }
        Vec3i p1 = new Vec3i(x + vLeft.func_177958_n() * bestw_l, y, z + vLeft.func_177952_p() * bestw_l);
        Vec3i p2 = new Vec3i(x + vRight.func_177958_n() * bestw_r + vFront.func_177958_n() * bestl, y, z + vRight.func_177952_p() * bestw_r + vFront.func_177952_p() * bestl);
        Vec3i min = new Vec3i(Math.min(p1.func_177958_n(), p2.func_177958_n()), y, Math.min(p1.func_177952_p(), p2.func_177952_p()));
        Vec3i max = new Vec3i(Math.max(p1.func_177958_n(), p2.func_177958_n()), y, Math.max(p1.func_177952_p(), p2.func_177952_p()));
        if (!this.isWithinBounds(min) || !this.isWithinBounds(max)) {
            System.out.println("What is this shit?");
            System.out.println(min.toString());
            System.out.println(max.toString());
        }
        this.placeRoomSegments(min, max);
        prev.setConnection(dir, true);
        PathSegment segment = this.get(pos);
        if (segment != null) {
            segment.setConnection(dir.func_176734_d(), true);
        } else {
            System.out.println("shit");
        }
        return true;
    }

    private void placeRoomSegments(Vec3i min, Vec3i max) {
        int x;
        EnumFacing facing;
        PathSegment segment;
        Vec3i pos_;
        int z;
        int i;
        int roomID = this.nextRoomID++;
        int y = min.func_177956_o();
        for (int x2 = min.func_177958_n(); x2 <= max.func_177958_n(); ++x2) {
            for (int z2 = min.func_177952_p(); z2 <= max.func_177952_p(); ++z2) {
                PathSegment segment2 = new PathSegment(x2, y, z2);
                segment2.roomID = roomID;
                this.addSegment(segment2);
                if (x2 > min.func_177958_n()) {
                    segment2.setConnection(7, true);
                }
                if (x2 < max.func_177958_n()) {
                    segment2.setConnection(3, true);
                }
                if (z2 > min.func_177952_p()) {
                    segment2.setConnection(1, true);
                }
                if (z2 < max.func_177952_p()) {
                    segment2.setConnection(5, true);
                }
                if (x2 != min.func_177958_n() && z2 != min.func_177952_p()) {
                    segment2.setConnection(0, true);
                }
                if (x2 != min.func_177958_n() && z2 != max.func_177952_p()) {
                    segment2.setConnection(6, true);
                }
                if (x2 != max.func_177958_n() && z2 != min.func_177952_p()) {
                    segment2.setConnection(2, true);
                }
                if (x2 == max.func_177958_n() || z2 == max.func_177952_p()) continue;
                segment2.setConnection(4, true);
            }
        }
        int length = max.func_177952_p() - min.func_177952_p() + 1;
        int numDoors = this.rand.nextInt(length);
        for (i = 0; i < numDoors; ++i) {
            z = this.rand.nextInt(length);
            pos_ = new Vec3i(min.func_177958_n(), y, min.func_177952_p() + z);
            segment = this.get(pos_);
            facing = EnumFacing.WEST;
            this.placeDoor(new Vec3i(pos_.func_177958_n(), y, pos_.func_177952_p()), facing, segment);
        }
        numDoors = this.rand.nextInt(length);
        for (i = 0; i < numDoors; ++i) {
            z = this.rand.nextInt(length);
            pos_ = new Vec3i(max.func_177958_n(), y, min.func_177952_p() + z);
            segment = this.get(pos_);
            facing = EnumFacing.EAST;
            this.placeDoor(new Vec3i(pos_.func_177958_n(), y, pos_.func_177952_p()), facing, segment);
        }
        length = max.func_177958_n() - min.func_177958_n() + 1;
        numDoors = this.rand.nextInt(length);
        for (i = 0; i < numDoors; ++i) {
            x = this.rand.nextInt(length);
            pos_ = new Vec3i(min.func_177958_n() + x, y, min.func_177952_p());
            segment = this.get(pos_);
            facing = EnumFacing.NORTH;
            this.placeDoor(new Vec3i(pos_.func_177958_n(), y, pos_.func_177952_p()), facing, segment);
        }
        numDoors = this.rand.nextInt(length);
        for (i = 0; i < numDoors; ++i) {
            x = this.rand.nextInt(length);
            pos_ = new Vec3i(min.func_177958_n() + x, y, max.func_177952_p());
            segment = this.get(pos_);
            facing = EnumFacing.SOUTH;
            this.placeDoor(new Vec3i(pos_.func_177958_n(), y, pos_.func_177952_p()), facing, segment);
        }
    }

    private void placeDoor(Vec3i pos, EnumFacing facing, PathSegment segment) {
        Vec3i offset = facing.func_176730_m();
        Vec3i nextPos = new Vec3i(pos.func_177958_n() + offset.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + offset.func_177952_p());
        if (this.isWithinBounds(nextPos)) {
            if (!this.isOccupied(nextPos)) {
                this.generateSegment(nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p(), facing.func_176736_b(), segment);
            } else {
                PathSegment seg = this.get(nextPos);
                if (seg != null && !seg.isRamp && !seg.isEntrance) {
                    segment.setConnection(facing, true);
                    seg.setConnection(facing.func_176734_d(), true);
                }
            }
        }
    }

    @Deprecated
    private PathSegment addRoomSegment(Vec3i pos, EnumFacing dir, int l, int w_l, int w_r, int maxL, int maxW_l, int maxW_r) {
        PathSegment segment = new PathSegment(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.addSegment(segment);
        int baseRot = (dir.func_176736_b() + 2) % 4 * 2 + 1;
        if (maxW_r == 0 && w_l > 0) {
            w_r = 1;
        }
        if (maxW_l == 0 && w_r > 0) {
            w_l = 1;
        }
        if (l > 0) {
            segment.setConnection(dir.func_176734_d(), true);
            if (w_l < maxW_l) {
                segment.setConnection((baseRot + 5) % 8, true);
            }
            if (w_r < maxW_r) {
                segment.setConnection((baseRot + 3) % 8, true);
            }
        }
        if (l < maxL) {
            segment.setConnection(dir, true);
            if (w_l < maxW_l) {
                segment.setConnection((baseRot + 7) % 8, true);
            }
            if (w_r < maxW_r) {
                segment.setConnection((baseRot + 1) % 8, true);
            }
        }
        if (w_l < maxW_l) {
            segment.setConnection((baseRot + 6) % 8, true);
        }
        if (w_r < maxW_r) {
            segment.setConnection((baseRot + 2) % 8, true);
        }
        return segment;
    }

    private int countFreeSpaceInDir(Vec3i pos, EnumFacing dir) {
        Vec3i offset = dir.func_176730_m();
        int i = 0;
        while (this.isWithinBounds(pos) && !this.isOccupied(pos)) {
            pos = new Vec3i(pos.func_177958_n() + offset.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + offset.func_177952_p());
            ++i;
        }
        return i;
    }

    private void addSegment(PathSegment seg) {
        if (seg.x >= 0 && seg.x < this.sX && seg.y >= 0 && seg.y < this.sY && seg.z >= 0 && seg.z < this.sZ) {
            this.dungeonVolume[seg.x][seg.y][seg.z] = seg;
            this.dungeonList.add(seg);
            ++this.numSegments;
        }
    }

    private boolean isOccupied(Vec3i pos) {
        return this.dungeonVolume[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] != null;
    }

    private int getRandomDir(int dir) {
        float f = this.rand.nextFloat();
        if (f < this.chanceStraight) {
            return dir;
        }
        if (f < this.chanceStraight + (1.0f - this.chanceStraight) * 0.5f) {
            return EnumFacing.func_176731_b((int)dir).func_176746_e().func_176736_b();
        }
        return EnumFacing.func_176731_b((int)dir).func_176735_f().func_176736_b();
    }

    private boolean isWithinBounds(Vec3i pos) {
        if (this.entranceRampLength > this.rampPlaced) {
            return pos.func_177958_n() >= 0 && pos.func_177958_n() < this.sX && pos.func_177956_o() >= 0 && pos.func_177956_o() < this.sY && pos.func_177952_p() >= 0 && pos.func_177952_p() < this.sZ;
        }
        return pos.func_177958_n() >= 0 && pos.func_177958_n() < this.sX && pos.func_177956_o() >= 0 && pos.func_177956_o() < this.sY - this.entranceRampLength && pos.func_177952_p() >= 0 && pos.func_177952_p() < this.sZ;
    }

    private PathSegment get(Vec3i index) {
        return this.dungeonVolume[index.func_177958_n()][index.func_177956_o()][index.func_177952_p()];
    }

    @Override
    public void generateDungeon(World world, int posX, int posY, int posZ, IDungeonPreset preset) {
        if (this.useBottomLayer) {
            this.cloneBottomLayer();
        }
        for (int i = 0; i < this.sX; ++i) {
            for (int j = 0; j < this.sY; ++j) {
                for (int k = 0; k < this.sZ; ++k) {
                    int px;
                    PathSegment segment;
                    boolean above = false;
                    for (int y = j + 1; y < this.sY; ++y) {
                        if (this.dungeonVolume[i][y][k] == null) continue;
                        above = true;
                        break;
                    }
                    boolean below = false;
                    boolean directlyBelow = false;
                    for (int y = j - 1; y >= 0; --y) {
                        if (this.dungeonVolume[i][y][k] == null) continue;
                        below = true;
                        if (y != j - 1) break;
                        directlyBelow = true;
                        break;
                    }
                    if ((segment = this.dungeonVolume[i][j][k]) != null) {
                        if (segment.isRamp) {
                            if (segment.elevation == 1) {
                                px = posX + i * preset.getSizeXZ();
                                int py = posY + j * preset.getSizeY();
                                int pz = posZ + k * preset.getSizeXZ();
                                int r = segment.getRampRotation();
                                if (r == 0 || r == 2) {
                                    r = (r + 2) % 4;
                                }
                                preset.getSegment(TemplateSegment.SegmentType.RAMP, segment.y, 0, this.sY, above, below, world.field_73012_v.nextInt()).placeSegment(world, px, py, pz, (r + 1) % 4);
                                continue;
                            }
                            int r = this.dungeonVolume[i][j - 1][k].getRampRotation();
                            if (r == 0 || r == 2) {
                                r = (r + 2) % 4;
                            }
                            if (!this.useRoof || above || segment.y + 1 >= this.sY) continue;
                            int px2 = posX + i * preset.getSizeXZ();
                            int py = posY + (j + 1) * preset.getSizeY();
                            int pz = posZ + k * preset.getSizeXZ();
                            int seed = segment.roomID > 0 ? segment.roomID : world.field_73012_v.nextInt();
                            preset.getSegment(TemplateSegment.SegmentType.END, -1, 0, this.sY, above, below, seed).placeSegment(world, px2, py, pz, (r + 1) % 4);
                            continue;
                        }
                        boolean ok = false;
                        for (TemplateSegment tempSeg : TemplateSegment.templateSegments.values()) {
                            int seed;
                            if (!tempSeg.match) continue;
                            boolean match = false;
                            int r = 0;
                            while (!match && r < tempSeg.rotations) {
                                if (segment.match(tempSeg.pattern, r)) {
                                    match = true;
                                    continue;
                                }
                                ++r;
                            }
                            if (!match) continue;
                            int px3 = posX + i * preset.getSizeXZ();
                            int py = posY + j * preset.getSizeY();
                            int pz = posZ + k * preset.getSizeXZ();
                            if (tempSeg.type == TemplateSegment.SegmentType.END && j == (this.sY + this.startHeightLevel) % this.sY) {
                                preset.getSegment(TemplateSegment.SegmentType.ENTRANCE, segment.y, 0, this.sY, above, below, world.field_73012_v.nextInt()).placeSegment(world, px3, py, pz, r);
                            } else {
                                seed = segment.roomID > 0 ? segment.roomID : world.field_73012_v.nextInt();
                                preset.getSegment(tempSeg.type, segment.y, 0, this.sY, above, below, seed).placeSegment(world, px3, py, pz, r);
                            }
                            ok = true;
                            if (!this.useRoof || above || segment.y < this.startHeightLevel || segment.y + 1 >= this.sY) break;
                            py = posY + (j + 1) * preset.getSizeY();
                            seed = segment.roomID > 0 ? segment.roomID : world.field_73012_v.nextInt();
                            preset.getSegment(tempSeg.type, -1, 0, this.sY, above, below, seed).placeSegment(world, px3, py, pz, r);
                            break;
                        }
                        if (ok) continue;
                        System.out.println("couldn't match segment " + segment.toString());
                        segment.printPattern();
                        continue;
                    }
                    if (this.useFoundations && above && !below) {
                        px = posX + i * preset.getSizeXZ();
                        int py = posY + j * preset.getSizeY();
                        int pz = posZ + k * preset.getSizeXZ();
                        preset.getSegment(TemplateSegment.SegmentType.FOUNDATION, j, 0, this.sY, above, below, world.field_73012_v.nextInt()).placeSegment(world, px, py, pz, 0);
                        continue;
                    }
                    if (this.usePillars && above) {
                        px = posX + i * preset.getSizeXZ();
                        int py = posY + j * preset.getSizeY();
                        int pz = posZ + k * preset.getSizeXZ();
                        preset.getSegment(TemplateSegment.SegmentType.PILLARS, j, 0, this.sY, above, below, world.field_73012_v.nextInt()).placeSegment(world, px, py, pz, 0);
                        continue;
                    }
                    if (this.useRoof && directlyBelow && above) continue;
                }
            }
        }
    }

    private void cloneBottomLayer() {
        PathSegment[][][] dungeonVolume2 = new PathSegment[this.sX][this.sY + 1][this.sZ];
        for (int i = 0; i < this.sX; ++i) {
            for (int j = 0; j < this.sY; ++j) {
                for (int k = 0; k < this.sZ; ++k) {
                    if (this.dungeonVolume[i][j][k] == null) continue;
                    dungeonVolume2[i][j + 1][k] = this.dungeonVolume[i][j][k];
                    ++dungeonVolume2[i][j + 1][k].y;
                    if (j != 0) continue;
                    PathSegment seg2 = new PathSegment(i, j, k);
                    PathSegment seg = this.dungeonVolume[i][j][k];
                    seg2.pattern = seg.pattern;
                    dungeonVolume2[i][j][k] = seg2;
                }
            }
        }
        this.dungeonVolume = dungeonVolume2;
        ++this.sY;
        this.startPos = new BlockPos(this.startPos.func_177958_n(), this.startPos.func_177956_o() + 1, this.startPos.func_177952_p());
    }

    @Override
    public void generateNPCSpawners(World world, int posX, int posY, int posZ, IDungeonPreset preset) {
        List<PathSegment> spawnPositions = this.getSpawnPositions(preset.getSpawnDensity());
        for (PathSegment seg : spawnPositions) {
            int pz;
            int py;
            int px = posX + (seg.x * preset.getSizeXZ() + (int)((float)preset.getSizeXZ() * 0.5f));
            BlockPos pos = new BlockPos(px, py = posY + seg.y * preset.getSizeY() + preset.getSpawnYOffset(seg), pz = posZ + (seg.z * preset.getSizeXZ() + (int)((float)preset.getSizeXZ() * 0.5f)));
            if (pos.func_177956_o() < 1) continue;
            IBlockState state = TGBlocks.MONSTER_SPAWNER.func_176223_P();
            world.func_180501_a(pos, state, 2);
            TileEntity te = world.func_175625_s(pos);
            if (te == null || !(te instanceof TGSpawnerTileEnt)) continue;
            TGSpawnerTileEnt spawner = (TGSpawnerTileEnt)te;
            preset.initSpawner(spawner);
        }
    }

    private List<PathSegment> getSpawnPositions(float spawnDensity) {
        int maxTries = 5;
        int tries = 0;
        int numSpawns = (int)((float)this.getNumSegments() * spawnDensity);
        ArrayList<PathSegment> spawners = new ArrayList<PathSegment>();
        while (numSpawns > 0 && tries < maxTries) {
            int index = this.rand.nextInt(this.dungeonList.size());
            PathSegment seg = this.dungeonList.get(index);
            if (seg != null && !spawners.contains(seg) && seg.allowSpawner()) {
                spawners.add(seg);
                --numSpawns;
                tries = 0;
                continue;
            }
            ++tries;
        }
        return spawners;
    }

    public class PathSegment {
        public boolean isEntrance;
        int x;
        int y;
        int z;
        boolean isRamp = false;
        int elevation = 0;
        int rampRotation = -1;
        int roomID = -1;
        boolean[] pattern = new boolean[8];

        public PathSegment(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec3i getNextPos(int dir) {
            Vec3i offset = EnumFacing.func_176731_b((int)dir).func_176730_m();
            return new Vec3i(this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p());
        }

        public Vec3i getNextPos(EnumFacing facing) {
            Vec3i offset = facing.func_176730_m();
            return new Vec3i(this.x + offset.func_177958_n(), this.y + offset.func_177956_o(), this.z + offset.func_177952_p());
        }

        public boolean connectionAt(int index) {
            return this.pattern[index];
        }

        public boolean connectionAt(EnumFacing facing) {
            int i = (facing.func_176736_b() + 2) % 4 * 2 + 1;
            return this.pattern[i];
        }

        public void setConnection(int index, boolean connected) {
            this.pattern[index] = connected;
        }

        public void setConnection(EnumFacing facing, boolean connected) {
            int i = (facing.func_176736_b() + 2) % 4 * 2 + 1;
            this.pattern[i] = connected;
        }

        public boolean match(boolean[] o, int rotations) {
            int i = rotations * 2;
            return this.pattern.length == 8 && o.length == 8 && this.pattern[0] == o[(i + 0) % 8] && this.pattern[1] == o[(i + 1) % 8] && this.pattern[2] == o[(i + 2) % 8] && this.pattern[3] == o[(i + 3) % 8] && this.pattern[4] == o[(i + 4) % 8] && this.pattern[5] == o[(i + 5) % 8] && this.pattern[6] == o[(i + 6) % 8] && this.pattern[7] == o[(i + 7) % 8];
        }

        public int getRampRotation() {
            return this.rampRotation;
        }

        public void printPattern() {
            StringBuilder sb = new StringBuilder();
            char t = '1';
            char f = '0';
            if (this.pattern[0]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            if (this.pattern[1]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            if (this.pattern[2]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            sb.append("\n");
            if (this.pattern[7]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            sb.append(" ");
            if (this.pattern[3]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            sb.append("\n");
            if (this.pattern[6]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            if (this.pattern[5]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            if (this.pattern[4]) {
                sb.append(t);
            } else {
                sb.append(f);
            }
            System.out.println(sb.toString());
        }

        public boolean allowSpawner() {
            return !this.isEntrance && !this.isRamp;
        }
    }
}

