/*
 * Decompiled with CFR 0.152.
 */
package techguns.world;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.world.BlockData;
import techguns.world.BlockRotator;
import techguns.world.dungeon.presets.specialblocks.SpecialBlockHandler;

public class Structure
implements Serializable {
    private static final long serialVersionUID = 2L;
    int sizeX;
    int sizeY;
    int sizeZ;
    List<MBlock> blocks = new ArrayList<MBlock>();
    HashMap<Integer, List<BlockEntry>> blockEntries = new HashMap();

    public void applySpecialMBlocks(ResourceLocation loottable) {
        SpecialBlockHandler.applySpecialMBlocks(this.blocks, loottable);
    }

    public Structure(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public static Structure scanBlocks(World world, BlockPos xyz, int sizeX, int sizeY, int sizeZ) {
        return Structure.scanBlocks(world, xyz.func_177958_n(), xyz.func_177956_o(), xyz.func_177952_p(), sizeX, sizeY, sizeZ);
    }

    public static Structure scanBlocks(World world, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        Structure structure = new Structure(sizeX, sizeY, sizeZ);
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    BlockPos bpos = new BlockPos(x + i, y + j, z + k);
                    int layer = BlockData.getBlockLayer(world.func_180495_p(bpos));
                    MBlock mblock = new MBlock(world.func_180495_p(bpos));
                    int index = structure.blocks.indexOf(mblock);
                    if (index < 0) {
                        structure.blocks.add(mblock);
                        index = structure.blocks.indexOf(mblock);
                    }
                    if (!structure.blockEntries.containsKey(layer)) {
                        structure.blockEntries.put(layer, new ArrayList());
                    }
                    Structure structure2 = structure;
                    structure2.getClass();
                    structure.blockEntries.get(layer).add(structure2.new BlockEntry(i, j, k, index));
                }
            }
        }
        return structure;
    }

    public void placeBlocks(World world, int x, int y, int z, int rotation) {
        Vec3d axis = new Vec3d((double)x + (double)this.sizeX * 0.5, (double)y, (double)z + (double)this.sizeZ * 0.5);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 5; ++i) {
            List<BlockEntry> blockList = this.blockEntries.get(i);
            if (blockList == null) continue;
            for (BlockEntry b : blockList) {
                MBlock mb = this.blocks.get(b.blockIndex);
                mpos.func_181079_c(x + b.x, y + b.y, z + b.z);
                if (mpos.func_177956_o() < 1) continue;
                BlockUtils.rotateAroundY(mpos, axis, rotation);
                IBlockState state = mb.getState();
                state = BlockRotator.getRotatedHorizontal(state, rotation);
                world.func_180501_a((BlockPos)mpos, state, 2);
                if (!mb.hasTileEntity()) continue;
                mb.tileEntityPostPlacementAction(world, state, (BlockPos)mpos, rotation);
            }
        }
    }

    class BlockEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int x;
        int y;
        int z;
        int blockIndex;

        public BlockEntry(int x, int y, int z, int blockIndex) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockIndex = blockIndex;
        }
    }
}

