/*
 * Decompiled with CFR 0.152.
 */
package techguns.world;

import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import techguns.blocks.BlockTGDoor3x3;

public class BlockRotator {
    public static IBlockState getRotatedHorizontal(IBlockState state, int times) {
        if (state.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D)) {
            return BlockRotator.getRotatedWithProperty(state, times, BlockHorizontal.field_185512_D);
        }
        if (state.func_177228_b().containsKey((Object)BlockDirectional.field_176387_N)) {
            return BlockRotator.getRotatedWithProperty(state, times, BlockDirectional.field_176387_N);
        }
        if (state.func_177228_b().containsKey((Object)BlockTorch.field_176596_a)) {
            return BlockRotator.getRotatedWithProperty(state, times, BlockTorch.field_176596_a);
        }
        if (state.func_177228_b().containsKey((Object)BlockLever.field_176360_a)) {
            return BlockRotator.getRotatedLever(state, times);
        }
        if (state.func_177228_b().containsKey((Object)BlockTGDoor3x3.ZPLANE)) {
            return BlockRotator.rotateBooleanPlane(state, times, BlockTGDoor3x3.ZPLANE);
        }
        if (state.func_177228_b().containsKey((Object)BlockLog.field_176299_a) && (times == 1 || times == 3)) {
            if (state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.X) {
                return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
            }
            if (state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.Z) {
                return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
            }
        }
        return state;
    }

    public static IBlockState getWithFacing(IBlockState state, EnumFacing target) {
        if (state.func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D)) {
            return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)target);
        }
        if (state.func_177228_b().containsKey((Object)BlockDirectional.field_176387_N)) {
            return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)target);
        }
        if (state.func_177228_b().containsKey((Object)BlockTorch.field_176596_a)) {
            return state.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)target);
        }
        return state;
    }

    protected static IBlockState getRotatedWithProperty(IBlockState state, int times, PropertyDirection property) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)property);
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            while (times-- > 0) {
                facing = facing.func_176735_f();
            }
        }
        return state.func_177226_a((IProperty)property, (Comparable)facing);
    }

    protected static IBlockState rotateBooleanPlane(IBlockState state, int times, PropertyBool property) {
        boolean plane = (Boolean)state.func_177229_b((IProperty)property);
        if (times % 2 == 0) {
            return state;
        }
        return state.func_177226_a((IProperty)property, (Comparable)Boolean.valueOf(!plane));
    }

    protected static IBlockState getRotatedLever(IBlockState state, int times) {
        BlockLever.EnumOrientation rot = (BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a);
        block10: while (times-- > 0) {
            switch (rot) {
                case DOWN_X: {
                    rot = BlockLever.EnumOrientation.DOWN_Z;
                    continue block10;
                }
                case DOWN_Z: {
                    rot = BlockLever.EnumOrientation.DOWN_X;
                    continue block10;
                }
                case EAST: {
                    rot = BlockLever.EnumOrientation.NORTH;
                    continue block10;
                }
                case NORTH: {
                    rot = BlockLever.EnumOrientation.WEST;
                    continue block10;
                }
                case SOUTH: {
                    rot = BlockLever.EnumOrientation.EAST;
                    continue block10;
                }
                case UP_X: {
                    rot = BlockLever.EnumOrientation.UP_Z;
                    continue block10;
                }
                case UP_Z: {
                    rot = BlockLever.EnumOrientation.UP_X;
                    continue block10;
                }
                case WEST: {
                    rot = BlockLever.EnumOrientation.SOUTH;
                    continue block10;
                }
            }
        }
        return state.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)rot);
    }
}

