/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.util.MBlock;
import techguns.world.BlockRotator;
import techguns.world.EnumLootType;
import techguns.world.structures.WorldgenStructure;

public class MultiMBlock
extends MBlock {
    protected Block[] blocks;
    protected int[] metas;
    protected int[] weights;
    protected IBlockState[] states;
    protected int totalWeight;

    public MultiMBlock(Block[] blocks, int[] metas, int[] weights) {
        super(blocks[0], metas[0]);
        this.blocks = blocks;
        this.metas = metas;
        this.weights = weights;
        this.states = new IBlockState[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            this.states[i] = blocks[i].func_176203_a(metas[i]);
        }
        this.calcTotalweight();
    }

    private void calcTotalweight() {
        this.totalWeight = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            this.totalWeight += this.weights[i];
        }
    }

    @Override
    public void setBlock(World w, BlockPos.MutableBlockPos pos, int rotation, EnumLootType loottype, WorldgenStructure.BiomeColorType biome) {
        int index = this.rollBlockIndex(w.field_73012_v);
        IBlockState targetState = BlockRotator.getRotatedHorizontal(this.states[index], rotation);
        w.func_175656_a((BlockPos)pos, targetState);
        if (this.hasTileEntity) {
            this.tileEntityPostPlacementAction(w, targetState, (BlockPos)pos, rotation);
        }
    }

    protected int rollBlockIndex(Random rnd) {
        int roll = rnd.nextInt(this.totalWeight + 1);
        int sum = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            if (roll > (sum += this.weights[i])) continue;
            return i;
        }
        return this.weights.length;
    }
}

