/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackOreDict {
    public String oreDictName;
    public int stackSize;
    public ItemStack item;
    public boolean strict = false;
    public static final ItemStackOreDict EMPTY = new ItemStackOreDict();

    public ItemStackOreDict(String oreDictName, int stackSize) {
        this.oreDictName = oreDictName;
        this.stackSize = stackSize;
        this.item = ItemStack.field_190927_a;
    }

    public ItemStackOreDict(String oreDictName) {
        this.oreDictName = oreDictName;
        this.stackSize = 1;
        this.item = ItemStack.field_190927_a;
    }

    private ItemStackOreDict() {
        this.oreDictName = null;
        this.stackSize = 1;
        this.item = ItemStack.field_190927_a;
    }

    public ItemStackOreDict(ItemStack item, int stackSize) {
        this.stackSize = stackSize;
        this.item = item;
        this.oreDictName = null;
    }

    public ItemStackOreDict(ItemStack item) {
        if (item != null) {
            this.stackSize = item.func_190916_E();
            this.item = item;
            this.oreDictName = null;
        } else {
            this.stackSize = 0;
            this.item = ItemStack.field_190927_a;
            this.oreDictName = null;
        }
    }

    public boolean hasItems() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.oreDictName != null) {
            return !OreDictionary.getOres((String)this.oreDictName, (boolean)true).isEmpty();
        }
        return !this.item.func_190926_b();
    }

    public boolean isOreDict() {
        return this.oreDictName != null;
    }

    public ItemStackOreDict setNoStrictMode() {
        this.strict = false;
        return this;
    }

    public ItemStackOreDict setStrictMode() {
        this.strict = true;
        return this;
    }

    public boolean isEmpty() {
        return this.oreDictName == null && this.item.func_190926_b();
    }

    public boolean isEqualWithOreDict(ItemStack other) {
        if (this.oreDictName == null) {
            return OreDictionary.itemMatches((ItemStack)this.item, (ItemStack)other, (boolean)this.strict);
        }
        ArrayList<ItemStack> items = this.getItemStacks();
        for (int i = 0; i < items.size(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)items.get(i), (ItemStack)other, (boolean)this.strict)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getItemStacks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.oreDictName == null) {
            if (!this.item.func_190926_b()) {
                list.add(new ItemStack(this.item.func_77973_b(), this.stackSize, this.item.func_77952_i()));
            }
        } else {
            OreDictionary.getOres((String)this.oreDictName).forEach(s -> {
                ItemStack stack = s.func_77946_l();
                stack.func_190920_e(this.stackSize);
                list.add(stack);
            });
        }
        return list;
    }

    public ArrayList<ItemStack> getItemStacks(int amountOverride) {
        ArrayList<ItemStack> list = this.getItemStacks();
        list.forEach(s -> s.func_190920_e(amountOverride));
        return list;
    }

    public String toString() {
        if (this.oreDictName != null) {
            return "ItemStackOreDict:" + this.oreDictName;
        }
        if (!this.item.func_190926_b()) {
            return this.item.toString();
        }
        return "EMPTY_ItemStackOreDict";
    }

    public boolean matches(ItemStackOreDict other) {
        if (this.oreDictName != null && other.oreDictName != null) {
            return this.oreDictName.equals(other.oreDictName);
        }
        if (this.oreDictName != null) {
            return this.isEqualWithOreDict(other.item);
        }
        if (other.oreDictName != null) {
            return other.isEqualWithOreDict(this.item);
        }
        return OreDictionary.itemMatches((ItemStack)this.item, (ItemStack)other.item, (boolean)false);
    }

    public boolean matches(ItemStack other) {
        return this.matches(new ItemStackOreDict(other, other.func_190916_E()));
    }
}

