/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import techguns.TGArmors;
import techguns.items.armors.GenericArmor;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.util.ItemUtil;

public class UpgradeBenchRecipes {
    public static ArrayList<UpgradeBenchRecipe> recipes = new ArrayList();

    public static void addRecipe(ItemStack upgradeItem, Enchantment ench, int level) {
        recipes.add(new UpgradeBenchRecipe(upgradeItem, ench, level));
    }

    @Nullable
    public static UpgradeBenchRecipe getUpgradeRecipeFor(ItemStack armor, ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).matches(armor, item)) continue;
            return recipes.get(i);
        }
        return null;
    }

    @Nullable
    public static UpgradeBenchRecipe getUpgradeRecipeForUpgradeItem(ItemStack item) {
        for (int i = 0; i < recipes.size(); ++i) {
            if (!recipes.get(i).matchesUpgradeItem(item)) continue;
            return recipes.get(i);
        }
        return null;
    }

    public static class UpgradeBenchRecipe
    implements IMachineRecipe {
        protected ItemStack upgradeItem;
        protected Enchantment ench;
        protected int level;

        public UpgradeBenchRecipe(ItemStack upgradeItem, Enchantment ench, int level) {
            this.upgradeItem = upgradeItem;
            this.ench = ench;
            this.level = level;
        }

        public boolean isValidItemInput(ItemStack item) {
            if (!item.func_190926_b() && item.func_77973_b() instanceof GenericArmor) {
                return this.ench.func_92089_a(item);
            }
            return false;
        }

        public boolean matches(ItemStack armor, ItemStack item) {
            return this.isValidItemInput(armor) && this.matchesUpgradeItem(item);
        }

        public boolean matchesUpgradeItem(ItemStack item) {
            return ItemUtil.isItemEqual(this.upgradeItem, item);
        }

        public Enchantment getEnch() {
            return this.ench;
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public List<List<ItemStack>> getItemInputs() {
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
            ArrayList armors = new ArrayList();
            TGArmors.armors.forEach(a -> {
                ItemStack stack = new ItemStack((Item)a, 1);
                if (this.ench.func_92089_a(stack)) {
                    armors.add(stack);
                }
            });
            inputs.add(armors);
            inputs.add((List<ItemStack>)NonNullList.func_191197_a((int)1, (Object)this.upgradeItem));
            return inputs;
        }

        @Override
        public List<List<ItemStack>> getItemOutputs() {
            ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
            ArrayList armors = new ArrayList();
            TGArmors.armors.forEach(a -> {
                ItemStack stack = new ItemStack((Item)a, 1);
                if (this.ench.func_92089_a(stack)) {
                    Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    map.put(this.getEnch(), this.getLevel());
                    EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
                    armors.add(stack);
                }
            });
            outputs.add(armors);
            return outputs;
        }
    }
}

