/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class MachineOperation {
    protected ArrayList<ItemStack> inputs = null;
    protected ArrayList<ItemStack> outputs = null;
    protected ArrayList<FluidStack> fluid_inputs = null;
    protected ArrayList<FluidStack> fluid_outputs = null;
    protected int stackMultiplier = 1;
    protected int time = 100;
    protected int powerPerTick = 0;

    public MachineOperation(ItemStack output, ItemStack ... inputs) {
        this.outputs = new ArrayList();
        this.outputs.add(output);
        this.inputs = new ArrayList();
        Arrays.stream(inputs).forEach(i -> this.inputs.add((ItemStack)i));
    }

    public MachineOperation(ItemStack output, FluidStack fluidOut, ItemStack ... inputs) {
        this.outputs = new ArrayList();
        this.outputs.add(output);
        this.inputs = new ArrayList();
        Arrays.stream(inputs).forEach(i -> this.inputs.add((ItemStack)i));
        this.fluid_outputs = new ArrayList();
        this.fluid_outputs.add(fluidOut);
    }

    public MachineOperation(FluidStack fluidOut, ItemStack ... inputs) {
        this.inputs = new ArrayList();
        Arrays.stream(inputs).forEach(i -> this.inputs.add((ItemStack)i));
        this.fluid_outputs = new ArrayList();
        this.fluid_outputs.add(fluidOut);
    }

    public MachineOperation(ArrayList<ItemStack> inputs, ArrayList<ItemStack> outputs, ArrayList<FluidStack> fluid_inputs, ArrayList<FluidStack> fluid_outputs, int stackMultiplier) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fluid_outputs = fluid_outputs;
        this.fluid_inputs = fluid_inputs;
        this.stackMultiplier = stackMultiplier;
    }

    public MachineOperation setStackMultiplier(int mult) {
        this.stackMultiplier = mult;
        return this;
    }

    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    public int getPowerPerTick() {
        return this.powerPerTick * this.stackMultiplier;
    }

    public void setPowerPerTick(int powerPerTick) {
        this.powerPerTick = powerPerTick;
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound fluidTag;
        NBTTagCompound itemTag;
        int i;
        NBTTagList nbtTagList;
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74774_a("stackMultiplier", (byte)this.stackMultiplier);
        tags.func_74768_a("powerPerTick", this.powerPerTick);
        if (this.inputs != null && this.inputs.size() > 0) {
            nbtTagList = new NBTTagList();
            for (i = 0; i < this.inputs.size(); ++i) {
                if (this.inputs.get(i).func_190926_b()) continue;
                itemTag = new NBTTagCompound();
                this.inputs.get(i).func_77955_b(itemTag);
                nbtTagList.func_74742_a((NBTBase)itemTag);
            }
            tags.func_74782_a("InputItems", (NBTBase)nbtTagList);
            tags.func_74774_a("InputSize", (byte)this.inputs.size());
        }
        if (this.outputs != null && this.outputs.size() > 0) {
            nbtTagList = new NBTTagList();
            for (i = 0; i < this.outputs.size(); ++i) {
                if (this.outputs.get(i).func_190926_b()) continue;
                itemTag = new NBTTagCompound();
                this.outputs.get(i).func_77955_b(itemTag);
                nbtTagList.func_74742_a((NBTBase)itemTag);
            }
            tags.func_74782_a("OutputItems", (NBTBase)nbtTagList);
            tags.func_74774_a("OutputSize", (byte)this.outputs.size());
        }
        if (this.fluid_inputs != null && this.fluid_inputs.size() > 0) {
            nbtTagList = new NBTTagList();
            for (i = 0; i < this.fluid_inputs.size(); ++i) {
                if (this.fluid_inputs.get(i) == null) continue;
                fluidTag = new NBTTagCompound();
                this.fluid_inputs.get(i).writeToNBT(fluidTag);
                nbtTagList.func_74742_a((NBTBase)fluidTag);
            }
            tags.func_74782_a("FluidsIn", (NBTBase)nbtTagList);
            tags.func_74774_a("FluidSizeIn", (byte)this.fluid_inputs.size());
        }
        if (this.fluid_outputs != null && this.fluid_outputs.size() > 0) {
            nbtTagList = new NBTTagList();
            for (i = 0; i < this.fluid_outputs.size(); ++i) {
                if (this.fluid_outputs.get(i) == null) continue;
                fluidTag = new NBTTagCompound();
                this.fluid_outputs.get(i).writeToNBT(fluidTag);
                nbtTagList.func_74742_a((NBTBase)fluidTag);
            }
            tags.func_74782_a("Fluids", (NBTBase)nbtTagList);
            tags.func_74774_a("FluidSize", (byte)this.fluid_outputs.size());
        }
        this.writeSubclassDataToNBT(tags);
        compound.func_74782_a("operation", (NBTBase)tags);
    }

    protected void writeSubclassDataToNBT(NBTTagCompound tags) {
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound fluidTags;
        NBTTagCompound itemTags;
        int i;
        NBTTagList tagList;
        int size;
        NBTTagCompound tags = compound.func_74775_l("operation");
        this.stackMultiplier = tags.func_74771_c("stackMultiplier");
        this.powerPerTick = tags.func_74762_e("powerPerTick");
        if (tags.func_74764_b("InputSize")) {
            if (this.inputs != null) {
                this.inputs.clear();
            } else {
                this.inputs = new ArrayList();
            }
            size = tags.func_74771_c("InputSize");
            tagList = tags.func_150295_c("InputItems", 10);
            for (i = 0; i < size; ++i) {
                itemTags = tagList.func_150305_b(i);
                this.inputs.add(new ItemStack(itemTags));
            }
        }
        if (tags.func_74764_b("OutputSize")) {
            if (this.outputs != null) {
                this.outputs.clear();
            } else {
                this.outputs = new ArrayList();
            }
            size = tags.func_74771_c("OutputSize");
            tagList = tags.func_150295_c("OutputItems", 10);
            for (i = 0; i < size; ++i) {
                itemTags = tagList.func_150305_b(i);
                this.outputs.add(new ItemStack(itemTags));
            }
        }
        if (tags.func_74764_b("FluidSizeIn")) {
            if (this.fluid_inputs != null) {
                this.fluid_inputs.clear();
            } else {
                this.fluid_inputs = new ArrayList();
            }
            size = tags.func_74771_c("FluidSizeIn");
            tagList = tags.func_150295_c("FluidsIn", 10);
            for (i = 0; i < size; ++i) {
                fluidTags = tagList.func_150305_b(i);
                this.fluid_inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTags));
            }
        }
        if (tags.func_74764_b("FluidSize")) {
            if (this.fluid_outputs != null) {
                this.fluid_outputs.clear();
            } else {
                this.fluid_outputs = new ArrayList();
            }
            size = tags.func_74771_c("FluidSize");
            tagList = tags.func_150295_c("Fluids", 10);
            for (i = 0; i < size; ++i) {
                fluidTags = tagList.func_150305_b(i);
                this.fluid_outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTags));
            }
        }
        this.readSubClassDataFromNBT(tags);
    }

    protected void readSubClassDataFromNBT(NBTTagCompound tags) {
    }

    public ItemStack getItemInputI(int i) {
        if (this.inputs != null && !this.inputs.isEmpty() && this.inputs.size() > i) {
            ItemStack in = this.inputs.get(i).func_77946_l();
            return in;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getItemOutputI(int i) {
        if (this.outputs != null && !this.outputs.isEmpty() && this.outputs.size() > i) {
            ItemStack out = this.outputs.get(i).func_77946_l();
            return out;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getItemOutput0() {
        if (this.outputs != null && !this.outputs.isEmpty()) {
            ItemStack out = this.outputs.get(0).func_77946_l();
            out.func_190920_e(this.outputs.get(0).func_190916_E() * this.stackMultiplier);
            return out;
        }
        return ItemStack.field_190927_a;
    }

    public FluidStack getFluidOutput0() {
        FluidStack output;
        if (this.fluid_outputs != null && !this.fluid_outputs.isEmpty() && (output = this.fluid_outputs.get(0)) != null) {
            FluidStack out = output.copy();
            out.amount *= this.stackMultiplier;
            return out;
        }
        return null;
    }

    public ArrayList<ItemStack> getInputs() {
        return this.inputs;
    }

    public ArrayList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public ArrayList<ItemStack> getOutputsWithMult() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        this.outputs.forEach(o -> {
            ItemStack it = o.func_77946_l();
            it.func_190920_e(o.func_190916_E() * this.stackMultiplier);
            outputs.add(it);
        });
        return outputs;
    }

    public ArrayList<FluidStack> getFluid_inputs() {
        return this.fluid_inputs;
    }

    public ArrayList<FluidStack> getFluid_outputs() {
        return this.fluid_outputs;
    }

    public int getNeededAmountItem(int index) {
        if (this.inputs.size() <= index) {
            return 0;
        }
        ItemStack stack = this.inputs.get(index);
        return stack.func_190916_E() * this.stackMultiplier;
    }

    public int getNeededAmountFluid(int index) {
        if (this.fluid_inputs.size() <= index) {
            return 0;
        }
        FluidStack fluid = this.getFluid_inputs().get(index);
        return fluid.amount * this.stackMultiplier;
    }

    public int getTime() {
        return this.time;
    }

    public MachineOperation setTime(int time) {
        this.time = time;
        return this;
    }
}

