/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities.operation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import techguns.TGItems;
import techguns.tileentities.FabricatorTileEntMaster;
import techguns.tileentities.operation.IMachineRecipe;
import techguns.tileentities.operation.MachineOperation;
import techguns.util.ItemStackOreDict;

public class FabricatorRecipe
implements IMachineRecipe {
    public static ArrayList<ItemStackOreDict> items_wireslot = new ArrayList();
    public static ArrayList<ItemStackOreDict> items_powderslot = new ArrayList();
    public static ArrayList<ItemStackOreDict> items_plateslot = new ArrayList();
    public static ItemStackOreDict copperWires = new ItemStackOreDict("wireCopper", 1);
    public static ItemStackOreDict goldWires = new ItemStackOreDict("wireGold", 1);
    public static ItemStackOreDict redstone = new ItemStackOreDict("dustRedstone", 1);
    public static ItemStackOreDict plastic = new ItemStackOreDict("sheetPlastic", 1);
    public static ItemStackOreDict circuit_basic = new ItemStackOreDict("circuitBasic", 1);
    public static ItemStackOreDict circuit_elite = new ItemStackOreDict("circuitElite", 1);
    public static ItemStackOreDict mechanicalPartsT3 = new ItemStackOreDict(TGItems.MECHANICAL_PARTS_CARBON, 1);
    public static ItemStackOreDict carbonPlate = new ItemStackOreDict("plateCarbon", 1);
    public static ItemStackOreDict titaniumPlate = new ItemStackOreDict("plateTitanium", 1);
    public static ItemStackOreDict leadPlate = new ItemStackOreDict("plateLead", 1);
    public static ArrayList<FabricatorRecipe> recipes;
    public ItemStackOreDict inputItem;
    public byte amountInput;
    public ItemStackOreDict wireSlot;
    public byte amountWire;
    public ItemStackOreDict powderSlot;
    public byte amountPowder;
    public ItemStackOreDict plateSlot;
    public byte amountPlates;
    public ItemStack outputItem;
    public byte amountOutput;

    public static void addRecipe(ItemStackOreDict inputItem, int amountInput, ItemStackOreDict wireSlot, int amountWire, ItemStackOreDict powderSlot, int amountPowder, ItemStackOreDict plateSlot, int amountPlates, ItemStack outputItem, int amountOutput) {
        recipes.add(new FabricatorRecipe(inputItem, amountInput, wireSlot, amountWire, powderSlot, amountPowder, plateSlot, amountPlates, outputItem, amountOutput));
    }

    public boolean usesItem(ItemStack itm) {
        return this.inputItem.isEqualWithOreDict(itm) || this.wireSlot.isEqualWithOreDict(itm) || this.powderSlot.isEqualWithOreDict(itm) || this.plateSlot.isEqualWithOreDict(itm);
    }

    public FabricatorRecipe(ItemStackOreDict inputItem, int amountInput, ItemStackOreDict wireSlot, int amountWire, ItemStackOreDict powderSlot, int amountPowder, ItemStackOreDict plateSlot, int amountPlates, ItemStack outputItem, int amountOutput) {
        this.inputItem = inputItem;
        this.amountInput = (byte)amountInput;
        this.wireSlot = wireSlot;
        this.amountWire = (byte)amountWire;
        this.powderSlot = powderSlot;
        this.amountPowder = (byte)amountPowder;
        this.plateSlot = plateSlot;
        this.amountPlates = (byte)amountPlates;
        this.outputItem = outputItem;
        this.amountOutput = (byte)amountOutput;
    }

    private boolean matches(ItemStack input, ItemStack wires, ItemStack powder, ItemStack plate) {
        return this.inputItem.isEqualWithOreDict(input) && input.func_190916_E() >= this.amountInput && (this.wireSlot.isEmpty() || !wires.func_190926_b() && this.wireSlot.isEqualWithOreDict(wires) && wires.func_190916_E() >= this.amountWire) && (this.powderSlot.isEmpty() || !powder.func_190926_b() && this.powderSlot.isEqualWithOreDict(powder) && powder.func_190916_E() >= this.amountPowder) && (this.plateSlot.isEmpty() || !plate.func_190926_b() && this.plateSlot.isEqualWithOreDict(plate) && plate.func_190916_E() >= this.amountPlates);
    }

    public static boolean itemStackInList(ArrayList<ItemStackOreDict> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStackOreDict orestack = list.get(i);
            if (!orestack.isEqualWithOreDict(stack)) continue;
            return true;
        }
        return false;
    }

    public static RecipeData getRecipeDataFor(ItemStack input, ItemStack wires, ItemStack powder, ItemStack plate, int maxMultiplier, ItemStack outputSlot) {
        FabricatorRecipe match = null;
        for (int i = 0; i < recipes.size(); ++i) {
            FabricatorRecipe rec = recipes.get(i);
            if (!rec.matches(input, wires, powder, plate)) continue;
            match = rec;
            break;
        }
        if (match != null && FabricatorRecipe.canMerge(outputSlot, match.outputItem, match.amountOutput)) {
            int maxMultiInput = FabricatorRecipe.getMaxMulti(input.func_190916_E(), match.amountInput, maxMultiplier);
            int maxMultiWires = 0;
            maxMultiWires = !wires.func_190926_b() ? FabricatorRecipe.getMaxMulti(wires.func_190916_E(), match.amountWire, maxMultiplier) : 8;
            int maxMultiPowder = !powder.func_190926_b() ? FabricatorRecipe.getMaxMulti(powder.func_190916_E(), match.amountPowder, maxMultiplier) : 8;
            int maxMultiPlate = FabricatorRecipe.getMaxMulti(plate.func_190916_E(), match.amountPlates, maxMultiplier);
            int maxMultiOutput = FabricatorRecipe.getMaxMultiOutput(outputSlot.func_190926_b() ? 0 : outputSlot.func_190916_E(), match.amountOutput, maxMultiplier, match.outputItem.func_77976_d());
            int multi = FabricatorRecipe.getMinArgument(maxMultiInput, maxMultiWires, maxMultiPowder, maxMultiPlate, maxMultiOutput);
            RecipeData data = new RecipeData(match.outputItem, match.amountOutput, match.amountInput, match.amountWire, match.amountPowder, match.amountPlates, multi);
            return data;
        }
        return null;
    }

    private static boolean canMerge(ItemStack content, ItemStack newStack, int newAmount) {
        if (content.func_190926_b()) {
            return true;
        }
        if (content.func_77973_b() == newStack.func_77973_b() && content.func_77952_i() == newStack.func_77952_i()) {
            return content.func_190916_E() + newAmount <= content.func_77976_d();
        }
        return false;
    }

    private static int getMaxMulti(int stackSize, int consumption, int maxMulti) {
        int mult = maxMulti;
        while (mult * consumption > stackSize) {
            --mult;
        }
        return mult;
    }

    private static int getMaxMultiOutput(int stackSize, int amount, int maxMulti, int maxStackSize) {
        int mult = maxMulti;
        while (mult * amount + stackSize > maxStackSize) {
            --mult;
        }
        return mult;
    }

    private static int getMinArgument(int ... values) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            int x = values[i];
            if (x >= min) continue;
            min = x;
        }
        return min;
    }

    public static ArrayList<FabricatorRecipe> getRecipes() {
        return recipes;
    }

    @Override
    public List<List<ItemStack>> getItemInputs() {
        ArrayList<List<ItemStack>> ret = new ArrayList<List<ItemStack>>();
        ret.add(this.inputItem.getItemStacks(this.amountInput));
        ret.add(this.wireSlot.getItemStacks(this.amountWire));
        ret.add(this.powderSlot.getItemStacks(this.amountPowder));
        ret.add(this.plateSlot.getItemStacks(this.amountPlates));
        return ret;
    }

    @Override
    public List<List<ItemStack>> getItemOutputs() {
        ArrayList<List<ItemStack>> ret = new ArrayList<List<ItemStack>>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        output.add(this.outputItem);
        ret.add(output);
        return ret;
    }

    static {
        items_wireslot.add(copperWires);
        items_wireslot.add(goldWires);
        items_wireslot.add(circuit_basic);
        items_wireslot.add(circuit_elite);
        items_powderslot.add(redstone);
        items_powderslot.add(mechanicalPartsT3);
        items_plateslot.add(plastic);
        items_plateslot.add(carbonPlate);
        items_plateslot.add(titaniumPlate);
        items_plateslot.add(leadPlate);
        recipes = new ArrayList();
    }

    public static class RecipeData {
        public ItemStack output;
        public byte outputAmount;
        public byte inputConsumption;
        public byte wireConsumption;
        public byte powderConsumption;
        public byte plateConsumption;
        public byte stackMultiplier;

        public RecipeData(ItemStack output, int outputAmount, int inputConsumption, int wireConsumption, int powderConsumption, int plateConsumption, int stackMultiplier) {
            this.output = output;
            this.outputAmount = (byte)outputAmount;
            this.inputConsumption = (byte)inputConsumption;
            this.wireConsumption = (byte)wireConsumption;
            this.powderConsumption = (byte)powderConsumption;
            this.plateConsumption = (byte)plateConsumption;
            this.stackMultiplier = (byte)stackMultiplier;
        }

        public MachineOperation createOperation(FabricatorTileEntMaster tile) {
            ItemStack plates;
            ItemStack powder;
            ItemStack stack = tile.input.get().func_77946_l();
            stack.func_190920_e((int)this.inputConsumption);
            ItemStack wires = tile.wireslot.get().func_77946_l();
            if (!wires.func_190926_b()) {
                wires.func_190920_e((int)this.wireConsumption);
            }
            if (!(powder = tile.powderslot.get().func_77946_l()).func_190926_b()) {
                powder.func_190920_e((int)this.powderConsumption);
            }
            if (!(plates = tile.plateslot.get().func_77946_l()).func_190926_b()) {
                plates.func_190920_e((int)this.plateConsumption);
            }
            ItemStack out = this.output.func_77946_l();
            out.func_190920_e((int)this.outputAmount);
            MachineOperation op = new MachineOperation(out, stack, wires, powder, plates);
            op.setStackMultiplier(this.stackMultiplier);
            op.setPowerPerTick(tile.getNeededPower());
            return op;
        }
    }
}

