/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGConfig;
import techguns.TGFluids;
import techguns.TGItems;
import techguns.TGOreClusters;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;
import techguns.blocks.BlockOreCluster;
import techguns.blocks.EnumOreClusterType;
import techguns.blocks.machines.multiblocks.OreDrillDefinition;
import techguns.client.audio.TGSoundCategory;
import techguns.packets.PacketPlaySound;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.operation.FluidTankPlus;
import techguns.tileentities.operation.ITileEntityFluidTanks;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.util.InventoryUtil;

public class OreDrillTileEntMaster
extends MultiBlockMachineTileEntMaster
implements ITileEntityFluidTanks {
    protected static final float SOUND_VOLUME = 0.5f;
    protected int engines;
    protected int rods;
    protected int radius;
    protected EnumFacing drill_direction;
    protected boolean hasPower = false;
    protected boolean hasDrill = false;
    protected int drillType = 0;
    protected int currentFuelBufferMax = 0;
    protected int fuelBuffer = 0;
    protected int soundLoopDelay = 0;
    public ItemStack lastDrill = ItemStack.field_190927_a;
    protected static final int useRangeSquared = 144;
    public static final int CAPACITY_INPUT_TANK = 16000;
    public static final int CAPACITY_OUTPUT_TANK = 32000;
    public FluidTank inputTank;
    public FluidTank outputTank;
    protected OreDrillFluidHandler fluidHandler;
    public static final int SLOT_DRILL = 0;
    public static final int SLOT_FURNACE = 1;
    public static final int SLOT_OUTPUT1 = 2;
    public static final int SLOT_OUTPUT_COUNT = 9;

    public OreDrillTileEntMaster() {
        super(11, 500000);
        this.inventory = new ItemStackHandlerPlus(11){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                OreDrillTileEntMaster.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                if (slot <= 1) {
                    return OreDrillTileEntMaster.this.isItemValidForSlot(slot, stack);
                }
                return false;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot >= 2 && slot < 11;
            }
        };
        this.hasDrill = false;
        this.inputTank = new FluidTankPlus(this, 16000);
        this.inputTank.setTileEntity((TileEntity)this);
        this.outputTank = new FluidTankPlus(this, 32000);
        this.outputTank.setTileEntity((TileEntity)this);
        this.fluidHandler = new OreDrillFluidHandler(this);
    }

    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0 && stack.func_77973_b() instanceof ITGSpecialSlot) {
            TGSlotType slotType = ((ITGSpecialSlot)stack.func_77973_b()).getSlot(stack);
            return slotType == TGSlotType.DRILL_SMALL || slotType == TGSlotType.DRILL_MEDIUM || slotType == TGSlotType.DRILL_LARGE;
        }
        if (slot == 1) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
        }
        return false;
    }

    public void formOreDrill(EnumFacing direction, int engines, int rods, int radius, EnumFacing drill_direction) {
        this.engines = engines;
        this.rods = rods;
        this.radius = radius;
        this.drill_direction = drill_direction;
        super.form(direction);
    }

    public void setFuelBuffer(int fuelBuffer) {
        this.fuelBuffer = fuelBuffer;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.oredrill", new Object[0]);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isFormed()) {
            BlockPos p = this.func_174877_v();
            BlockPos rod_end = this.func_174877_v().func_177967_a(this.drill_direction, this.rods + this.engines + 1);
            BlockPos other = rod_end.func_177967_a(OreDrillDefinition.getSide1(this.drill_direction), this.radius + 2).func_177967_a(OreDrillDefinition.getSide2(this.drill_direction), this.radius + 1);
            BlockPos first = p.func_177967_a(OreDrillDefinition.getSide1(this.drill_direction), -(this.radius + 2)).func_177967_a(OreDrillDefinition.getSide2(this.drill_direction), -(this.radius + 1));
            return new AxisAlignedBB(first, other);
        }
        return super.getRenderBoundingBox();
    }

    public boolean hasDrill() {
        return this.hasDrill;
    }

    protected int getDrillHeadType() {
        int mininglevel = this.getDrillItemMiningLevel();
        if (mininglevel < 0) {
            return 0;
        }
        return mininglevel;
    }

    public int getDrillType() {
        return this.drillType;
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    @Override
    @Deprecated
    public EnumFacing getMultiblockDirection() {
        return EnumFacing.NORTH;
    }

    @Override
    @Deprecated
    public void form(EnumFacing facing) {
        super.form(facing);
    }

    @Override
    public void unform() {
        super.unform();
        this.engines = 0;
        this.rods = 0;
        this.radius = 0;
        this.drill_direction = null;
    }

    public int getEngines() {
        return this.engines;
    }

    public int getRods() {
        return this.rods;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getDrillRadius() {
        if (this.engines == 0) {
            return 0;
        }
        return this.radius + 1;
    }

    public EnumFacing getDrill_direction() {
        return this.drill_direction;
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        if (this.formed) {
            this.drill_direction = EnumFacing.func_82600_a((int)tags.func_74771_c("drill_direction"));
            this.engines = tags.func_74771_c("engines");
            this.rods = tags.func_74771_c("rods");
            this.radius = tags.func_74771_c("radius");
            this.hasPower = tags.func_74767_n("haspower");
            this.hasDrill = tags.func_74767_n("hasDrill");
            this.drillType = tags.func_74771_c("drillType");
        }
        this.fuelBuffer = tags.func_74762_e("fuelBuffer");
        this.currentFuelBufferMax = tags.func_74762_e("fuelBufferMax");
        this.loadTanksFromNBT(tags);
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        if (this.formed) {
            tags.func_74774_a("drill_direction", (byte)this.drill_direction.func_176745_a());
            tags.func_74774_a("engines", (byte)this.engines);
            tags.func_74774_a("rods", (byte)this.rods);
            tags.func_74774_a("radius", (byte)this.radius);
            tags.func_74757_a("haspower", this.hasPower);
            tags.func_74757_a("hasDrill", this.hasDrill);
            tags.func_74774_a("drillType", (byte)this.drillType);
        }
        tags.func_74768_a("fuelBuffer", this.fuelBuffer);
        tags.func_74768_a("fuelBufferMax", this.currentFuelBufferMax);
        this.saveTanksToNBT(tags);
    }

    @Override
    public AxisAlignedBB getBBforSlave(BlockPos slavePos) {
        return Block.field_185505_j;
    }

    @Override
    protected int getNeededPower() {
        if (this.currentOperation != null) {
            return this.currentOperation.getPowerPerTick();
        }
        return 0;
    }

    @Override
    protected boolean consumePower(int amount) {
        if (TGConfig.machinesNeedNoPower) {
            return true;
        }
        float FACTOR = TGConfig.oreDrillMultiplierFuel;
        if ((float)this.fuelBuffer * FACTOR >= (float)amount) {
            this.fuelBuffer = (int)((float)this.fuelBuffer - Math.max((float)amount / FACTOR, 1.0f));
            return true;
        }
        amount = (int)((float)amount - (float)this.fuelBuffer * FACTOR);
        this.fuelBuffer = 0;
        this.currentFuelBufferMax = 0;
        int fuelValue = 0;
        if (!this.inventory.getStackInSlot(1).func_190926_b()) {
            fuelValue = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1));
        }
        if (fuelValue > 0) {
            int leftover;
            ItemStack container = this.inventory.getStackInSlot(1).func_77973_b().getContainerItem(this.inventory.getStackInSlot(1));
            if (!container.func_190926_b() && (leftover = InventoryUtil.addItemToInventory(this.inventory, container, 2, 11)) > 0 && !this.field_145850_b.field_72995_K) {
                ItemStack entityItem = container.func_77946_l();
                entityItem.func_190920_e(leftover);
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, entityItem));
            }
            this.inventory.extractWithoutCheck(1, 1, false);
            this.fuelBuffer = fuelValue;
            this.currentFuelBufferMax = fuelValue;
        } else {
            float fuelvalue = this.getFuelValueFromInputTank();
            if (fuelvalue > 0.0f) {
                FluidStack drainedFluid = this.inputTank.drain(1000, true);
                this.fuelBuffer = (int)((float)drainedFluid.amount * fuelvalue);
                this.currentFuelBufferMax = (int)((float)drainedFluid.amount * fuelvalue);
            }
        }
        if ((float)this.fuelBuffer * FACTOR >= (float)amount) {
            this.fuelBuffer = (int)((float)this.fuelBuffer - Math.max((float)amount / FACTOR, 1.0f));
            return true;
        }
        if (amount > 0 && this.energy.getEnergyStored() >= amount) {
            this.energy.extractEnergy(amount, false);
            return true;
        }
        return amount == 0;
    }

    protected float getFuelValueFromInputTank() {
        if (this.inputTank.getFluid() != null) {
            if (this.inputTank.getFluid().getFluid() == TGFluids.LAVA) {
                return 20.0f;
            }
            if (TGFluids.fuels.contains(this.inputTank.getFluid().getFluid())) {
                return TGConfig.oreDrillFuelValueFuel;
            }
        }
        return 0.0f;
    }

    protected boolean checkDrill() {
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.lastDrill.func_190926_b() && this.inventory.getStackInSlot(0).func_190926_b()) {
                this.hasDrill = false;
                this.needUpdate();
                return false;
            }
            if (this.lastDrill.func_190926_b()) {
                this.lastDrill = this.inventory.getStackInSlot(0);
                return true;
            }
            if (this.inventory.getStackInSlot(0).func_190926_b() || !this.lastDrill.func_77969_a(this.inventory.getStackInSlot(0))) {
                this.lastDrill = this.inventory.getStackInSlot(0).func_77946_l();
                this.currentOperation = null;
                this.progress = 0;
                this.totaltime = 0;
                this.needUpdate();
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.isRedstoneEnabled()) {
            if (this.currentOperation != null) {
                if (this.field_145850_b.field_72995_K || this.checkDrill()) {
                    if (this.consumePower(this.getNeededPower() * this.currentOperation.getStackMultiplier())) {
                        ++this.progress;
                        this.playAmbientSound();
                        if (!this.field_145850_b.field_72995_K && !this.hasPower) {
                            this.hasPower = true;
                            this.needUpdate();
                        }
                        if (this.progress >= this.totaltime) {
                            if (!this.field_145850_b.field_72995_K) {
                                this.finishedOperation();
                            }
                            this.progress = 0;
                            this.totaltime = 0;
                            this.currentOperation = null;
                            if (!this.field_145850_b.field_72995_K) {
                                this.checkAndStartOperation();
                                this.needUpdate();
                            }
                        }
                    } else if (!this.field_145850_b.field_72995_K && this.hasPower) {
                        this.hasPower = false;
                        this.needUpdate();
                    }
                }
            } else if (!this.field_145850_b.field_72995_K && this.contentsChanged) {
                this.checkAndStartOperation();
            }
        }
    }

    @Override
    protected void checkAndStartOperation() {
        if (this.isFormed()) {
            this.contentsChanged = false;
            int distance = this.rods + this.engines + 1;
            BlockPos targetPos = this.func_174877_v().func_177967_a(this.drill_direction, distance);
            if (OreDrillDefinition.isOreCluster(this.field_145850_b, targetPos)) {
                IBlockState bs = this.field_145850_b.func_180495_p(targetPos);
                BlockOreCluster clusterblock = (BlockOreCluster)bs.func_177230_c();
                EnumOreClusterType type = (EnumOreClusterType)((Object)bs.func_177229_b((IProperty)clusterblock.TYPE));
                TGOreClusters.OreCluster cluster = Techguns.orecluster.getClusterForType(type);
                int drillheadmininglevel = this.getDrillItemMiningLevel();
                if (drillheadmininglevel > 0) {
                    this.hasDrill = true;
                    int effectivemininglevel = drillheadmininglevel + this.getDrillRadius() - cluster.getMininglevel();
                    this.drillType = this.getDrillHeadType();
                    if (effectivemininglevel >= 0) {
                        int clustersize = this.getClusterSize(0, targetPos, new ArrayList<BlockPos>(), cluster, bs);
                        int effectiveclustersize = Math.min(clustersize, this.getTotalDrillLength());
                        double orePerHour = ((double)(effectiveclustersize * 3) + (double)(effectiveclustersize * effectivemininglevel) * 0.5) * (double)TGConfig.oreDrillMultiplierOres * cluster.getMultiplier_amount();
                        this.currentOperation = cluster.getNewOperation(this.field_145850_b, orePerHour, this.getDrillRadius(), cluster.getMultiplier_power());
                        this.progress = 0;
                        this.totaltime = (int)(60.0 / orePerHour * 1200.0);
                    } else {
                        this.currentOperation = cluster.getCobbleStoneOperation();
                        this.progress = 0;
                        this.totaltime = 400;
                    }
                } else {
                    this.hasDrill = false;
                    this.drillType = 0;
                }
                this.needUpdate();
            } else {
                this.unform();
                this.formed = false;
                this.needUpdate();
            }
        }
    }

    public int getTotalDrillLength() {
        return this.engines + this.rods;
    }

    public int getDrillItemMiningLevel() {
        ItemStack drill = this.inventory.getStackInSlot(0);
        if (!drill.func_190926_b() && this.isFormed()) {
            int mininglevel = -1;
            if (this.getDrillRadius() == 0) {
                if (drill.func_77973_b() == TGItems.SHARED_ITEM) {
                    if (drill.func_77952_i() == TGItems.OREDRILLHEAD_STEEL.func_77952_i()) {
                        mininglevel = 1;
                    } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_OBSIDIANSTEEL.func_77952_i()) {
                        mininglevel = 2;
                    } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_CARBON.func_77952_i()) {
                        mininglevel = 3;
                    }
                }
            } else if (this.getDrillRadius() == 1 || this.getDrillRadius() == 2) {
                if (drill.func_77973_b() == TGItems.SHARED_ITEM) {
                    if (drill.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_STEEL.func_77952_i()) {
                        mininglevel = 1;
                    } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_OBSIDIANSTEEL.func_77952_i()) {
                        mininglevel = 2;
                    } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_MEDIUM_CARBON.func_77952_i()) {
                        mininglevel = 3;
                    }
                }
            } else if ((this.getDrillRadius() == 3 || this.getDrillRadius() == 4) && drill.func_77973_b() == TGItems.SHARED_ITEM) {
                if (drill.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_STEEL.func_77952_i()) {
                    mininglevel = 1;
                } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_OBSIDIANSTEEL.func_77952_i()) {
                    mininglevel = 2;
                } else if (drill.func_77952_i() == TGItems.OREDRILLHEAD_LARGE_CARBON.func_77952_i()) {
                    mininglevel = 3;
                }
            }
            return mininglevel;
        }
        return -1;
    }

    @Override
    protected void finishedOperation() {
        FluidStack fluidOut;
        ItemStack output = this.currentOperation.getItemOutput0();
        if (!output.func_190926_b()) {
            int leftover = output.func_190916_E();
            int s = 2;
            ItemStack out = ItemStack.field_190927_a;
            while (leftover > 0 && s < 11) {
                out = this.inventory.insertItemNoCheck(s, output, false);
                if (!out.func_190926_b()) {
                    leftover = out.func_190916_E();
                    if (leftover <= 0) continue;
                    output = out;
                    ++s;
                    continue;
                }
                leftover = 0;
            }
            if (leftover > 0) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, out));
            }
        }
        if ((fluidOut = this.currentOperation.getFluidOutput0()) != null) {
            this.outputTank.fillInternal(fluidOut, true);
        }
    }

    @Override
    protected void playAmbientSound() {
        BlockPos soundPos = this.func_174877_v().func_177967_a(this.drill_direction, this.engines).func_177967_a(this.drill_direction, (int)((double)this.rods * 0.5));
        if (!this.field_145850_b.field_72995_K && this.soundLoopDelay-- <= 0) {
            if (this.radius == 0) {
                TGPackets.network.sendToAllTracking((IMessage)new PacketPlaySound(TGSounds.ORE_DRILL_WORK_SMALL, soundPos.func_177958_n(), soundPos.func_177956_o(), soundPos.func_177952_p(), 0.5f, 1.0f, false, TGSoundCategory.MACHINE), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)soundPos.func_177958_n() + 0.5, (double)soundPos.func_177956_o() + 0.5, (double)soundPos.func_177952_p() + 0.5, 32.0));
                this.soundLoopDelay = 61;
            } else if (this.radius <= 2) {
                TGPackets.network.sendToAllTracking((IMessage)new PacketPlaySound(TGSounds.ORE_DRILL_WORK_MEDIUM, soundPos.func_177958_n(), soundPos.func_177956_o(), soundPos.func_177952_p(), 0.5f, 1.0f, false, TGSoundCategory.MACHINE), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)soundPos.func_177958_n() + 0.5, (double)soundPos.func_177956_o() + 0.5, (double)soundPos.func_177952_p() + 0.5, 32.0));
                this.soundLoopDelay = 61;
            } else {
                TGPackets.network.sendToAllTracking((IMessage)new PacketPlaySound(TGSounds.ORE_DRILL_WORK_LARGE, soundPos.func_177958_n(), soundPos.func_177956_o(), soundPos.func_177952_p(), 0.5f, 1.0f, false, TGSoundCategory.MACHINE), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)soundPos.func_177958_n() + 0.5, (double)soundPos.func_177956_o() + 0.5, (double)soundPos.func_177952_p() + 0.5, 32.0));
                this.soundLoopDelay = 61;
            }
        }
    }

    @Override
    public void onMultiBlockBreak() {
        super.onMultiBlockBreak();
        this.currentOperation = null;
        this.progress = 0;
        this.totaltime = 0;
        this.needUpdate();
    }

    public int getClusterSize(int count, BlockPos startPos, ArrayList<BlockPos> visited, TGOreClusters.OreCluster clusterType, IBlockState clusterMeta) {
        IBlockState targetState = this.field_145850_b.func_180495_p(startPos);
        if (targetState == clusterMeta && !visited.contains(startPos)) {
            ++count;
            visited.add(startPos);
            count = this.getClusterSize(count, startPos.func_177982_a(1, 0, 0), visited, clusterType, clusterMeta);
            count = this.getClusterSize(count, startPos.func_177982_a(-1, 0, 0), visited, clusterType, clusterMeta);
            count = this.getClusterSize(count, startPos.func_177982_a(0, 1, 0), visited, clusterType, clusterMeta);
            count = this.getClusterSize(count, startPos.func_177982_a(0, -1, 0), visited, clusterType, clusterMeta);
            count = this.getClusterSize(count, startPos.func_177982_a(0, 0, 1), visited, clusterType, clusterMeta);
            count = this.getClusterSize(count, startPos.func_177982_a(0, 0, -1), visited, clusterType, clusterMeta);
            return count;
        }
        return count;
    }

    public int getCurrentFuelBufferMax() {
        return this.currentFuelBufferMax;
    }

    public void setCurrentFuelBufferMax(int currentFuelBufferMax) {
        this.currentFuelBufferMax = currentFuelBufferMax;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelBufferScaled(int limit) {
        if (this.currentFuelBufferMax > 0) {
            return this.fuelBuffer * limit / this.currentFuelBufferMax;
        }
        return 0;
    }

    public int getFuelBuffer() {
        return this.fuelBuffer;
    }

    @Override
    public void saveTanksToNBT(NBTTagCompound tags) {
        NBTTagCompound inputTankTags = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankTags);
        tags.func_74782_a("inputTank", (NBTBase)inputTankTags);
        NBTTagCompound outputTankTags = new NBTTagCompound();
        this.outputTank.writeToNBT(outputTankTags);
        tags.func_74782_a("outputTank", (NBTBase)outputTankTags);
    }

    @Override
    public void loadTanksFromNBT(NBTTagCompound tags) {
        NBTTagCompound inputTank = tags.func_74775_l("inputTank");
        this.inputTank.readFromNBT(inputTank);
        NBTTagCompound outputTank = tags.func_74775_l("outputTank");
        this.outputTank.readFromNBT(outputTank);
    }

    public int getPowerPerTick() {
        if (this.currentOperation != null) {
            return this.currentOperation.getPowerPerTick();
        }
        return 0;
    }

    public int getValidSlotForItemInMachine(ItemStack stack) {
        if (this.isItemValidForSlot(0, stack)) {
            return 0;
        }
        if (this.isItemValidForSlot(1, stack)) {
            return 1;
        }
        return -1;
    }

    @Override
    protected int getUseRangeSquared() {
        return 144;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.fluidHandler : super.getCapability(capability, facing));
    }

    public static class OreDrillFluidHandler
    implements IFluidHandler {
        private OreDrillTileEntMaster tile;
        protected IFluidTankProperties[] tankProperties;

        public OreDrillFluidHandler(OreDrillTileEntMaster tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.tankProperties == null) {
                this.tankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this.tile.inputTank), new FluidTankPropertiesWrapper(this.tile.outputTank)};
            }
            return this.tankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.tile.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.tile.outputTank.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.tile.outputTank.drain(maxDrain, doDrain);
        }
    }
}

