/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGBlocks;
import techguns.TGPackets;
import techguns.blocks.BlockTGDoor3x3;
import techguns.packets.PacketDoorStateChange;
import techguns.tileentities.BasicRedstoneTileEnt;
import techguns.tileentities.ReactionChamberTileEntMaster;

public class Door3x3TileEntity
extends BasicRedstoneTileEnt {
    protected int doorType = 0;
    protected long lastStateChangeTime = 0L;
    protected byte doormode = 0;
    protected boolean autoClose = true;
    public static final int BUTTON_ID_DOORMODE = 3;
    public static final int BUTTON_ID_AUTOCLOSE = 4;

    public Door3x3TileEntity() {
        super(0, false);
    }

    public int getDoorType() {
        return this.doorType;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() == TGBlocks.DOOR3x3) {
            if (((Boolean)state.func_177229_b((IProperty)BlockTGDoor3x3.ZPLANE)).booleanValue()) {
                return new AxisAlignedBB(this.func_174877_v()).func_72314_b(1.0, 1.0, 3.0);
            }
            return new AxisAlignedBB(this.func_174877_v()).func_72314_b(3.0, 1.0, 1.0);
        }
        return super.getRenderBoundingBox();
    }

    public void setDoorType(int doorType) {
        this.doorType = doorType;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.door3x3", new Object[0]);
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.doorType = tags.func_74771_c("doortype");
        this.autoClose = tags.func_74767_n("autoClose");
        this.doormode = tags.func_74771_c("doormode");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74774_a("doortype", (byte)this.doorType);
        tags.func_74757_a("autoClose", this.autoClose);
        tags.func_74774_a("doormode", this.doormode);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean b = oldState.func_177230_c() != newState.func_177230_c() || (Boolean)newState.func_177229_b((IProperty)BlockTGDoor3x3.MASTER) == false || (Boolean)oldState.func_177229_b((IProperty)BlockTGDoor3x3.MASTER) == false || oldState.func_177229_b((IProperty)BlockTGDoor3x3.ZPLANE) != newState.func_177229_b((IProperty)BlockTGDoor3x3.ZPLANE);
        return b;
    }

    public long getLastStateChangeTime() {
        return this.lastStateChangeTime;
    }

    public void setLastStateChangeTime(long lastStateChangeTime) {
        this.lastStateChangeTime = lastStateChangeTime;
    }

    public boolean isOpenWithRightClick() {
        return this.doormode == 0;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        if (!this.autoClose && autoClose) {
            this.checkScheduleBlockUpdate();
        }
        this.autoClose = autoClose;
    }

    public boolean isPlayerDetector() {
        return this.doormode == 2;
    }

    public void checkScheduleBlockUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.autoClose && this.doormode != 2) {
            this.field_145850_b.func_180497_b(this.func_174877_v(), this.field_145854_h, 5, 0);
        }
    }

    public boolean checkAutoCloseDelay() {
        long time = System.currentTimeMillis();
        long diff = time - this.lastStateChangeTime;
        return diff > 5000L;
    }

    public boolean checkPlayerSensorAutoCloseDelay() {
        long time = System.currentTimeMillis();
        long diff = time - this.lastStateChangeTime;
        return diff > 1000L;
    }

    public void changeStateServerSide() {
        if (!this.field_145850_b.field_72995_K) {
            ChunkPos cp = this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l();
            PlayerChunkMapEntry entry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(cp.field_77276_a, cp.field_77275_b);
            if (entry != null) {
                try {
                    List players = (List)ReactionChamberTileEntMaster.playerChunkMapEntry_Players.get(entry);
                    PacketDoorStateChange packet = new PacketDoorStateChange(this);
                    for (EntityPlayerMP entityplayermp : players) {
                        TGPackets.network.sendTo((IMessage)packet, entityplayermp);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id == 4) {
            if (this.isUseableByPlayer(ply)) {
                this.setAutoClose(!this.autoClose);
                this.needUpdate();
            }
        } else if (id == 3) {
            if (this.isUseableByPlayer(ply)) {
                byte mode = (byte)(this.doormode + 1);
                if (mode > 2) {
                    mode = 0;
                }
                this.setDoormode(mode);
                this.needUpdate();
            }
        } else {
            super.buttonClicked(id, ply, data);
        }
    }

    public byte getDoormode() {
        return this.doormode;
    }

    public void setDoormode(byte doormode) {
        this.doormode = doormode;
        if (this.doormode == 2 || this.doormode == 0) {
            this.field_145850_b.func_180497_b(this.func_174877_v(), this.field_145854_h, 5, 0);
        }
    }

    public boolean isRedstoneMode() {
        return this.doormode == 1;
    }
}

