/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import techguns.TGBlocks;
import techguns.blocks.machines.BasicMachine;
import techguns.tileentities.BasicTGTileEntity;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.util.InventoryUtil;

public class BasicInventoryTileEnt
extends BasicTGTileEntity {
    protected ItemStackHandlerPlus inventory;
    protected boolean contentsChanged = true;

    public BasicInventoryTileEnt(int inventorySize, boolean hasRotation) {
        super(hasRotation);
        this.inventory = new ItemStackHandlerPlus(inventorySize){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BasicInventoryTileEnt.this.setContentsChanged(true);
            }
        };
    }

    public ItemStackHandlerPlus getInventory() {
        return this.inventory;
    }

    public void emptyContent() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected BasicMachine getMachineBlockType() {
        if (this.hasRotation) {
            return TGBlocks.BASIC_MACHINE;
        }
        return TGBlocks.SIMPLE_MACHINE;
    }

    protected boolean canOutput(ItemStack output, int slot) {
        if (output.func_190926_b()) {
            return true;
        }
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return output.func_190916_E() <= this.inventory.getSlotLimit(slot);
        }
        return this.inventory.getStackInSlot(slot).func_77969_a(output) && this.inventory.getStackInSlot(slot).func_190916_E() + output.func_190916_E() <= this.inventory.getStackInSlot(slot).func_77976_d();
    }

    public void onBlockBreak() {
        InventoryUtil.dropInventoryItems(this.field_145850_b, this.field_174879_c, this.inventory);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    public void writeNBTforDismantling(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.writeClientDataToNBT(compound);
    }

    public void readNBTfromStackTag(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.readClientDataFromNBT(compound);
    }

    public void buttonClicked(int id, EntityPlayer ply, String data) {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (!this.hasRotation) {
            return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b(this.getMachineBlockType().MACHINE_TYPE) != newState.func_177229_b(this.getMachineBlockType().MACHINE_TYPE);
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void setContentsChanged(boolean contentsChanged) {
        this.contentsChanged = contentsChanged;
    }

    public boolean getContentsChanged() {
        return this.contentsChanged;
    }

    public boolean onFluidContainerInteract(EntityPlayer player, EnumHand hand, IFluidHandlerItem fluidhandleritem, ItemStack stack) {
        return false;
    }
}

