/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import techguns.TGItems;
import techguns.TGSounds;
import techguns.tileentities.BasicMachineTileEnt;
import techguns.tileentities.operation.AmmoPressBuildPlans;
import techguns.tileentities.operation.ItemStackHandlerPlus;
import techguns.tileentities.operation.MachineOperation;
import techguns.tileentities.operation.MachineSlotItem;

public class AmmoPressTileEnt
extends BasicMachineTileEnt {
    protected static final float SOUND_VOLUME = 0.5f;
    public static final int SLOT_METAL1 = 0;
    public static final int SLOT_METAL2 = 1;
    public static final int SLOT_POWDER = 2;
    public static final int SLOT_OUTPUT = 3;
    public static final int SLOT_UPGRADE = 4;
    public static final int BUTTON_ID_NEXT = 3;
    public static final int BUTTON_ID_PREV = 4;
    public MachineSlotItem inputMetal1;
    public MachineSlotItem inputMetal2;
    public MachineSlotItem inputPowder;
    public static final int POWER_PER_TICK = 5;
    public byte buildPlan = 0;
    private final byte maxPlan = (byte)3;

    public AmmoPressTileEnt() {
        super(5, true, 20000);
        this.inputMetal1 = new MachineSlotItem(this, 0);
        this.inputMetal2 = new MachineSlotItem(this, 1);
        this.inputPowder = new MachineSlotItem(this, 2);
        this.inventory = new ItemStackHandlerPlus(5){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                AmmoPressTileEnt.this.setContentsChanged(true);
            }

            @Override
            protected boolean allowItemInSlot(int slot, ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return AmmoPressBuildPlans.isInList(stack, AmmoPressBuildPlans.metal1);
                    }
                    case 1: {
                        return AmmoPressBuildPlans.isInList(stack, AmmoPressBuildPlans.metal2);
                    }
                    case 2: {
                        return AmmoPressBuildPlans.isInList(stack, AmmoPressBuildPlans.powder);
                    }
                    case 3: {
                        return false;
                    }
                    case 4: {
                        return TGItems.isMachineUpgrade(stack);
                    }
                }
                return true;
            }

            @Override
            protected boolean allowExtractFromSlot(int slot, int amount) {
                return slot == 3;
            }
        };
    }

    @Override
    public void readClientDataFromNBT(NBTTagCompound tags) {
        super.readClientDataFromNBT(tags);
        this.buildPlan = tags.func_74771_c("BuildPlan");
    }

    @Override
    public void writeClientDataToNBT(NBTTagCompound tags) {
        super.writeClientDataToNBT(tags);
        tags.func_74774_a("BuildPlan", this.buildPlan);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("techguns.container.ammopress", new Object[0]);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply, String data) {
        if (id < 3) {
            super.buttonClicked(id, ply, data);
        } else if (this.isUseableByPlayer(ply)) {
            switch (id) {
                case 3: {
                    this.buildPlan = (byte)(this.buildPlan + 1);
                    break;
                }
                case 4: {
                    this.buildPlan = (byte)(this.buildPlan - 1);
                }
            }
            if (this.buildPlan > this.maxPlan) {
                this.buildPlan = 0;
            } else if (this.buildPlan < 0) {
                this.buildPlan = (byte)this.maxPlan;
            }
            this.needUpdate();
        }
    }

    @Override
    protected int getNeededPower() {
        return 5;
    }

    @Override
    protected void checkAndStartOperation() {
        this.setContentsChanged(false);
        ItemStack output = AmmoPressBuildPlans.getOutputFor(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2), this.buildPlan);
        if (!output.func_190926_b() && this.canOutput(output, 3)) {
            int maxStack = this.getMaxMachineUpgradeMultiplier(4);
            ItemStack outputStack = TGItems.newStack(output, output.func_190916_E());
            int multiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                outputStack.func_190920_e(output.func_190916_E() * i);
                if (!this.canOutput(outputStack, 3) || !this.inputMetal1.canConsume(i) || !this.inputMetal2.canConsume(2 * i) || !this.inputPowder.canConsume(i)) continue;
                multiplier = i;
                break;
            }
            ItemStack metal1 = this.inputMetal1.getTypeWithSize(1);
            ItemStack metal2 = this.inputMetal2.getTypeWithSize(2);
            ItemStack powder = this.inputPowder.getTypeWithSize(1);
            this.inputMetal1.consume(multiplier);
            this.inputMetal2.consume(multiplier * 2);
            this.inputPowder.consume(multiplier);
            this.currentOperation = new MachineOperation(output, metal1, metal2, powder);
            this.currentOperation.setStackMultiplier(multiplier);
            this.progress = 0;
            this.totaltime = 100;
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    @Override
    protected void finishedOperation() {
        if (this.inventory.getStackInSlot(3).func_190926_b()) {
            this.inventory.setStackInSlot(3, this.currentOperation.getItemOutput0());
        } else {
            this.inventory.insertItemNoCheck(3, this.currentOperation.getItemOutput0(), false);
        }
    }

    @Override
    protected void playAmbientSound() {
        int soundTick1 = Math.round((float)this.totaltime * 0.05f);
        int soundTick2 = Math.round((float)this.totaltime * 0.3f);
        int halfTime = Math.round((float)this.totaltime * 0.5f);
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_184134_a(x, y, z, TGSounds.AMMO_PRESS_WORK1, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        } else if (this.progress == soundTick2 || this.progress == soundTick2 + halfTime) {
            this.field_145850_b.func_184134_a(x, y, z, TGSounds.AMMO_PRESS_WORK2, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
    }

    public static int getValidSlotForItemInMachine(ItemStack item) {
        if (AmmoPressBuildPlans.isValidFor(item, 0)) {
            return 0;
        }
        if (AmmoPressBuildPlans.isValidFor(item, 1)) {
            return 1;
        }
        if (AmmoPressBuildPlans.isValidFor(item, 2)) {
            return 2;
        }
        if (TGItems.isMachineUpgrade(item)) {
            return 4;
        }
        return -1;
    }
}

