/*
 * Decompiled with CFR 0.152.
 */
package techguns.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import techguns.TGConfig;
import techguns.TGItems;
import techguns.blocks.machines.BasicMachine;
import techguns.items.GenericItemShared;
import techguns.items.guns.GenericGun;
import techguns.items.guns.ammo.AmmoType;
import techguns.recipes.AmmoSumRecipeFactory;
import techguns.recipes.AmmoSwitchRecipeFactory;
import techguns.recipes.IngredientFactoryMatchNBTInt;
import techguns.recipes.MiningToolUpgradeHeadRecipeFactory;
import techguns.recipes.OreDictIngredientElectrumOrGold;
import techguns.recipes.OreDictIngredientHardenedGlass;
import techguns.recipes.ShapedOreRecipeCopyNBTFactory;

public class RecipeJsonConverter {
    private static final String recipeDirPath = "../../../src/main/resources/assets/techguns/recipes";
    private static HashMap<String, String> factories = new HashMap();
    public static final String AMMO_CHANGE_COPY_NBT_RECIPE = "ammo_change_crafting";
    private static HashMap<String, String> recipe_types;
    private static final Gson GSON;
    private static File RECIPE_DIR;
    private static final Set<String> USED_OD_NAMES;

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = TGConfig.config.getConfigFile().toPath().resolve(recipeDirPath).toFile();
            File[] files = RECIPE_DIR.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".json");
                }
            });
            System.out.println("Deleting recipes, THIS SHOULD ONLY BE DONE IN DEV ENVIRONMENT!!!");
            Arrays.stream(files).forEach(f -> f.delete());
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        ItemBlock ib;
        Block b;
        int i;
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), RecipeJsonConverter.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", RecipeJsonConverter.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        String name = result.func_77973_b().getRegistryName().func_110623_a();
        if (result.func_77973_b() instanceof GenericItemShared) {
            suffix = suffix + "_" + TGItems.SHARED_ITEM.get(result.func_77952_i()).getName();
        }
        if (result.func_77973_b() instanceof ItemBlock && (b = (ib = (ItemBlock)result.func_77973_b()).func_179223_d()) instanceof BasicMachine) {
            BasicMachine bm = (BasicMachine)b;
            suffix = suffix + "_" + bm.getNameSuffix(result.func_77960_j());
        }
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        ItemBlock ib;
        Block b;
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeJsonConverter.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", RecipeJsonConverter.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        String name = result.func_77973_b().getRegistryName().func_110623_a();
        if (result.func_77973_b() instanceof GenericItemShared) {
            suffix = suffix + "_" + TGItems.SHARED_ITEM.get(result.func_77952_i()).getName();
        }
        if (result.func_77973_b() instanceof ItemBlock && (b = (ib = (ItemBlock)result.func_77973_b()).func_179223_d()) instanceof BasicMachine) {
            BasicMachine bm = (BasicMachine)b;
            suffix = suffix + "_" + bm.getNameSuffix(result.func_77960_j());
        }
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addTGManualRecipe(Object ... components) {
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(RecipeJsonConverter.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("patchouli:book", "techguns:techguns_manual");
        json.put("result", RecipeJsonConverter.serializeItemFromResourceLocation(new ResourceLocation("patchouli", "guide_book"), tags));
        String suffix = "";
        String name = "techguns_manual";
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessAmmoSwapRecipe(GenericGun gun, AmmoType type, String key) {
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        ingredients.add(RecipeJsonConverter.serializeItem(new ItemStack((Item)gun, 1)));
        ingredients.add(RecipeJsonConverter.serializeItem(type.getAmmo(type.getIDforVariantKey(key))[0]));
        ItemStack result = new ItemStack((Item)gun, 1);
        json.put("ingredients", ingredients);
        json.put("type", "techguns:ammo_change_crafting");
        json.put("result", RecipeJsonConverter.serializeItem(result));
        String suffix = "_ammo_" + key;
        String name = result.func_77973_b().getRegistryName().func_110623_a();
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessMiningHeadUpgradeRecipe(GenericGun gun, ItemStack upgradeItem, String key, int value) {
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        ingredients.add(RecipeJsonConverter.serializeItemNBTTag(new ItemStack((Item)gun, 1), key, value));
        ingredients.add(RecipeJsonConverter.serializeItem(upgradeItem));
        ItemStack result = new ItemStack((Item)gun, 1);
        json.put("ingredients", ingredients);
        json.put("type", "techguns:miningtool_upgrade");
        json.put("result", RecipeJsonConverter.serializeItem(result));
        String suffix = "_upgrade_" + upgradeItem.func_77973_b().func_77658_a();
        String name = result.func_77973_b().getRegistryName().func_110623_a();
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapedCopyNBTRecipe(ItemStack result, Object ... components) {
        RecipeJsonConverter.addShapedRecipeSpecialType(result, new ResourceLocation("techguns", "copy_nbt"), components);
    }

    public static void addShapedAmmoSumRecipe(ItemStack result, Object ... components) {
        RecipeJsonConverter.addShapedRecipeSpecialType(result, new ResourceLocation("techguns", "ammo_sum_recipe"), components);
    }

    public static void addShapedRecipeSpecialType(ItemStack result, ResourceLocation type, Object ... components) {
        ItemBlock ib;
        Block b;
        int i;
        RecipeJsonConverter.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = true;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), RecipeJsonConverter.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", type.toString());
        json.put("result", RecipeJsonConverter.serializeItem(result));
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        String name = result.func_77973_b().getRegistryName().func_110623_a();
        if (result.func_77973_b() instanceof GenericItemShared) {
            suffix = suffix + "_" + TGItems.SHARED_ITEM.get(result.func_77952_i()).getName();
        }
        if (result.func_77973_b() instanceof ItemBlock && (b = (ib = (ItemBlock)result.func_77973_b()).func_179223_d()) instanceof BasicMachine) {
            BasicMachine bm = (BasicMachine)b;
            suffix = suffix + "_" + bm.getNameSuffix(result.func_77960_j());
        }
        File f = new File(RECIPE_DIR, name + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, name + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return RecipeJsonConverter.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return RecipeJsonConverter.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("nbt not implemented");
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    private static Map<String, Object> serializeItemFromResourceLocation(ResourceLocation item, NBTTagCompound tags) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("item", item.toString());
        HashMap<String, String> tags_m = new HashMap<String, String>();
        for (String s : tags.func_150296_c()) {
            String str = tags.func_74779_i(s);
            if (str == null || str.isEmpty()) continue;
            tags_m.put(s, str);
        }
        ret.put("nbt", tags_m);
        return ret;
    }

    private static Map<String, Object> serializeItemNBTTag(ItemStack stack, String key, Object value) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("type", "itemstackHasNBTInt");
        ret.put("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
            ret.put("data", stack.func_77952_i());
        }
        if (stack.func_190916_E() > 1) {
            ret.put("count", stack.func_190916_E());
        }
        ret.put("key", key);
        ret.put("value", value);
        return ret;
    }

    public static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            if (factories.containsKey(s)) {
                entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)s));
            } else {
                entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            }
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateFactories() {
        HashMap<String, HashMap<String, String>> entry = new HashMap<String, HashMap<String, String>>();
        entry.put("ingredients", factories);
        entry.put("recipes", recipe_types);
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_factories.json"));){
            GSON.toJson(entry, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        factories.put("hardenedGlassOrGlass", OreDictIngredientHardenedGlass.class.getName());
        factories.put("electrumOrGold", OreDictIngredientElectrumOrGold.class.getName());
        factories.put("itemstackHasNBTInt", IngredientFactoryMatchNBTInt.class.getName());
        recipe_types = new HashMap();
        recipe_types.put(AMMO_CHANGE_COPY_NBT_RECIPE, AmmoSwitchRecipeFactory.class.getName());
        recipe_types.put("miningtool_upgrade", MiningToolUpgradeHeadRecipeFactory.class.getName());
        recipe_types.put("copy_nbt", ShapedOreRecipeCopyNBTFactory.class.getName());
        recipe_types.put("ammo_sum_recipe", AmmoSumRecipeFactory.class.getName());
        GSON = new GsonBuilder().setPrettyPrinting().create();
        RECIPE_DIR = null;
        USED_OD_NAMES = new TreeSet<String>();
    }
}

