/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import techguns.gui.ReactionChamberGui;
import techguns.plugins.jei.BasicRecipeCategory;
import techguns.plugins.jei.ReactionChamberJeiRecipe;
import techguns.util.TextUtil;

public class ReactionChamberJeiRecipeCategory
extends BasicRecipeCategory<ReactionChamberJeiRecipe> {
    protected IDrawableStatic tank_overlay;

    public ReactionChamberJeiRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, ReactionChamberGui.texture, "reactionchamber", "techguns.reactionchamber");
        this.tank_overlay = guiHelper.createDrawable(ReactionChamberGui.texture, 177, 32, 10, 50);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ReactionChamberJeiRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 27, 1);
        guiItemStacks.init(1, true, 85, 1);
        guiItemStacks.init(2, false, 126, 1);
        guiItemStacks.init(3, false, 144, 1);
        guiItemStacks.init(4, false, 126, 19);
        guiItemStacks.init(5, false, 144, 19);
        guiFluidStacks.init(0, true, 12, 2, 10, 50, 10000, false, (IDrawable)this.tank_overlay);
        guiFluidStacks.addTooltipCallback((ITooltipCallback)new TankTooltipCallback(recipeWrapper));
        guiItemStacks.set(ingredients);
        guiFluidStacks.set(ingredients);
    }

    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.powerbar.draw(minecraft, 0, 1);
    }

    protected class TankTooltipCallback
    implements ITooltipCallback<FluidStack> {
        ReactionChamberJeiRecipe jeiRec;

        public TankTooltipCallback(ReactionChamberJeiRecipe jeiRec) {
            this.jeiRec = jeiRec;
        }

        public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
            int consumption = this.jeiRec.recipe.liquidConsumtion;
            tooltip.add(tooltip.size() - 1, ChatFormatting.GRAY + TextUtil.trans("techguns.container.reactionchamber.consumption") + ": " + String.format("%,d", consumption) + " mB");
        }
    }
}

