/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import techguns.gui.ReactionChamberGui;
import techguns.gui.TGBaseGui;
import techguns.plugins.jei.BasicRecipeWrapper;
import techguns.plugins.jei.ProgressBarReactionChamberCompletion;
import techguns.plugins.jei.ProgressBarReactionChamberIntensityJump;
import techguns.tileentities.operation.ReactionChamberRecipe;
import techguns.util.TextUtil;

public class ReactionChamberJeiRecipe
extends BasicRecipeWrapper {
    protected ReactionChamberRecipe recipe;
    IDrawableStatic progress_static;
    IDrawableAnimated progress;
    IDrawableAnimated completion_bar;
    IDrawableAnimated intensity_bar;
    protected byte fluidlevel;
    protected byte intensity;
    protected byte requiredCompletion;
    protected byte recipeticks;
    protected byte intensityMargin;
    protected float chanceToJump;
    protected boolean stable;

    public ReactionChamberJeiRecipe(ReactionChamberRecipe recipe, IGuiHelper guiHelper) {
        super(recipe);
        this.recipe = recipe;
        this.progress_static = guiHelper.createDrawable(ReactionChamberGui.texture, 0, 175, 101, 4);
        this.progress = guiHelper.createAnimatedDrawable(this.progress_static, this.recipe.ticks * 60, IDrawableAnimated.StartDirection.LEFT, false);
        this.completion_bar = new ProgressBarReactionChamberCompletion(guiHelper, 100, 4, this.recipe.ticks, recipe.requiredCompletion);
        this.fluidlevel = recipe.liquidLevel;
        this.intensity = recipe.preferredIntensity;
        this.intensity_bar = new ProgressBarReactionChamberIntensityJump(guiHelper, 5, 40, recipe.preferredIntensity, recipe.intensityMargin);
        this.requiredCompletion = recipe.requiredCompletion;
        this.recipeticks = recipe.ticks;
        this.intensityMargin = recipe.intensityMargin;
        this.chanceToJump = recipe.instability;
        this.stable = recipe.isStable();
    }

    @Override
    protected int getRFperTick() {
        return this.recipe.RFTick;
    }

    public static List<ReactionChamberJeiRecipe> getRecipes(IJeiHelpers helpers) {
        IStackHelper stackHelper = helpers.getStackHelper();
        ArrayList<ReactionChamberJeiRecipe> recipes = new ArrayList<ReactionChamberJeiRecipe>();
        Iterator<String> it = ReactionChamberRecipe.getRecipes().keySet().iterator();
        while (it.hasNext()) {
            ReactionChamberRecipe rec = ReactionChamberRecipe.getRecipes().get(it.next());
            recipes.add(new ReactionChamberJeiRecipe(rec, helpers.getGuiHelper()));
        }
        return recipes;
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (TGBaseGui.isInRect(mouseX, mouseY, 58, 44, 102, 14)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.reactionchamber.completion") + ": " + ChatFormatting.GREEN + this.requiredCompletion);
            tooltip.add(TextUtil.trans("techguns.container.reactionchamber.recipeticks") + ": " + ChatFormatting.RED + this.recipeticks);
            tooltip.add(TextUtil.trans("techguns.container.reactionchamber.time") + ": " + this.recipeticks * 60 / 20 + "s");
            return tooltip;
        }
        if (TGBaseGui.isInRect(mouseX, mouseY, 105, 0, 7, 41)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.reactionchamber.intensity") + ": " + this.intensity);
            if (!this.stable) {
                tooltip.add(TextUtil.trans("techguns.container.reactionchamber.intensitymargin") + ": +/-" + this.intensityMargin);
                tooltip.add(TextUtil.trans("techguns.container.reactionchamber.chance") + ": " + (int)(this.chanceToJump * 100.0f) + "%");
            } else {
                tooltip.add(ChatFormatting.GREEN + TextUtil.trans("techguns.container.reactionchamber.stable"));
            }
            return tooltip;
        }
        if (TGBaseGui.isInRect(mouseX, mouseY, 88, 22, 12, 12)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.reactionchamber.risk") + ": " + (Object)((Object)this.recipe.risk));
            return tooltip;
        }
        if (TGBaseGui.isInRect(mouseX, mouseY, 0, 1, 6, 60)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextUtil.trans("techguns.container.power") + ":");
            tooltip.add("-" + this.getRFperTick() + " " + "FE" + "/" + TextUtil.trans("techguns.container.reactionchamber.recipetick"));
            tooltip.add("-" + this.getRFperTick() * this.requiredCompletion + " " + "FE");
            return tooltip;
        }
        return Collections.EMPTY_LIST;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progress.draw(minecraft, 60, 54);
        this.completion_bar.draw(minecraft, 60, 46);
        this.intensity_bar.draw(minecraft, 107, 1);
        int level = 0;
        switch (this.recipe.risk) {
            case BREAK_ITEM: 
            case NONE: {
                break;
            }
            case RAD_LOW: 
            case RAD_MEDIUM: {
                level = 1;
                break;
            }
            case EXPLOSION_LOW: 
            case EXPLOSION_MEDIUM: 
            case RAD_HIGH: {
                level = 2;
                break;
            }
            case EXPLOSION_HIGH: 
            case UNFORSEEN_CONSEQUENCES: {
                level = 3;
                break;
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ReactionChamberGui.texture);
        Gui.func_146110_a((int)88, (int)22, (float)205.0f, (float)(12 * level), (int)12, (int)12, (float)256.0f, (float)256.0f);
        minecraft.field_71466_p.func_78276_b(this.fluidlevel * 10 + "%", 27, 35, 0x404040);
        minecraft.field_71466_p.func_78276_b(this.intensity + "", 114, 3, 0x404040);
    }
}

