/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.jei;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import techguns.TGBlocks;
import techguns.TGFluids;
import techguns.TGItems;
import techguns.TGOreClusters;
import techguns.Techguns;
import techguns.blocks.EnumOreClusterType;
import techguns.tileentities.operation.IMachineRecipe;

public class OreDrillMachineRecipe
implements IMachineRecipe {
    protected final TGOreClusters.OreClusterWeightedEntry entry;
    protected static List<ItemStack> furnaceFuels = null;
    protected static ArrayList<FluidStack> fuelList = null;
    protected static ArrayList<ItemStack> drills = null;
    protected EnumOreClusterType type;
    protected float chance;

    public OreDrillMachineRecipe(TGOreClusters.OreClusterWeightedEntry entry, EnumOreClusterType type, List<ItemStack> furnaceFuels) {
        this.entry = entry;
        this.type = type;
        OreDrillMachineRecipe.furnaceFuels = furnaceFuels;
        int totalweight = WeightedRandom.func_76272_a(Techguns.orecluster.getClusterForType(type).getOreEntries());
        this.chance = 1.0f * (float)entry.field_76292_a / ((float)totalweight * 1.0f);
    }

    @Override
    public List<List<ItemStack>> getItemInputs() {
        List<List<ItemStack>> list = IMachineRecipe.super.getItemInputs();
        list.add(this.getDrills());
        list.add((List<ItemStack>)NonNullList.func_191197_a((int)1, (Object)new ItemStack(TGBlocks.ORE_CLUSTER, 1, TGBlocks.ORE_CLUSTER.func_176201_c(TGBlocks.ORE_CLUSTER.func_176223_P().func_177226_a((IProperty)TGBlocks.ORE_CLUSTER.TYPE, (Comparable)((Object)this.type))))));
        list.add(furnaceFuels);
        return list;
    }

    @Override
    public List<List<ItemStack>> getItemOutputs() {
        List<List<ItemStack>> list = IMachineRecipe.super.getItemOutputs();
        if (!this.entry.getOre().func_190926_b()) {
            NonNullList ore = NonNullList.func_191197_a((int)1, (Object)this.entry.getOre());
            list.add((List<ItemStack>)ore);
        }
        return list;
    }

    public EnumOreClusterType getType() {
        return this.type;
    }

    protected ArrayList<ItemStack> getDrills() {
        if (drills == null) {
            drills = new ArrayList(9);
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_STEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_OBSIDIANSTEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_CARBON, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_MEDIUM_STEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_MEDIUM_OBSIDIANSTEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_MEDIUM_CARBON, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_LARGE_STEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_LARGE_OBSIDIANSTEEL, 1));
            drills.add(TGItems.newStack(TGItems.OREDRILLHEAD_LARGE_CARBON, 1));
        }
        return drills;
    }

    public float getChance() {
        return this.chance;
    }

    @Override
    public List<List<FluidStack>> getFluidInputs() {
        List<List<FluidStack>> list = IMachineRecipe.super.getFluidInputs();
        if (fuelList == null) {
            fuelList = new ArrayList(TGFluids.fuels.size());
            for (Fluid f : TGFluids.fuels) {
                fuelList.add(new FluidStack(f, 16000));
            }
        }
        list.add(fuelList);
        return list;
    }

    @Override
    public List<List<FluidStack>> getFluidOutputs() {
        List<List<FluidStack>> list = IMachineRecipe.super.getFluidOutputs();
        if (this.entry.getFluid() != null) {
            NonNullList f = NonNullList.func_191197_a((int)1, (Object)this.entry.getFluid());
            list.add((List<FluidStack>)f);
        }
        return list;
    }
}

