/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.plugins.crafttweaker.TGCraftTweakerHelper;
import techguns.tileentities.operation.ReactionBeamFocus;
import techguns.tileentities.operation.ReactionChamberRecipe;
import techguns.util.ItemStackOreDict;
import techguns.util.ItemUtil;
import techguns.util.MathUtil;

@ZenClass(value="mods.techguns.ReactionChamber")
public class ReactionChamberTweaker {
    @ZenMethod
    public static void addRecipe(String key, IItemStack input, ILiquidStack fluid, IItemStack[] outputs, IItemStack beamFocus, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumption, float instability, String risk, int RFTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(key, TGCraftTweakerHelper.toItemStackOreDict(input), fluid, outputs, beamFocus, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, liquidConsumption, instability, risk, RFTick));
    }

    @ZenMethod
    public static void addRecipe(String key, String input, ILiquidStack fluid, IItemStack[] outputs, IItemStack beamFocus, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumption, float instability, String risk, int RFTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(key, TGCraftTweakerHelper.toItemStackOreDict(input), fluid, outputs, beamFocus, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, liquidConsumption, instability, risk, RFTick));
    }

    @ZenMethod
    public static void addRecipe(String key, IItemStack input, ILiquidStack fluid, IItemStack output, IItemStack beamFocus, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumption, float instability, String risk, int RFTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(key, TGCraftTweakerHelper.toItemStackOreDict(input), fluid, new IItemStack[]{output}, beamFocus, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, liquidConsumption, instability, risk, RFTick));
    }

    @ZenMethod
    public static void addRecipe(String key, String input, ILiquidStack fluid, IItemStack output, IItemStack beamFocus, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumption, float instability, String risk, int RFTick) {
        CraftTweakerAPI.apply((IAction)new addInputAction(key, TGCraftTweakerHelper.toItemStackOreDict(input), fluid, new IItemStack[]{output}, beamFocus, ticks, requiredCompletion, preferredIntensity, intensityMargin, liquidLevel, liquidConsumption, instability, risk, RFTick));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input, ILiquidStack fluid) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), fluid));
    }

    @ZenMethod
    public static void removeRecipe(String input, ILiquidStack fluid) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(TGCraftTweakerHelper.toItemStackOreDict(input), fluid));
    }

    private static class removeInputAction
    implements IAction {
        ItemStackOreDict input;
        FluidStack fluid;
        int removed = 0;

        public removeInputAction(ItemStackOreDict input, ILiquidStack fluid) {
            this.input = input;
            this.fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)fluid);
        }

        public void apply() {
            Iterator<String> iter = ReactionChamberRecipe.getRecipes().keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                ReactionChamberRecipe rec = ReactionChamberRecipe.getRecipes().get(key);
                if (!rec.input.matches(this.input) || !ItemUtil.isFluidEqual(new FluidStack(rec.liquidIn, 1000), this.fluid)) continue;
                ++this.removed;
                iter.remove();
            }
        }

        public String describe() {
            return "Removed " + this.removed + " Recipe(s) using " + this.input + "/" + this.fluid.getUnlocalizedName() + " from ReactionChamber";
        }
    }

    private static class addInputAction
    implements IAction {
        String key;
        ReactionChamberRecipe added_recipe = null;
        ItemStackOreDict input;
        FluidStack fluid;
        ItemStack[] outputs;
        ItemStack beamFocus;
        byte ticks;
        byte requiredCompletion;
        byte preferredIntensity;
        byte intensityMargin;
        byte liquidLevel;
        short liquidConsumtion;
        float instability;
        String risk_str;
        ReactionChamberRecipe.RiskType risk;
        int RFTick;
        boolean valid = true;
        String msg;

        public addInputAction(String key, ItemStackOreDict input, ILiquidStack fluid, IItemStack[] outputs, IItemStack beamFocus, int ticks, int requiredCompletion, int preferredIntensity, int intensityMargin, int liquidLevel, int liquidConsumtion, float instability, String risk, int RFTick) {
            this.key = key;
            this.input = input;
            this.fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)fluid);
            this.outputs = CraftTweakerMC.getItemStacks((IItemStack[])outputs);
            this.beamFocus = CraftTweakerMC.getItemStack((IItemStack)beamFocus);
            this.ticks = (byte)ticks;
            this.requiredCompletion = (byte)requiredCompletion;
            this.preferredIntensity = (byte)preferredIntensity;
            this.intensityMargin = (byte)intensityMargin;
            this.liquidLevel = (byte)liquidLevel;
            this.liquidConsumtion = (short)liquidConsumtion;
            this.instability = instability;
            this.risk_str = risk;
            this.RFTick = RFTick;
            this.valid = this.checkValid();
        }

        public void apply() {
            if (this.valid) {
                this.added_recipe = ReactionChamberRecipe.addRecipe(this.key, this.input, this.beamFocus, this.fluid.getFluid(), this.outputs, (int)this.ticks, (int)this.requiredCompletion, (int)this.preferredIntensity, (int)this.intensityMargin, (int)this.liquidLevel, (int)this.liquidConsumtion, this.instability, this.risk, this.RFTick);
            }
        }

        public String describe() {
            if (this.valid) {
                return "Add Recipe for " + this.outputs[0] + " to ReactionChamber";
            }
            return "ERROR Adding ReactionChamber Recipe: " + this.msg;
        }

        private boolean checkValid() {
            if (ReactionBeamFocus.getBeamFocus(this.beamFocus) == null) {
                this.msg = "Item passed as Beam Focus is not valid!";
                return false;
            }
            if (!MathUtil.inRange(this.preferredIntensity, 0, 10)) {
                this.msg = "Preferred Intensity must be in [0-10]!";
                return false;
            }
            if (!MathUtil.inRange(this.intensityMargin, 0, 10)) {
                this.msg = "intensityMargin must be in [0-10]!";
                return false;
            }
            if (!MathUtil.inRange(this.liquidLevel, 0, 10)) {
                this.msg = "liquidLeve must be in [0-10]!";
                return false;
            }
            if (!MathUtil.inRange(this.liquidConsumtion, 0, this.liquidLevel * 1000)) {
                this.msg = "liquidConsumption must not be negative and lower than 1000*liquidLevel!";
                return false;
            }
            if (this.instability < 0.0f || this.instability > 1.0f) {
                this.msg = "instability must be between 0.0 and 1.0";
                return false;
            }
            try {
                this.risk = ReactionChamberRecipe.RiskType.valueOf(this.risk_str);
            }
            catch (IllegalArgumentException ex) {
                this.msg = "Invalid risktype: " + this.risk_str;
                return false;
            }
            return true;
        }
    }
}

