/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.Techguns;
import techguns.blocks.EnumOreClusterType;

@ZenClass(value="mods.techguns.OreCluster")
public class OreClusterTweaker {
    @ZenMethod
    public static void addOre(String clustertype, IItemStack ore, int weight) {
        CraftTweakerAPI.apply((IAction)new addInputAction(clustertype, ore, weight));
    }

    @ZenMethod
    public static void addFluid(String clustertype, ILiquidStack fluid, int weight) {
        CraftTweakerAPI.apply((IAction)new addInputAction(clustertype, fluid, weight));
    }

    @ZenMethod
    public static void removeOre(String clustertype, IItemStack ore) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(clustertype, ore));
    }

    @ZenMethod
    public static void removeFluid(String clustertype, ILiquidStack fluid) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(clustertype, fluid));
    }

    protected static class removeInputAction
    implements IAction {
        protected ItemStack ore;
        protected FluidStack fluid;
        protected EnumOreClusterType cluster;

        public removeInputAction(String cluster, IItemStack ore) {
            this.cluster = EnumOreClusterType.getFromString(cluster);
            this.ore = CraftTweakerMC.getItemStack((IItemStack)ore);
            this.fluid = null;
        }

        public removeInputAction(String cluster, ILiquidStack fluid) {
            this.cluster = EnumOreClusterType.getFromString(cluster);
            this.ore = ItemStack.field_190927_a;
            this.fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)fluid);
        }

        public void apply() {
            if (this.cluster != null) {
                if (!this.ore.func_190926_b()) {
                    Techguns.orecluster.removeOreFromCluster(this.ore, this.cluster);
                } else if (this.fluid != null) {
                    Techguns.orecluster.removeOreFromCluster(this.fluid, this.cluster);
                }
            }
        }

        public String describe() {
            if (this.cluster != null) {
                if (!this.ore.func_190926_b()) {
                    Techguns.orecluster.removeOreFromCluster(this.ore, this.cluster);
                    return "Removing " + this.ore + " from Cluster " + this.cluster;
                }
                if (this.fluid != null) {
                    Techguns.orecluster.removeOreFromCluster(this.fluid, this.cluster);
                    return "Removing " + this.fluid + " from Cluster " + this.cluster;
                }
            }
            return "Failed to remove ore from Cluster";
        }
    }

    protected static class addInputAction
    implements IAction {
        protected ItemStack ore;
        protected FluidStack fluid;
        protected EnumOreClusterType cluster;
        protected int weight;

        public addInputAction(String cluster, IItemStack ore, int weight) {
            this.cluster = EnumOreClusterType.getFromString(cluster);
            this.ore = CraftTweakerMC.getItemStack((IItemStack)ore);
            this.fluid = null;
            this.weight = weight;
        }

        public addInputAction(String cluster, ILiquidStack fluid, int weight) {
            this.cluster = EnumOreClusterType.getFromString(cluster);
            this.fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)fluid);
            this.ore = ItemStack.field_190927_a;
            this.weight = weight;
        }

        public void apply() {
            if (this.cluster != null) {
                if (!this.ore.func_190926_b()) {
                    Techguns.orecluster.addOreToCluster(this.ore, this.cluster, this.weight);
                } else if (this.fluid != null) {
                    Techguns.orecluster.addOreToCluster(this.fluid, this.cluster, this.weight);
                }
            }
        }

        public String describe() {
            if (this.cluster != null) {
                if (!this.ore.func_190926_b()) {
                    return "Adding " + this.ore + " to Cluster " + this.cluster + " with weight " + this.weight;
                }
                if (this.fluid != null) {
                    return "Adding " + this.fluid + " to Cluster " + this.cluster + " with weight " + this.weight;
                }
            }
            return "Failed to add ore to Cluster";
        }
    }
}

