/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.items.guns.GenericGun;
import techguns.plugins.crafttweaker.EnumGunStat;

@ZenClass(value="mods.techguns.GunStats")
public class GunStatTweaker {
    @ZenMethod
    public static void setWeaponStat(String weaponname, String fieldname, float value) {
        CraftTweakerAPI.apply((IAction)new setGunStatAction(weaponname, fieldname, value));
    }

    private static class setGunStatAction
    implements IAction {
        protected String weaponname;
        protected String fieldname;
        protected GenericGun gun = null;
        protected EnumGunStat field = null;
        protected float value;
        protected boolean gunOk;

        public setGunStatAction(String weaponname, String fieldname, float value) {
            this.fieldname = fieldname;
            this.weaponname = weaponname;
            Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(new ResourceLocation("techguns", weaponname));
            this.field = EnumGunStat.parseFromString(fieldname);
            this.value = value;
            this.gunOk = item != null && item instanceof GenericGun;
            this.gun = (GenericGun)item;
        }

        public void apply() {
            if (this.field != null && this.gunOk) {
                this.gun.setGunStat(this.field, this.value);
            }
        }

        public String describe() {
            if (!this.gunOk) {
                return "Failed setting [" + this.fieldname + "] for Weapon: [" + this.weaponname + "]: ITEM IS NOT A GUN";
            }
            if (this.field == null) {
                return "Failed setting [" + this.fieldname + "] for Weapon: [" + this.weaponname + "]: UNKNOWN FIELD";
            }
            return "Set [" + this.fieldname + "] for Weapon: [" + this.weaponname + "] to: " + this.value;
        }
    }
}

