/*
 * Decompiled with CFR 0.152.
 */
package techguns.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techguns.tileentities.operation.BlastFurnaceRecipes;
import techguns.util.ItemStackOreDict;

@ZenClass(value="mods.techguns.BlastFurnace")
public class BlastFurnaceTweaker {
    @ZenMethod
    public static void addRecipe(String input1, int amount1, String input2, int amount2, IItemStack output, int power, int duration) {
        CraftTweakerAPI.apply((IAction)new addInputAction(new ItemStackOreDict(input1), amount1, new ItemStackOreDict(input2), amount2, output, power, duration));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input1, String input2, int amount2, IItemStack output, int power, int duration) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input1, new ItemStackOreDict(input2), amount2, output, power, duration));
    }

    @ZenMethod
    public static void addRecipe(String input1, int amount1, IItemStack input2, IItemStack output, int power, int duration) {
        CraftTweakerAPI.apply((IAction)new addInputAction(new ItemStackOreDict(input1), amount1, input2, output, power, duration));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input1, IItemStack input2, IItemStack output, int power, int duration) {
        CraftTweakerAPI.apply((IAction)new addInputAction(input1, input2, output, power, duration));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new removeInputAction(output));
    }

    private static class addInputAction
    implements IAction {
        ItemStackOreDict input1;
        ItemStackOreDict input2;
        ItemStack output;
        int amount1;
        int amount2;
        int powerPerTick;
        int duration;

        public addInputAction(ItemStackOreDict input1, int amount1, ItemStackOreDict input2, int amount2, IItemStack output, int power, int duration) {
            this.input1 = input1;
            this.input2 = input2;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.amount1 = amount1;
            this.amount2 = amount2;
            this.powerPerTick = power;
            this.duration = duration;
        }

        public addInputAction(IItemStack input1, ItemStackOreDict input2, int amount2, IItemStack output, int power, int duration) {
            this.input1 = new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input1));
            this.input2 = input2;
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.amount1 = input1.getAmount();
            this.amount2 = amount2;
            this.powerPerTick = power;
            this.duration = duration;
        }

        public addInputAction(ItemStackOreDict input1, int amount1, IItemStack input2, IItemStack output, int power, int duration) {
            this.input1 = input1;
            this.input2 = new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input2));
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.amount1 = amount1;
            this.amount2 = input2.getAmount();
            this.powerPerTick = power;
            this.duration = duration;
        }

        public addInputAction(IItemStack input1, IItemStack input2, IItemStack output, int power, int duration) {
            this.input1 = new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input1));
            this.input2 = new ItemStackOreDict(CraftTweakerMC.getItemStack((IItemStack)input2));
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.amount1 = input1.getAmount();
            this.amount2 = input2.getAmount();
            this.powerPerTick = power;
            this.duration = duration;
        }

        public boolean isValid() {
            if (this.input1.hasItems() && this.input2.hasItems()) {
                return !this.output.func_190926_b();
            }
            return false;
        }

        public void apply() {
            if (this.isValid()) {
                if (this.input1.isOreDict() && this.input2.isOreDict()) {
                    BlastFurnaceRecipes.addRecipe(this.input1.oreDictName, this.amount1, this.input2.oreDictName, this.amount2, this.output, this.powerPerTick, this.duration);
                } else if (this.input1.isOreDict() && !this.input2.isOreDict()) {
                    ItemStack it2 = this.input2.item.func_77946_l();
                    it2.func_190920_e(this.amount2);
                    BlastFurnaceRecipes.addRecipe(this.input1.oreDictName, this.amount1, it2, this.output, this.powerPerTick, this.duration);
                } else if (!this.input1.isOreDict() && this.input2.isOreDict()) {
                    ItemStack it1 = this.input1.item.func_77946_l();
                    it1.func_190920_e(this.amount1);
                    BlastFurnaceRecipes.addRecipe(it1, this.input2.oreDictName, this.amount2, this.output, this.powerPerTick, this.duration);
                } else {
                    ItemStack it1 = this.input1.item.func_77946_l();
                    ItemStack it2 = this.input2.item.func_77946_l();
                    it1.func_190920_e(this.amount1);
                    it2.func_190920_e(this.amount2);
                    BlastFurnaceRecipes.addRecipe(it1, it2, this.output, this.powerPerTick, this.duration);
                }
            }
        }

        public String describe() {
            if (this.isValid()) {
                return "Add " + this.input1 + "+" + this.input2 + "-->" + this.output + " to BlastFurnace";
            }
            return "Failed to add Recipe: " + this.input1 + "+" + this.input2 + "-->" + this.output + " to BlastFurnace";
        }
    }

    private static class removeInputAction
    implements IAction {
        ItemStack output;

        public removeInputAction(IItemStack output) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            BlastFurnaceRecipes.removeRecipesFor(this.output);
        }

        public String describe() {
            return "Remove Recipe(s) for " + this.output + " from BlastFurnace";
        }
    }
}

