/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.client.audio.TGSoundCategory;
import techguns.packets.HandlerTemplate;
import techguns.util.EntityCondition;

public class PacketPlaySound
implements IMessage {
    String soundname;
    int entityId;
    float volume;
    float pitch;
    boolean repeat;
    boolean moving;
    boolean gunPosition = false;
    boolean playOnOwnPlayer = false;
    int soundx = 0;
    short soundy = 0;
    int soundz = 0;
    TGSoundCategory category;
    EntityCondition condition;

    public PacketPlaySound() {
    }

    public PacketPlaySound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, boolean playOnOwnPlayer, TGSoundCategory category) {
        this(soundname, entity, volume, pitch, repeat, moving, gunPosition, category);
        this.playOnOwnPlayer = playOnOwnPlayer;
    }

    public PacketPlaySound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, boolean playOnOwnPlayer, TGSoundCategory category, EntityCondition condition) {
        this(soundname, entity, volume, pitch, repeat, moving, gunPosition, category);
        this.playOnOwnPlayer = playOnOwnPlayer;
        this.condition = condition;
    }

    public PacketPlaySound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, boolean gunPosition, TGSoundCategory category) {
        this.entityId = entity == null ? -1 : entity.func_145782_y();
        this.soundname = soundname.getRegistryName().toString();
        this.volume = volume;
        this.pitch = pitch;
        this.repeat = repeat;
        this.moving = moving;
        this.gunPosition = gunPosition;
        this.category = category;
    }

    public PacketPlaySound(SoundEvent soundname, Entity entity, float volume, float pitch, boolean repeat, boolean moving, TGSoundCategory category) {
        this.entityId = entity == null ? -1 : entity.func_145782_y();
        this.soundname = soundname.getRegistryName().toString();
        this.volume = volume;
        this.pitch = pitch;
        this.repeat = repeat;
        this.moving = moving;
        this.category = category;
    }

    public PacketPlaySound(SoundEvent soundname, int posx, int posy, int posz, float volume, float pitch, boolean repeat, TGSoundCategory category) {
        this(soundname, null, volume, pitch, repeat, false, false, category);
        this.soundx = posx;
        this.soundy = (short)posy;
        this.soundz = posz;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.repeat = buf.readBoolean();
        this.moving = buf.readBoolean();
        this.gunPosition = buf.readBoolean();
        this.playOnOwnPlayer = buf.readBoolean();
        this.soundx = buf.readInt();
        this.soundy = buf.readShort();
        this.soundz = buf.readInt();
        this.category = TGSoundCategory.get(buf.readByte());
        this.condition = EntityCondition.fromByte(buf.readByte());
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        this.soundname = new String(bytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.repeat);
        buf.writeBoolean(this.moving);
        buf.writeBoolean(this.gunPosition);
        buf.writeBoolean(this.playOnOwnPlayer);
        buf.writeInt(this.soundx);
        buf.writeShort((int)this.soundy);
        buf.writeInt(this.soundz);
        buf.writeByte(this.category.getId());
        if (this.condition == null) {
            buf.writeByte((int)EntityCondition.NONE.id);
        } else {
            buf.writeByte((int)this.condition.id);
        }
        buf.writeBytes(this.soundname.getBytes());
    }

    public static class Handler
    extends HandlerTemplate<PacketPlaySound> {
        @Override
        protected void handle(PacketPlaySound msg, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            SoundEvent event = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(msg.soundname));
            if (msg.entityId != -1) {
                Techguns.proxy.handleSoundEvent(ply, msg.entityId, event, msg.volume, msg.pitch, msg.repeat, msg.moving, msg.gunPosition, msg.playOnOwnPlayer, msg.category, msg.condition);
            } else {
                Techguns.proxy.playSoundOnPosition(event, msg.soundx, msg.soundy, msg.soundz, msg.volume, msg.pitch, msg.repeat, msg.category);
            }
        }
    }
}

