/*
 * Decompiled with CFR 0.152.
 */
package techguns.packets;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.packets.HandlerTemplate;
import techguns.util.DataUtil;

public class PacketGunImpactFX
implements IMessage {
    short soundType;
    double loc_x;
    double loc_y;
    double loc_z;
    float pitch;
    float yaw;
    byte flags1;
    boolean incendiary = false;

    public PacketGunImpactFX(short soundType, double loc_x, double loc_y, double loc_z, float pitch, float yaw) {
        this.soundType = soundType;
        this.loc_x = loc_x;
        this.loc_y = loc_y;
        this.loc_z = loc_z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public PacketGunImpactFX(short soundType, double loc_x, double loc_y, double loc_z, float pitch, float yaw, boolean inc) {
        this.soundType = soundType;
        this.loc_x = loc_x;
        this.loc_y = loc_y;
        this.loc_z = loc_z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.incendiary = inc;
    }

    public PacketGunImpactFX() {
    }

    public void fromBytes(ByteBuf buf) {
        this.soundType = buf.readShort();
        this.loc_x = buf.readDouble();
        this.loc_y = buf.readDouble();
        this.loc_z = buf.readDouble();
        this.pitch = buf.readFloat();
        this.yaw = buf.readFloat();
        byte flags1 = buf.readByte();
        BitSet bs = DataUtil.uncompress(flags1);
        this.incendiary = bs.get(0);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.soundType);
        buf.writeDouble(this.loc_x);
        buf.writeDouble(this.loc_y);
        buf.writeDouble(this.loc_z);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.yaw);
        byte flags1 = DataUtil.compress(this.incendiary);
        buf.writeByte((int)flags1);
    }

    public static class Handler
    extends HandlerTemplate<PacketGunImpactFX> {
        @Override
        protected void handle(PacketGunImpactFX m, MessageContext ctx) {
            EntityPlayer ply = TGPackets.getPlayerFromContext(ctx);
            double x = m.loc_x;
            double y = m.loc_y;
            double z = m.loc_z;
            World world = ply.field_70170_p;
            boolean distdelay = true;
            if (m.incendiary) {
                Techguns.proxy.createFX("Impact_IncendiaryBullet", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            }
            if (m.soundType == 0) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_STONE, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletRock", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            } else if (m.soundType == 1) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_WOOD, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletWood", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            } else if (m.soundType == 2) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_GLASS, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletGlass", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            } else if (m.soundType == 3) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_METAL, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletMetal", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            } else if (m.soundType == 4) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletDirt", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            } else if (m.soundType == 5) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
            } else if (m.soundType == -1) {
                world.func_184134_a(x, y, z, TGSounds.BULLET_IMPACT_DIRT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
                Techguns.proxy.createFX("Impact_BulletDefault", world, x, y, z, 0.0, 0.0, 0.0, m.pitch, m.yaw);
            }
        }
    }
}

