/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGunMeleeCharge;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticle;

public class PowerHammer
extends GenericGunMeleeCharge {
    public PowerHammer(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy, fullChargeTime, ammoConsumedOnFullCharge);
        this.setMiningHeads(TGItems.POWERHAMMERHEAD_OBSIDIAN, TGItems.POWERHAMMERHEAD_CARBON);
    }

    @Override
    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        if (this.getCurrentAmmo(stack) > 0) {
            src.goreChance = 1.0f;
            src.armorPenetration = this.penetration;
            src.knockbackMultiplier = 1.5f;
        } else {
            src.deathType = EntityDeathUtils.DeathType.DEFAULT;
        }
        return src;
    }

    @Override
    protected void spawnSweepParticle(World w, double x, double y, double z, double motionX, double motionY, double motionZ) {
        TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("PowerhammerImpact", x, y, z), new NetworkRegistry.TargetPoint(w.field_73011_w.getDimension(), x, y, z, 32.0));
    }

    @Override
    public void spawnChargedProjectile(World world, EntityLivingBase player, ItemStack itemStack, float spread, float charge, int ammoConsumed, EnumBulletFirePos firePos) {
        int level = this.getMiningHeadLevel(itemStack);
        float extraDmg = 0.5f * (float)level;
        IProjectileFactory fact = this.chargedProjectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(itemStack));
        Object proj = fact.createChargedProjectile(world, player, this.damage + extraDmg, this.speed, this.ticksToLive, spread, this.damageDropStart, this.damageDropEnd, this.damageMin + extraDmg, this.penetration, PowerHammer.getDoBlockDamage(player), firePos, this.radius, this.gravity, charge, ammoConsumed);
        if (proj != null) {
            world.func_72838_d(proj);
        }
    }

    @Override
    public float getExtraDigSpeed(ItemStack stack) {
        int headlevel = this.getMiningHeadLevel(stack);
        return 2.0f * (float)headlevel;
    }

    @Override
    protected void playSweepSoundEffect(EntityPlayer player) {
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGSounds.POWERHAMMER_IMPACT, player.func_184176_by(), 1.0f, 1.0f);
    }
}

