/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGunMeleeCharge;
import techguns.packets.PacketSpawnParticle;
import techguns.util.TextUtil;

public class MiningDrill
extends GenericGunMeleeCharge {
    public MiningDrill(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy, fullChargeTime, ammoConsumedOnFullCharge);
        this.setMiningHeads(TGItems.MININGDRILLHEAD_CARBON);
    }

    @Override
    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        if (this.getCurrentAmmo(stack) > 0) {
            src.goreChance = 0.5f;
            src.armorPenetration = this.penetration;
            src.knockbackMultiplier = 1.0f;
        } else {
            src.deathType = EntityDeathUtils.DeathType.DEFAULT;
        }
        return src;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        this.shootGunPrimary(stack, worldIn, player, false, handIn, null);
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public float getExtraDigSpeed(ItemStack stack) {
        int headlevel = this.getMiningHeadLevel(stack);
        return 2.0f * (float)headlevel;
    }

    @Override
    protected void addMiningTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn, boolean longTooltip) {
        super.addMiningTooltip(stack, world, list, flagIn, longTooltip);
        if (longTooltip) {
            list.add(TextUtil.trans("techguns.tooltip.sneaksilktouch"));
        }
    }

    @Override
    public int getExtraMiningRadius(ItemStack stack) {
        return 0;
    }

    @Override
    protected SoundEvent getSwingSound() {
        return TGSounds.DRILLER_SWING;
    }

    @Override
    protected SoundEvent getBlockBreakSound() {
        return TGSounds.DRILLER_BREAK;
    }

    @Override
    protected void spawnSweepParticle(World w, double x, double y, double z, double motionX, double motionY, double motionZ) {
        TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("PowerhammerImpact", x, y, z), new NetworkRegistry.TargetPoint(w.field_73011_w.getDimension(), x, y, z, 32.0));
    }

    @Override
    protected void playSweepSoundEffect(EntityPlayer player) {
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGSounds.DRILLER_HIT, player.func_184176_by(), 1.0f, 1.0f);
    }
}

