/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.audio.TGSoundCategory;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.entities.projectiles.GuidedMissileProjectile;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGunCharge;
import techguns.items.guns.IProjectileFactory;
import techguns.util.SoundUtil;

public class GuidedMissileLauncher
extends GenericGunCharge {
    public static final float LOCK_RANGE = 150.0f;
    public static final float LOCK_ERROR_THRESHOLD = 0.5f;

    public GuidedMissileLauncher(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy, fullChargeTime, ammoConsumedOnFullCharge);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        if (player.field_70170_p.field_72995_K) {
            TGExtendedPlayer epc = TGExtendedPlayer.get((EntityPlayer)player);
            this.traceTarget(player);
            if (player instanceof EntityPlayer) {
                if (epc.lockOnTicks >= this.lockOnTicks) {
                    if (count % 4 == 0) {
                        SoundUtil.playSoundOnEntityGunPosition(player.field_70170_p, (Entity)player, TGSounds.LOCKED_BEEP, 4.0f, 1.0f, false, false, TGSoundCategory.PLAYER_EFFECT);
                    }
                } else if (epc.lockOnTicks > 0) {
                    if (count % 4 == 0) {
                        SoundUtil.playSoundOnEntityGunPosition(player.field_70170_p, (Entity)player, TGSounds.LOCKON_BEEP, 4.0f, 1.0f, false, false, TGSoundCategory.PLAYER_EFFECT);
                    }
                } else if (count % 12 == 0) {
                    SoundUtil.playSoundOnEntityGunPosition(player.field_70170_p, (Entity)player, TGSounds.LOCKON_BEEP, 4.0f, 0.5f, false, false, TGSoundCategory.PLAYER_EFFECT);
                }
            }
        }
    }

    @Override
    protected void startCharge(ItemStack item, World world, EntityPlayer player) {
        super.startCharge(item, world, player);
    }

    protected void traceTarget(EntityLivingBase shooter) {
        Entity entity;
        Vec3d vec3d1 = new Vec3d(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        shooter.func_70040_Z();
        Vec3d vec3d = vec3d1.func_178787_e(shooter.func_70040_Z().func_186678_a(150.0));
        RayTraceResult raytraceresult = shooter.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(shooter, vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (shooter instanceof EntityPlayer && !((EntityPlayer)shooter).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (shooter instanceof EntityPlayer) {
            TGExtendedPlayer epc = TGExtendedPlayer.get((EntityPlayer)shooter);
            if (raytraceresult != null && raytraceresult.field_72308_g != null) {
                if (epc.lockOnEntity != null && epc.lockOnEntity.func_70089_S()) {
                    if (epc.lockOnEntity == raytraceresult.field_72308_g) {
                        ++epc.lockOnTicks;
                        if (epc.lockOnTicks >= this.lockOnTicks) {
                            epc.lockOnTicks = this.lockOnTicks + this.lockOnPersistTicks;
                        }
                    } else if (epc.lockOnTicks > 0) {
                        --epc.lockOnTicks;
                    } else {
                        epc.lockOnEntity = null;
                        epc.lockOnTicks = 0;
                    }
                } else {
                    epc.lockOnEntity = raytraceresult.field_72308_g;
                    epc.lockOnTicks = 1;
                }
            } else if (epc.lockOnEntity != null && !epc.lockOnEntity.func_70089_S()) {
                epc.lockOnEntity = null;
                epc.lockOnTicks = 0;
            } else if (epc.lockOnTicks > 0) {
                --epc.lockOnTicks;
            } else {
                epc.lockOnEntity = null;
            }
        }
    }

    protected Entity findEntityOnPath(EntityLivingBase shooter, Vec3d start, Vec3d end) {
        Entity entity = null;
        Vec3d ray = shooter.func_70040_Z().func_186678_a(150.0);
        List list = shooter.field_70170_p.func_175674_a((Entity)shooter, shooter.func_174813_aQ().func_72321_a(ray.field_72450_a, ray.field_72448_b, ray.field_72449_c).func_186662_g(1.0), GenericProjectile.BULLET_TARGETS);
        double d0 = 0.0;
        Entity prevTarget = null;
        if (shooter instanceof EntityPlayer) {
            TGExtendedPlayer epc = TGExtendedPlayer.get((EntityPlayer)shooter);
            prevTarget = epc.lockOnEntity;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.5);
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(start, end);
            if (raytraceresult == null || prevTarget != null && entity == prevTarget) continue;
            if (entity1 == prevTarget) {
                entity = prevTarget;
                continue;
            }
            double d1 = start.func_72436_e(raytraceresult.field_72307_f);
            if (!(d1 < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    @Override
    protected void spawnProjectile(World world, EntityLivingBase player, ItemStack itemstack, float spread, float offset, float damagebonus, EnumBulletFirePos firePos, Entity target) {
        IProjectileFactory projectile = this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(itemstack));
        Object proj = projectile.createProjectile(this, world, player, this.damage * damagebonus, this.speed, this.getScaledTTL(), spread, this.damageDropStart, this.damageDropEnd, this.damageMin * damagebonus, this.penetration, GuidedMissileLauncher.getDoBlockDamage(player), firePos, this.radius, this.gravity);
        float f = 1.0f;
        if (this.muzzelight) {
            Techguns.proxy.createLightPulse(((GenericProjectile)((Object)proj)).field_70165_t + player.func_70040_Z().field_72450_a * (double)f, ((GenericProjectile)((Object)proj)).field_70163_u + player.func_70040_Z().field_72448_b * (double)f, ((GenericProjectile)((Object)proj)).field_70161_v + player.func_70040_Z().field_72449_c * (double)f, this.light_lifetime, this.light_radius_start, this.light_radius_end, this.light_r, this.light_g, this.light_b);
        }
        if (this.silenced) {
            ((GenericProjectile)((Object)proj)).setSilenced();
        }
        if (offset > 0.0f) {
            ((GenericProjectile)((Object)proj)).shiftForward(offset / this.speed);
        }
        ((GuidedMissileProjectile)((Object)proj)).target = target;
        world.func_72838_d(proj);
    }

    @Override
    public int consumeAmmoCharge(ItemStack item, float f, boolean creative) {
        return 0;
    }
}

