/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.armors;

import com.google.common.collect.Multimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import techguns.TGArmors;
import techguns.TGItems;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.api.radiation.TGRadiation;
import techguns.api.render.IItemTGRenderer;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.ClientProxy;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.items.armors.EnumArmorStat;
import techguns.items.armors.PoweredArmor;
import techguns.items.armors.TGArmorBonus;
import techguns.items.armors.TGArmorMaterial;
import techguns.util.TextUtil;

public class GenericArmor
extends ItemArmor
implements ISpecialArmor,
IItemTGRenderer {
    protected static final UUID[] RAD_RESIST_MODIFIER = new UUID[]{UUID.fromString("47E9813E-3FB7-415C-A6CD-F9A4A3C55F82"), UUID.fromString("AD509C77-02FC-40E8-A811-52B29842CE56"), UUID.fromString("CB3BF616-549C-47EF-ADC8-2ED60C331ABD"), UUID.fromString("052C821F-1FA9-4D67-A660-D885FAE22EED")};
    private ItemStack repairItem = null;
    protected ItemStack repairMatMetal = null;
    protected ItemStack repairMatCloth = null;
    protected float repairMatRatioMetal = 0.5f;
    protected int repairMatCount = 0;
    String textureName;
    protected ResourceLocation armorModel = null;
    protected boolean doubleTex = true;
    protected float SpeedBonus = 0.0f;
    protected float JumpBonus = 0.0f;
    protected float FallDMG = 0.0f;
    protected float FallFreeHeight = 0.0f;
    protected float MiningSpeedBonus = 0.0f;
    protected float WaterMiningBonus = 0.0f;
    protected int armorValue = 0;
    protected float GunAccuracy = 0.0f;
    protected float extraHearts = 0.0f;
    protected float nightvision = 0.0f;
    protected float knockbackresistance = 0.0f;
    protected float stepassist = 0.0f;
    protected float oxygen_gear = 0.0f;
    protected float water_electrolyzer = 0.0f;
    protected float coolingsystem = 0.0f;
    protected float waterspeedbonus = 0.0f;
    protected float radresistance = 0.0f;
    protected boolean hideFaceslot = false;
    protected boolean hideBackslot = false;
    protected boolean hideGloveslot = false;
    protected TGArmorMaterial field_77878_bZ;
    protected static DecimalFormat formatArmor = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    protected boolean use3dRenderHack = false;
    protected String modid = "techguns";
    protected ResourceLocation modelLoc;

    public GenericArmor(String unlocalizedName, TGArmorMaterial material, String textureName, EntityEquipmentSlot type) {
        this("techguns", unlocalizedName, material, textureName, type);
    }

    public GenericArmor(String modid, String unlocalizedName, TGArmorMaterial material, String textureName, EntityEquipmentSlot type) {
        super(material.createVanillaMaterial(), 0, type);
        this.field_77878_bZ = material;
        this.textureName = textureName;
        this.func_77637_a(Techguns.tabTechgun);
        this.modid = modid;
        this.func_77655_b(unlocalizedName);
        ResourceLocation reg = new ResourceLocation(modid, unlocalizedName);
        this.setRegistryName(reg);
        this.modelLoc = reg;
        this.armorValue = Math.round(material.getArmorValueSlot(type, DamageType.PHYSICAL));
        this.func_77656_e(this.field_77878_bZ.getDurability(type));
        TGArmors.armors.add(this);
    }

    public GenericArmor setArmorModel(ResourceLocation key, boolean doubleTex, ResourceLocation backupTex) {
        this.armorModel = key;
        this.doubleTex = doubleTex;
        this.modelLoc = backupTex;
        return this;
    }

    public GenericArmor setArmorModel(ResourceLocation key, boolean doubleTex) {
        this.armorModel = key;
        this.doubleTex = doubleTex;
        return this;
    }

    public static boolean isTechgunArmor(ItemStack i) {
        if (i == null) {
            return false;
        }
        return i.func_77973_b() instanceof GenericArmor;
    }

    public GenericArmor setSpeedBoni(float speed, float jump) {
        this.SpeedBonus = speed;
        this.JumpBonus = jump;
        return this;
    }

    public GenericArmor setFallProtection(float multiplier, float freeheight) {
        this.FallDMG = multiplier;
        this.FallFreeHeight = freeheight;
        return this;
    }

    public GenericArmor setMiningBoni(float bonus) {
        this.MiningSpeedBonus = bonus;
        return this;
    }

    public GenericArmor setMiningBoniWater(float bonus) {
        this.WaterMiningBonus = bonus;
        return this;
    }

    public GenericArmor setGunBonus(float acc) {
        this.GunAccuracy = acc;
        return this;
    }

    public GenericArmor setHealthBonus(int bonusHearts) {
        this.extraHearts = bonusHearts;
        return this;
    }

    public GenericArmor setDurability(int dur) {
        this.func_77656_e(dur);
        return this;
    }

    public GenericArmor setKnockbackResistance(float resistpercent) {
        this.knockbackresistance = resistpercent;
        return this;
    }

    public GenericArmor setRADResistance(float radresistance) {
        this.radresistance = radresistance;
        return this;
    }

    public GenericArmor setStepAssist(float stepassist) {
        this.stepassist = stepassist;
        return this;
    }

    public GenericArmor setOxygenGear(float value) {
        this.oxygen_gear = value;
        return this;
    }

    public GenericArmor setCoolingSystem(float value) {
        this.coolingsystem = value;
        return this;
    }

    public GenericArmor setWaterspeedBonus(float value) {
        this.waterspeedbonus = value;
        return this;
    }

    public GenericArmor setUseRenderHack() {
        this.use3dRenderHack = true;
        return this;
    }

    public float getBonus(TGArmorBonus type) {
        switch (type) {
            case SPEED: {
                return this.SpeedBonus;
            }
            case JUMP: {
                return this.JumpBonus;
            }
            case FALLDMG: {
                return this.FallDMG;
            }
            case FREEHEIGHT: {
                return this.FallFreeHeight;
            }
            case BREAKSPEED: {
                return this.MiningSpeedBonus;
            }
            case BREAKSPEED_WATER: {
                return this.WaterMiningBonus;
            }
            case GUN_ACCURACY: {
                return this.GunAccuracy;
            }
            case EXTRA_HEART: {
                return this.extraHearts;
            }
            case NIGHTVISION: {
                return this.nightvision;
            }
            case KNOCKBACK_RESISTANCE: {
                return this.knockbackresistance;
            }
            case STEPASSIST: {
                return this.stepassist;
            }
            case OXYGEN_GEAR: {
                return this.oxygen_gear;
            }
            case WATER_ELECTROLYZER: {
                return this.water_electrolyzer;
            }
            case COOLING_SYSTEM: {
                return this.coolingsystem;
            }
            case SPEED_WATER: {
                return this.waterspeedbonus;
            }
        }
        return 0.0f;
    }

    public GenericArmor addEnchantment() {
        return this;
    }

    public static float getArmorBonusForPlayer(EntityPlayer ply, TGArmorBonus type, boolean consumePower) {
        float bonus = 0.0f;
        TGExtendedPlayer props = TGExtendedPlayer.get(ply);
        if (props == null) {
            return 0.0f;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)ply.field_71071_by.field_70460_b.get(i);
            if (!GenericArmor.isTechgunArmor(armor)) continue;
            if (!(armor.func_77973_b() instanceof PoweredArmor)) {
                if (armor.func_77952_i() >= armor.func_77958_k() - 1) continue;
                float bonusVal = ((GenericArmor)armor.func_77973_b()).getBonus(type);
                bonus += bonusVal;
                continue;
            }
            PoweredArmor pwrarmor = (PoweredArmor)armor.func_77973_b();
            boolean power = PoweredArmor.hasPower(armor);
            float bonusVal = 0.0f;
            if (armor.func_77952_i() >= armor.func_77958_k() - 1) continue;
            if (power) {
                bonusVal = pwrarmor.getBonus(type);
                bonus += bonusVal;
                if (!consumePower || !(bonusVal > 0.0f)) continue;
                PoweredArmor.consumePower(armor, pwrarmor.applyPowerConsumptionOnAction(type, ply));
                continue;
            }
            bonusVal = pwrarmor.getBonusUnpowered(type);
            bonus += bonusVal;
        }
        if (props != null) {
            bonus += GenericArmor.getBonusForSlot((ItemStack)props.tg_inventory.inventory.get(0), type, consumePower, ply);
            bonus += GenericArmor.getBonusForSlot((ItemStack)props.tg_inventory.inventory.get(1), type, consumePower, ply);
            bonus += GenericArmor.getBonusForSlot((ItemStack)props.tg_inventory.inventory.get(2), type, consumePower, ply);
        }
        return bonus;
    }

    private static float getBonusForSlot(ItemStack stack, TGArmorBonus type, boolean consumePower, EntityPlayer ply) {
        float bonus = 0.0f;
        if (!stack.func_190926_b()) {
            ITGSpecialSlot item = (ITGSpecialSlot)stack.func_77973_b();
            if (stack.func_77973_b() == TGItems.SHARED_ITEM || stack.func_77952_i() < stack.func_77958_k() || !stack.func_77973_b().func_77645_m()) {
                bonus += item.getBonus(type, stack, consumePower, ply);
            }
        }
        return bonus;
    }

    private String getSingleTexture() {
        return this.modid + ":textures/armor/" + this.textureName + ".png";
    }

    private String getDoubleTexture() {
        return this.modid + ":textures/armor/" + this.textureName + "_" + (this.field_77881_a == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    protected boolean hasDoubleTexture() {
        return this.doubleTex;
    }

    private String trans(String text) {
        return TextUtil.trans("techguns." + text);
    }

    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.armorModel != null) {
            ModelBiped model = ClientProxy.get().getArmorModel(this.armorModel);
            if (model == null) {
                return null;
            }
            model.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            boolean bl = model.field_178720_f.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() == TGArmors.t2_beret) {
                model.field_178720_f.field_78806_j = false;
            }
            model.field_78115_e.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.LEGS;
            model.field_178723_h.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            model.field_178724_i.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            model.field_178721_j.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            model.field_178722_k.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            model.field_78117_n = entityLiving.func_70093_af();
            model.field_78093_q = entityLiving.func_184218_aH();
            model.field_78091_s = entityLiving.func_70631_g_();
            return model;
        }
        return null;
    }

    public static String formatAV(float armorValue, DamageType damageType) {
        return formatArmor.format(armorValue);
    }

    protected void addArmorvaluesInformation(ItemStack item, List list) {
        EntityEquipmentSlot slot = this.field_77881_a;
        list.add(ChatFormatting.DARK_GRAY + " AR: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.PHYSICAL), DamageType.PHYSICAL));
        list.add(ChatFormatting.GRAY + " PR: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.PROJECTILE), DamageType.PROJECTILE));
        list.add(ChatFormatting.DARK_RED + " EX: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.EXPLOSION), DamageType.EXPLOSION));
        list.add(ChatFormatting.DARK_AQUA + " E: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.ENERGY), DamageType.ENERGY));
        list.add(ChatFormatting.RED + " F: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.FIRE), DamageType.FIRE));
        list.add(ChatFormatting.AQUA + " I: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.ICE), DamageType.ICE));
        list.add(ChatFormatting.YELLOW + " L: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.LIGHTNING), DamageType.LIGHTNING));
        list.add(ChatFormatting.DARK_GREEN + " P: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.POISON), DamageType.POISON));
        list.add(ChatFormatting.DARK_GRAY + " D: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.DARK), DamageType.DARK));
        list.add(ChatFormatting.GREEN + " RAD: " + GenericArmor.formatAV(this.field_77878_bZ.getArmorValueSlot(slot, DamageType.RADIATION), DamageType.RADIATION));
    }

    public void func_77624_a(ItemStack item, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(item, worldIn, list, flagIn);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(this.trans("armorTooltip.durability") + ": " + (item.func_77958_k() - item.func_77952_i()) + "/" + item.func_77958_k());
            if (this.field_189415_e > 0.0f) {
                list.add(ChatFormatting.GRAY + this.trans("armorTooltip.toughness") + ": " + this.field_189415_e);
            }
            list.add(ChatFormatting.BLUE + this.trans("armorTooltip.resistances") + ":");
            this.addArmorvaluesInformation(item, list);
            if (this.getBonus(TGArmorBonus.EXTRA_HEART) > 0.0f) {
                list.add(this.trans("armorTooltip.healthbonus") + ": +" + (int)this.getBonus(TGArmorBonus.EXTRA_HEART) + " " + this.trans("armorTooltip.hearts"));
            } else if (this.getBonus(TGArmorBonus.SPEED) > 0.0f) {
                list.add(this.trans("armorTooltip.movespeed") + ": +" + this.getBonus(TGArmorBonus.SPEED) * 100.0f + "%");
            } else if (this.getBonus(TGArmorBonus.JUMP) > 0.0f) {
                list.add(this.trans("armorTooltip.jumpheight") + ": +" + this.getBonus(TGArmorBonus.JUMP));
            }
            if (this.getBonus(TGArmorBonus.FALLDMG) > 0.0f) {
                list.add(this.trans("armorTooltip.falldamage") + ": -" + this.getBonus(TGArmorBonus.FALLDMG) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.FREEHEIGHT) > 0.0f) {
                list.add(this.trans("armorTooltip.fallheight") + ": -" + this.getBonus(TGArmorBonus.FREEHEIGHT));
            }
            if (this.getBonus(TGArmorBonus.BREAKSPEED) > 0.0f) {
                list.add(this.trans("armorTooltip.miningspeed") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.BREAKSPEED_WATER) > 0.0f) {
                list.add(this.trans("armorTooltip.underwatermining") + ": +" + this.getBonus(TGArmorBonus.BREAKSPEED_WATER) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE) > 0.0f) {
                list.add(this.trans("armorTooltip.knockbackresistance") + ": +" + this.getBonus(TGArmorBonus.KNOCKBACK_RESISTANCE) * 100.0f + "%");
            }
            if (this.getBonus(TGArmorBonus.NIGHTVISION) > 0.0f) {
                list.add(this.trans("armorTooltip.nightvision"));
            }
            if (this.getBonus(TGArmorBonus.STEPASSIST) > 0.0f) {
                list.add(this.trans("armorTooltip.stepassist"));
            }
            if (this.getBonus(TGArmorBonus.OXYGEN_GEAR) > 0.0f) {
                list.add(this.trans("armorTooltip.oxygengear"));
            }
            if (this.getBonus(TGArmorBonus.COOLING_SYSTEM) > 0.0f) {
                list.add(this.trans("armorTooltip.coolingsystem"));
            }
        } else {
            this.addMinimalInformation(item, list);
            list.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + ChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + ChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }

    protected void addMinimalInformation(ItemStack item, List<String> list) {
        list.add(this.trans("armorTooltip.durability") + ": " + (item.func_77958_k() - item.func_77952_i()) + "/" + item.func_77958_k());
    }

    public float getArmorValue(ItemStack armor, DamageType type) {
        return this.field_77878_bZ.getArmorValueSlot(this.field_77881_a, type);
    }

    @Deprecated
    public float getPenetrationResistance() {
        return this.field_77878_bZ.getPenetrationResistance();
    }

    public boolean func_82789_a(ItemStack item, ItemStack mat) {
        GenericArmor armor = (GenericArmor)item.func_77973_b();
        if (armor.repairItem != null) {
            return OreDictionary.itemMatches((ItemStack)armor.repairItem, (ItemStack)mat, (boolean)true);
        }
        return false;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!(entity instanceof EntityPlayerMP && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !stack.func_77984_f())) {
            int maxDmg = stack.func_77958_k() - 1 - stack.func_77952_i();
            if (damage > maxDmg) {
                damage = maxDmg;
            }
            if (stack.func_96631_a(damage, entity.func_70681_au(), entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null)) {
                entity.func_70669_a(stack);
                if (stack.func_77952_i() > stack.func_77958_k()) {
                    stack.func_77964_b(stack.func_77958_k());
                }
            }
        }
    }

    public boolean isHideFaceslot() {
        return this.hideFaceslot;
    }

    public GenericArmor setHideFaceslot(boolean hideFaceslot) {
        this.hideFaceslot = hideFaceslot;
        return this;
    }

    public boolean isHideBackslot() {
        return this.hideBackslot;
    }

    public GenericArmor setHideBackslot(boolean hideBackslot) {
        this.hideBackslot = hideBackslot;
        return this;
    }

    public boolean isHideGloveslot() {
        return this.hideGloveslot;
    }

    public GenericArmor setHideGloveslot(boolean hideGloveslot) {
        this.hideGloveslot = hideGloveslot;
        return this;
    }

    public GenericArmor setRepairMats(ItemStack metal, ItemStack cloth, float metalpercent, int totalmats) {
        if (metal != null && !metal.func_190926_b()) {
            this.repairItem = TGItems.newStack(metal, 1);
        } else if (cloth != null && !cloth.func_190926_b()) {
            this.repairItem = TGItems.newStack(cloth, 1);
        }
        if (metal != null && !metal.func_190926_b()) {
            this.repairMatMetal = TGItems.newStack(metal, 1);
        }
        if (cloth != null && !cloth.func_190926_b()) {
            this.repairMatCloth = TGItems.newStack(cloth, 1);
        }
        this.repairMatCount = totalmats;
        this.repairMatRatioMetal = metalpercent;
        return this;
    }

    public boolean canRepairOnRepairBench(ItemStack item) {
        GenericArmor armor = (GenericArmor)item.func_77973_b();
        return armor.repairMatCount > 0;
    }

    public ArrayList<ItemStack> getRepairMats(ItemStack item) {
        ArrayList<ItemStack> mats = new ArrayList<ItemStack>();
        if (item.func_77952_i() > 0) {
            GenericArmor armor = (GenericArmor)item.func_77973_b();
            float dmgpercent = (float)item.func_77952_i() * 1.0f / ((float)(item.func_77958_k() - 1) * 1.0f);
            int count = (int)Math.ceil((float)armor.repairMatCount * dmgpercent);
            int metalcount = (int)Math.ceil((float)count * armor.repairMatRatioMetal);
            int clothcount = count - metalcount;
            if (armor.repairMatMetal != null && metalcount > 0) {
                mats.add(TGItems.newStack(armor.repairMatMetal, metalcount));
            }
            if (armor.repairMatCloth != null && clothcount > 0) {
                mats.add(TGItems.newStack(armor.repairMatCloth, clothcount));
            }
        }
        return mats;
    }

    public String func_77667_c(ItemStack s) {
        return this.modid + "." + super.func_77667_c(s);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        TGDamageSource src = TGDamageSource.getFromGenericDamageSource(source);
        ISpecialArmor.ArmorProperties props = new ISpecialArmor.ArmorProperties(0, 1.0 - DamageSystem.getDamageAfterAbsorb_TGFormula(1.0f, this.getArmorValue(armor, src.field_76373_n), this.field_77878_bZ.toughness, src.armorPenetration), Integer.MAX_VALUE);
        return props;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.func_77952_i() >= armor.func_77958_k() - 1) {
            return 0;
        }
        return Math.round(this.armorValue);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modelLoc, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    public boolean shouldUseRenderHack(ItemStack stack) {
        return this.use3dRenderHack;
    }

    public boolean setArmorStat(EnumArmorStat stat, float value) {
        switch (stat) {
            case COOLING_SYSTEM: {
                this.coolingsystem = value;
                return true;
            }
            case EXTRA_HEARTS: {
                this.extraHearts = value;
                return true;
            }
            case FALL_DAMAGE: {
                this.FallDMG = value;
                return true;
            }
            case FALL_HEIGHT: {
                this.FallFreeHeight = value;
                return true;
            }
            case GUN_ACCURACY: {
                this.GunAccuracy = value;
                return true;
            }
            case JUMP: {
                this.JumpBonus = value;
                return true;
            }
            case KNOCKBACK_RESITANCE: {
                this.knockbackresistance = value;
                return true;
            }
            case MINING_SPEED: {
                this.MiningSpeedBonus = value;
                return true;
            }
            case NIGHTVISION: {
                this.nightvision = value;
                return true;
            }
            case OXYGEN_GEAR: {
                this.oxygen_gear = value;
                return true;
            }
            case SPEED: {
                this.SpeedBonus = value;
                return true;
            }
            case STEP_ASSIST: {
                this.stepassist = value;
                return true;
            }
            case WATER_ELECTROLYZER: {
                this.water_electrolyzer = value;
                return true;
            }
            case WATER_MINING_SPEED: {
                this.WaterMiningBonus = value;
                return true;
            }
            case WATER_SPEED: {
                this.waterspeedbonus = value;
                return true;
            }
            case RAD_RESISTANCE: {
                this.radresistance = value;
                return true;
            }
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == this.field_77881_a && this.radresistance > 0.0f) {
            multimap.put((Object)TGRadiation.RADIATION_RESISTANCE.func_111108_a(), (Object)new AttributeModifier(RAD_RESIST_MODIFIER[slot.func_188454_b()], "techguns.radresistance." + slot.toString(), (double)this.radresistance, 0));
        }
        return multimap;
    }
}

