/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui;

import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import techguns.gui.OwnedTileEntGui;
import techguns.gui.containers.RepairBenchContainer;
import techguns.gui.widgets.GuiButtonRepair;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.GenericShield;
import techguns.tileentities.RepairBenchTileEnt;
import techguns.util.InventoryUtil;
import techguns.util.TextUtil;

public class RepairBenchGui
extends OwnedTileEntGui {
    public static final ResourceLocation texture = new ResourceLocation("techguns:textures/gui/repair_bench_gui.png");
    protected RepairBenchTileEnt tileent;
    protected InventoryPlayer invplayer;

    public RepairBenchGui(InventoryPlayer player, RepairBenchTileEnt ent) {
        super(new RepairBenchContainer(player, ent), ent);
        this.tileent = ent;
        this.invplayer = player;
        this.tex = texture;
        this.heightSecurityButton = 10;
        this.showInventoryText = false;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        boolean x = false;
        boolean y = false;
        int mx = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int my = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        int color = 0x404040;
        for (int i = 0; i < 4; ++i) {
            if (!RepairBenchGui.isInRect(mx, my, 90 + i * 20, 39, 14, 14)) continue;
            ItemStack armor = (ItemStack)this.invplayer.field_70460_b.get(3 - i);
            this.drawTooltipRepairMats(armor, mx, my);
        }
        if (RepairBenchGui.isInRect(mx, my, 65, 39, 14, 14)) {
            ItemStack offhand = (ItemStack)this.invplayer.field_184439_c.get(0);
            this.drawTooltipRepairMats(offhand, mx, my);
        }
        if (RepairBenchGui.isInRect(mx, my, 12, 39, 14, 14)) {
            ItemStack stack = this.tileent.getInventory().getStackInSlot(9);
            this.drawTooltipRepairMats(stack, mx, my);
        }
    }

    private void drawTooltipRepairMats(ItemStack item, int mx, int my) {
        if (!item.func_190926_b()) {
            if (item.func_77973_b() instanceof GenericArmor && ((GenericArmor)item.func_77973_b()).canRepairOnRepairBench(item)) {
                if (item.func_77952_i() > 0) {
                    ArrayList<ItemStack> mats = ((GenericArmor)item.func_77973_b()).getRepairMats(item);
                    ArrayList<String> tooltips = new ArrayList<String>();
                    tooltips.add(TextUtil.trans("techguns.repairBench.requiredMats"));
                    for (int i = 1; i < mats.size() + 1; ++i) {
                        String prefix = "";
                        if (InventoryUtil.canConsumeItem(this.tileent.getInventory(), (ItemStack)mats.get(i - 1), 0, this.tileent.getInventory().getSlots()) > 0) {
                            prefix = "\u00a7c";
                        }
                        tooltips.add(prefix + ((ItemStack)mats.get(i - 1)).func_190916_E() + "x " + TextUtil.trans(((ItemStack)mats.get(i - 1)).func_77977_a() + ".name"));
                    }
                    this.func_146283_a(tooltips, mx, my);
                } else {
                    this.func_146279_a(TextUtil.trans("techguns.repairBench.fullcondition"), mx, my);
                }
            } else if (item.func_77973_b() instanceof GenericShield && ((GenericShield)item.func_77973_b()).canRepairOnRepairBench(item)) {
                if (item.func_77952_i() > 0) {
                    ArrayList<ItemStack> mats = ((GenericShield)item.func_77973_b()).getRepairMats(item);
                    ArrayList<String> tooltips = new ArrayList<String>();
                    tooltips.add(TextUtil.trans("techguns.repairBench.requiredMats"));
                    for (int i = 1; i < mats.size() + 1; ++i) {
                        String prefix = "";
                        if (InventoryUtil.canConsumeItem(this.tileent.getInventory(), (ItemStack)mats.get(i - 1), 0, this.tileent.getInventory().getSlots()) > 0) {
                            prefix = "\u00a7c";
                        }
                        tooltips.add(prefix + ((ItemStack)mats.get(i - 1)).func_190916_E() + "x " + TextUtil.trans(((ItemStack)mats.get(i - 1)).func_77977_a() + ".name"));
                    }
                    this.func_146283_a(tooltips, mx, my);
                } else {
                    this.func_146279_a(TextUtil.trans("techguns.repairBench.fullcondition"), mx, my);
                }
            } else {
                this.func_146279_a(TextUtil.trans("techguns.repairBench.cantrepair"), mx, my);
            }
        } else {
            this.func_146279_a(TextUtil.trans("techguns.repairBench.noarmor"), mx, my);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 2;
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 90, this.field_147009_r + 39, 14, 14));
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 90 + 20, this.field_147009_r + 39, 14, 14));
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 90 + 40, this.field_147009_r + 39, 14, 14));
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 90 + 60, this.field_147009_r + 39, 14, 14));
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 65, this.field_147009_r + 39, 14, 14));
        this.field_146292_n.add(new GuiButtonRepair(id++, this.field_147003_i + 9, this.field_147009_r + 39, 14, 14));
    }
}

