/*
 * Decompiled with CFR 0.152.
 */
package techguns.factions;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import techguns.Techguns;
import techguns.api.npc.factions.TGNpcFaction;
import techguns.plugins.ftbl.TeamSystemIntegration;

public class TGNpcFactions {
    protected static boolean[][] hostilityTable = new boolean[TGNpcFaction.values().length][TGNpcFaction.values().length];

    private static void setHostile(TGNpcFaction f1, TGNpcFaction f2, boolean hostile) {
        TGNpcFactions.hostilityTable[f1.ordinal()][f2.ordinal()] = hostile;
        TGNpcFactions.hostilityTable[f2.ordinal()][f1.ordinal()] = hostile;
    }

    private static void setHostile(TGNpcFaction f1, boolean hostile) {
        TGNpcFactions.hostilityTable[f1.ordinal()][f1.ordinal()] = hostile;
    }

    public static boolean canAccess(UUID owner, UUID target, int security) {
        if (owner.equals(target)) {
            return true;
        }
        switch (security) {
            case 1: {
                return TGNpcFactions.isAlliedOrTeamMember(owner, target);
            }
            case 2: {
                return TGNpcFactions.isTeamMember(owner, target);
            }
            case 3: {
                return owner.equals(target);
            }
        }
        return false;
    }

    public static boolean shouldAttack(UUID owner, UUID target, int pvpsetting) {
        if (owner.equals(target)) {
            return false;
        }
        switch (pvpsetting) {
            case 1: {
                return TGNpcFactions.isEnemy(owner, target);
            }
            case 2: {
                return !TGNpcFactions.isAlliedOrTeamMember(owner, target);
            }
            case 3: {
                return !TGNpcFactions.isTeamMember(owner, target);
            }
            case 4: {
                return !owner.equals(target);
            }
        }
        return false;
    }

    public static boolean isEnemy(UUID owner, UUID target) {
        if (Techguns.instance.FTBLIB_ENABLED && !owner.equals(target)) {
            return TeamSystemIntegration.isEnemy(owner, target);
        }
        return false;
    }

    public static boolean isAlliedOrTeamMember(UUID owner, UUID target) {
        if (Techguns.instance.FTBLIB_ENABLED && !owner.equals(target)) {
            return TeamSystemIntegration.isAllied(owner, target);
        }
        return true;
    }

    public static boolean isAlliedNoTeamMember(UUID owner, UUID target) {
        if (Techguns.instance.FTBLIB_ENABLED && !owner.equals(target)) {
            return TeamSystemIntegration.isAlliedNoMember(owner, target);
        }
        return true;
    }

    public static boolean isTeamMember(UUID owner, UUID target) {
        if (Techguns.instance.FTBLIB_ENABLED && !owner.equals(target)) {
            return TeamSystemIntegration.isTeamMember(owner, target);
        }
        return true;
    }

    public static boolean isHostile(EntityPlayer ply1, EntityPlayer ply2) {
        return TGNpcFactions.isHostile(EntityPlayer.func_146094_a((GameProfile)ply1.func_146103_bH()), EntityPlayer.func_146094_a((GameProfile)ply2.func_146103_bH()));
    }

    public static boolean isHostile(UUID ply1, UUID ply2) {
        if (Techguns.instance.FTBLIB_ENABLED) {
            return !TeamSystemIntegration.isAllied(ply1, ply2);
        }
        return !ply1.equals(ply2);
    }

    public static boolean isHostile(TGNpcFaction faction1, TGNpcFaction faction2) {
        return hostilityTable[faction1.ordinal()][faction2.ordinal()];
    }

    static {
        TGNpcFactions.setHostile(TGNpcFaction.HOSTILE, false);
        TGNpcFactions.setHostile(TGNpcFaction.TURRET, false);
        TGNpcFactions.setHostile(TGNpcFaction.NEUTRAL, false);
        TGNpcFactions.setHostile(TGNpcFaction.HOSTILE, TGNpcFaction.TURRET, true);
        TGNpcFactions.setHostile(TGNpcFaction.HOSTILE, TGNpcFaction.NEUTRAL, true);
        TGNpcFactions.setHostile(TGNpcFaction.TURRET, TGNpcFaction.NEUTRAL, false);
    }
}

