/*
 * Decompiled with CFR 0.152.
 */
package techguns.events;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import techguns.Techguns;
import techguns.events.IGuiFactory;
import techguns.gui.player.TGPlayerInventoryContainer;
import techguns.gui.player.TGPlayerInventoryGui;

public class TechgunsGuiHandler
implements IGuiHandler {
    public static void openGuiForPlayer(EntityPlayer ply, TileEntity tile) {
        int id = TechgunsGuiHandler.getGuiIdForTile(tile.getClass());
        if (id > 0) {
            ply.openGui((Object)Techguns.instance, id, tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
        }
    }

    public static int getGuiIdForTile(Class clazz) {
        GuiHandlerEntry entry = (GuiHandlerEntry)Techguns.proxy.getGuihandlers().getByTileClass.get(clazz);
        if (entry != null) {
            return entry.id;
        }
        return -1;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiHandlerEntry entry;
        if (ID == 0) {
            return new TGPlayerInventoryContainer(player);
        }
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null && (entry = (GuiHandlerEntry)Techguns.proxy.getGuihandlers().getByID.get(ID)) != null) {
            return entry.servergui.createElement(player.field_71071_by, tileEntity);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiHandlerEntry entry;
        if (ID == 0) {
            return new TGPlayerInventoryGui(player.field_71069_bz, player);
        }
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null && (entry = (GuiHandlerEntry)Techguns.proxy.getGuihandlers().getByID.get(ID)) != null) {
            return entry.clientgui.createElement(player.field_71071_by, tileEntity);
        }
        return null;
    }

    public static class GuiHandlerEntry<T> {
        protected int id;
        public Class<T> tileclass;
        protected IGuiFactory<T> clientgui;
        protected IGuiFactory<T> servergui;

        protected GuiHandlerEntry(Class<T> tile, IGuiFactory<T> clientgui, IGuiFactory<T> servergui, int id) {
            this.id = id;
            this.tileclass = tile;
            this.clientgui = clientgui;
            this.servergui = servergui;
        }

        public IGuiFactory<T> getClientGui() {
            return this.clientgui;
        }

        public IGuiFactory<T> getServerGui() {
            return this.servergui;
        }
    }

    public static class GuiHandlerRegister {
        private int nextId = 1;
        private HashMap<Class, GuiHandlerEntry> getByTileClass = new HashMap();
        private HashMap<Integer, GuiHandlerEntry> getByID = new HashMap();

        public <T extends TileEntity> void addEntry(Class<? extends T> tile, IGuiFactory<T> servergui) {
            this.addEntry(tile, null, servergui);
        }

        public <T extends TileEntity> void addEntry(Class<? extends T> tile, IGuiFactory<T> clientgui, IGuiFactory<T> servergui) {
            GuiHandlerEntry<? extends T> entry = new GuiHandlerEntry<T>(tile, clientgui, servergui, this.nextId++);
            this.getByTileClass.put(tile, entry);
            this.getByID.put(entry.id, entry);
        }
    }
}

