/*
 * Decompiled with CFR 0.152.
 */
package techguns.events;

import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.TGItems;
import techguns.TGRadiationSystem;
import techguns.Techguns;
import techguns.api.guns.GunHandType;
import techguns.api.guns.GunManager;
import techguns.api.radiation.TGRadiation;
import techguns.api.render.IItemRenderer;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.render.ItemRenderHack;
import techguns.client.render.item.RenderGunBase;
import techguns.gui.player.TGPlayerInventory;
import techguns.gui.player.TGPlayerInventoryGui;
import techguns.items.additionalslots.ItemTGSpecialSlotAmmo;
import techguns.items.armors.PoweredArmor;
import techguns.items.guns.EnumCrosshairStyle;
import techguns.items.guns.GenericGun;
import techguns.util.InventoryUtil;
import techguns.util.MathUtil;

public class TGGuiEvents
extends Gui {
    public static ResourceLocation crosshairs_texture = new ResourceLocation("techguns", "textures/gui/crosshairs.png");
    public static ResourceLocation tg_crosshairs_texture = new ResourceLocation("techguns", "textures/gui/tg_crosshairs.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onRenderGameOverlyEvent(RenderGameOverlayEvent event) {
        GenericGun gun;
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP ply = mc.field_71439_g;
        if (ply.func_175149_v()) {
            return;
        }
        TGExtendedPlayer props = TGExtendedPlayer.get((EntityPlayer)ply);
        ItemStack item = ply.func_184614_ca();
        ItemStack item_off = ply.func_184592_cb();
        ScaledResolution sr = new ScaledResolution(mc);
        int offsetY = sr.func_78328_b() - 32;
        boolean showSafemode = false;
        if (!item.func_190926_b() && item.func_77973_b() instanceof GenericGun) {
            gun = (GenericGun)item.func_77973_b();
            this.drawGunAmmoCount(mc, sr, gun, item, (EntityPlayer)ply, props, 0);
            showSafemode = true;
        }
        if (!item_off.func_190926_b() && item_off.func_77973_b() instanceof GenericGun && GunManager.canUseOffhand(item, item_off, (EntityLivingBase)ply)) {
            gun = (GenericGun)item_off.func_77973_b();
            this.drawGunAmmoCount(mc, sr, gun, item_off, (EntityPlayer)ply, props, -12);
            showSafemode = true;
        }
        if (props != null && props.showTGHudElements && showSafemode) {
            mc.func_110434_K().func_110577_a(TGPlayerInventoryGui.texture);
            this.func_73729_b(sr.func_78326_a() - 10, offsetY, 242 + 7 * (props.enableSafemode ? 1 : 0), 14, 7, 7);
        }
        if (props != null && props.showTGHudElements) {
            offsetY -= 10;
            mc.func_110434_K().func_110577_a(TGPlayerInventoryGui.texture);
            ItemStack chest = (ItemStack)ply.field_71071_by.field_70460_b.get(2);
            if (chest != null && chest.func_77973_b() instanceof PoweredArmor) {
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, 249, 35, 7, 7);
                PoweredArmor pwrchest = (PoweredArmor)chest.func_77973_b();
                double percent = (double)PoweredArmor.getPower(chest) * 1.0 / ((double)pwrchest.maxpower * 1.0);
                ItemStack ammoitem = pwrchest.getBattery();
                int count = InventoryUtil.countItemInInv((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammoitem, 0, ply.field_71071_by.field_70462_a.size());
                String text = ChatFormatting.YELLOW + "" + (count += InventoryUtil.countItemInInv(props.tg_inventory.inventory, ammoitem, 7, 15)) + "x" + ChatFormatting.WHITE + (int)(percent * 100.0) + "%";
                mc.field_71466_p.func_78276_b(text, sr.func_78326_a() - 2 - text.length() * 6 - 8 + 24, offsetY, -1);
                offsetY -= 10;
            }
            TGPlayerInventory cfr_ignored_0 = props.tg_inventory;
            ItemStack backslot = (ItemStack)props.tg_inventory.inventory.get(1);
            if (backslot != null && (backslot.func_77973_b() == TGItems.JETPACK || backslot.func_77973_b() == TGItems.JUMPPACK || backslot.func_77973_b() == TGItems.ANTI_GRAV_PACK)) {
                int x = 242;
                if (props.enableJetpack) {
                    x += 7;
                }
                mc.func_110434_K().func_110577_a(TGPlayerInventoryGui.texture);
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, x, 42, 7, 7);
                double percent = 1.0 - (double)((float)backslot.func_77952_i() * 1.0f / ((float)backslot.func_77958_k() * 1.0f));
                ItemStack ammoitem = ((ItemTGSpecialSlotAmmo)backslot.func_77973_b()).getAmmo();
                int count = InventoryUtil.countItemInInv((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammoitem, 0, ply.field_71071_by.field_70462_a.size());
                String text = ChatFormatting.YELLOW + "" + (count += InventoryUtil.countItemInInv(props.tg_inventory.inventory, ammoitem, 7, 15)) + "x" + ChatFormatting.WHITE + (int)(percent * 100.0) + "%";
                mc.field_71466_p.func_78276_b(text, sr.func_78326_a() - 2 - text.length() * 6 - 8 + 24, offsetY, -1);
                offsetY -= 10;
            }
            mc.func_110434_K().func_110577_a(TGPlayerInventoryGui.texture);
            if (Techguns.proxy.getHasNightvision()) {
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, 242 + 7 * (props.enableNightVision ? 1 : 0), 7, 7, 7);
                offsetY -= 10;
            }
            if (Techguns.proxy.getHasStepassist()) {
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, 242 + 7 * (props.enableStepAssist ? 1 : 0), 21, 7, 7);
                offsetY -= 10;
            }
            int mode = 0;
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = (ItemStack)ply.field_71071_by.field_70460_b.get(i);
                if (armor.func_190926_b()) continue;
                double dur = (double)(armor.func_77958_k() - armor.func_77952_i()) * 1.0 / ((double)armor.func_77958_k() * 1.0);
                if (dur < 0.35 && mode < 1) {
                    mode = 1;
                    continue;
                }
                if (armor.func_77952_i() < armor.func_77958_k() - 1) continue;
                mode = 2;
                break;
            }
            if (mode == 2) {
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, 249, 28, 7, 7);
                offsetY -= 10;
            } else if (mode == 1) {
                this.func_73729_b(sr.func_78326_a() - 10, offsetY, 242, 28, 7, 7);
                offsetY -= 10;
            }
            if (props.radlevel > 0) {
                String prefix = ChatFormatting.WHITE.toString();
                if (props.radlevel >= 1000) {
                    prefix = ChatFormatting.RED.toString();
                } else if (props.radlevel >= 750) {
                    prefix = ChatFormatting.GOLD.toString();
                } else if (props.radlevel >= 500) {
                    prefix = ChatFormatting.YELLOW.toString();
                }
                String radtext = props.radlevel + " RAD";
                mc.field_71466_p.func_78276_b(prefix + radtext, sr.func_78326_a() - radtext.length() * 6, offsetY, -1);
                offsetY -= 10;
                String currentRadText = "";
                PotionEffect currentRad = ply.func_70660_b((Potion)TGRadiationSystem.radiation_effect);
                if (currentRad != null) {
                    int res = (int)ply.func_110148_a(TGRadiation.RADIATION_RESISTANCE).func_111126_e();
                    int amount = MathUtil.clamp(currentRad.func_76458_c() + 1 - res, 0, 1000);
                    currentRadText = "+[" + amount + " RAD/s]";
                    mc.field_71466_p.func_78276_b(currentRadText, sr.func_78326_a() - currentRadText.length() * 6 + 4, offsetY, -1);
                    offsetY -= 10;
                }
            }
        }
    }

    private int getAmmoCountOfStack(ItemStack ammoitem, GenericGun gun, EntityPlayer ply, TGExtendedPlayer props) {
        int count = InventoryUtil.countItemInInv((NonNullList<ItemStack>)ply.field_71071_by.field_70462_a, ammoitem, 0, ply.field_71071_by.field_70462_a.size());
        count += InventoryUtil.countItemInInv(props.tg_inventory.inventory, ammoitem, 7, 15);
        if (gun.getAmmoCount() > 1) {
            count /= gun.getAmmoCount();
        }
        return count;
    }

    private void drawGunAmmoCount(Minecraft mc, ScaledResolution sr, GenericGun gun, ItemStack item, EntityPlayer ply, TGExtendedPlayer props, int offsetY) {
        ItemStack[] ammoitem = gun.getReloadItem(item);
        int minCount = 0;
        for (ItemStack stack : ammoitem) {
            int c = this.getAmmoCountOfStack(stack, gun, ply, props);
            if (c <= minCount) continue;
            minCount = c;
        }
        String text = gun.getAmmoLeftCountTooltip(item) + "/" + gun.getClipsizeTooltip() + ChatFormatting.YELLOW + "x" + minCount;
        mc.field_71466_p.func_78276_b(text, sr.func_78326_a() + 1 - text.length() * 6, sr.func_78328_b() - mc.field_71466_p.field_78288_b - 2 + offsetY, -1);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onRenderCrosshairs(RenderGameOverlayEvent event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player.func_184614_ca().func_77973_b() instanceof GenericGun) {
            if (mc.field_71474_y.field_74320_O != 0) {
                return;
            }
            GameSettings gamesettings = mc.field_71474_y;
            ScaledResolution sr = new ScaledResolution(mc);
            TGExtendedPlayer epc = TGExtendedPlayer.get((EntityPlayer)player);
            int x = sr.func_78326_a() / 2;
            int y = sr.func_78328_b() / 2;
            GenericGun gun = (GenericGun)player.func_184614_ca().func_77973_b();
            if (gun.getLockOnTicks() > 0 && epc.lockOnEntity != null && epc.lockOnTicks > 0) {
                event.setCanceled(true);
                float maxTicks = gun.getLockOnTicks();
                float progress = (float)epc.lockOnTicks / maxTicks;
                mc.func_110434_K().func_110577_a(crosshairs_texture);
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                int offset = (int)Math.max(0.0f, (1.0f - progress) * 16.0f) + 5;
                this.func_73729_b(x - offset - 3, y - offset - 3, 0, 0, 7, 7);
                this.func_73729_b(x + offset - 3, y - offset - 3, 7, 0, 7, 7);
                this.func_73729_b(x - offset - 3, y + offset - 3, 14, 0, 7, 7);
                this.func_73729_b(x + offset - 3, y + offset - 3, 21, 0, 7, 7);
                this.func_73729_b(x, y, 0, 0, 1, 1);
                if (progress < 1.0f) {
                    String text = "Locking... : " + epc.lockOnEntity.func_70005_c_();
                    mc.field_71466_p.func_78276_b(text, (int)(sr.func_78327_c() * 0.5) + 2, (int)(sr.func_78324_d() * 0.5) + 10, -1);
                } else {
                    this.func_73729_b(x - 6, y - 6, 28, 0, 13, 13);
                    Minecraft.func_71410_x();
                    if (Minecraft.func_71386_F() / 250L % 2L == 0L) {
                        this.func_73729_b(x - 9, y - 9, 41, 0, 19, 19);
                    }
                    String text = "Locked On: " + epc.lockOnEntity.func_70005_c_();
                    mc.field_71466_p.func_78276_b(text, (int)(sr.func_78327_c() * 0.5) + 2, (int)(sr.func_78324_d() * 0.5) + 10, -65536);
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
            } else {
                RenderGunBase rgun;
                IItemRenderer irenderer;
                if (gun.isZooming() && (irenderer = ItemRenderHack.getRendererForItem(gun)) != null && irenderer instanceof RenderGunBase && (rgun = (RenderGunBase)irenderer).hasScopeTexture()) {
                    event.setCanceled(true);
                    return;
                }
                if (gun.getCrossHairStyle() != EnumCrosshairStyle.VANILLA) {
                    event.setCanceled(true);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(tg_crosshairs_texture);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179141_d();
                    float spread = gun.getSpread();
                    if (player.func_184585_cz()) {
                        spread = gun.getHandType() == GunHandType.ONE_HANDED ? (spread *= 4.0f) : (spread *= 8.0f);
                    }
                    if (gun.isZooming()) {
                        spread *= gun.getZoombonus();
                    }
                    int spacing = MathUtil.clamp(Math.round(100.0f * spread), 1, 10);
                    if (gun.getCrossHairStyle() == EnumCrosshairStyle.GUN_DYNAMIC) {
                        this.func_73729_b(x - (4 + spacing), y, 3, 7, 4, 1);
                        this.func_73729_b(x + (1 + spacing), y, 8, 7, 4, 1);
                        this.func_73729_b(x, y, 7, 7, 1, 1);
                        this.func_73729_b(x, y - (4 + spacing), 7, 3, 1, 4);
                        this.func_73729_b(x, y + (1 + spacing), 7, 8, 1, 4);
                    } else {
                        EnumCrosshairStyle crosshair = gun.getCrossHairStyle();
                        switch (crosshair.dynamicType) {
                            case BOTH: {
                                this.func_73729_b(x - 1, y - 1, crosshair.getLocX() + 6, crosshair.getLocY() + 6, 3, 3);
                                this.func_73729_b(x - 6 - spacing, y - 2, crosshair.getLocX(), crosshair.getLocY() + 5, 6, 5);
                                this.func_73729_b(x + 1 + spacing, y - 2, crosshair.getLocX() + 9, crosshair.getLocY() + 5, 6, 5);
                                this.func_73729_b(x - 2, y - 6 - spacing, crosshair.getLocX() + 5, crosshair.getLocY(), 5, 6);
                                this.func_73729_b(x - 2, y + 1 + spacing, crosshair.getLocX() + 5, crosshair.getLocY() + 9, 5, 6);
                                break;
                            }
                            case HORIZONTAL: {
                                this.func_73729_b(x - 1, y - 1, crosshair.getLocX() + 6, crosshair.getLocY() + 6, 3, 3);
                                this.func_73729_b(x - 6 - spacing, y - 7, crosshair.getLocX(), crosshair.getLocY(), 6, 16);
                                this.func_73729_b(x + 1 + spacing, y - 7, crosshair.getLocX() + 9, crosshair.getLocY(), 6, 16);
                                break;
                            }
                            case X: {
                                this.func_73729_b(x - 1, y - 1, crosshair.getLocX() + 6, crosshair.getLocY() + 6, 3, 3);
                                this.func_73729_b(x - 6 - spacing, y - 6 - spacing, crosshair.getLocX(), crosshair.getLocY(), 6, 6);
                                this.func_73729_b(x + 1 + spacing, y - 6 - spacing, crosshair.getLocX() + 9, crosshair.getLocY(), 6, 6);
                                this.func_73729_b(x - 6 - spacing, y + 1 + spacing, crosshair.getLocX(), crosshair.getLocY() + 9, 6, 6);
                                this.func_73729_b(x + 1 + spacing, y + 1 + spacing, crosshair.getLocX() + 9, crosshair.getLocY() + 9, 6, 6);
                                break;
                            }
                            case TRI: {
                                this.func_73729_b(x - 1, y - 1, crosshair.getLocX() + 6, crosshair.getLocY() + 6, 3, 3);
                                this.func_73729_b(x - 7, y - 6 - spacing, crosshair.getLocX(), crosshair.getLocY(), 16, 6);
                                this.func_73729_b(x - 6 - spacing, y + 1 + spacing, crosshair.getLocX(), crosshair.getLocY() + 9, 6, 6);
                                this.func_73729_b(x + 1 + spacing, y + 1 + spacing, crosshair.getLocX() + 9, crosshair.getLocY() + 9, 6, 6);
                                break;
                            }
                            case TRI_INV: {
                                this.func_73729_b(x - 1, y - 1, crosshair.getLocX() + 6, crosshair.getLocY() + 6, 3, 3);
                                this.func_73729_b(x - 6 - spacing, y - 6 - spacing, crosshair.getLocX(), crosshair.getLocY(), 6, 6);
                                this.func_73729_b(x + 1 + spacing, y - 6 - spacing, crosshair.getLocX() + 9, crosshair.getLocY(), 6, 6);
                                this.func_73729_b(x - 7, y + 1 + spacing, crosshair.getLocX(), crosshair.getLocY() + 9, 16, 6);
                                break;
                            }
                            default: {
                                this.func_73729_b(x - 7, y - 7, crosshair.getLocX(), crosshair.getLocY(), 16, 16);
                            }
                        }
                    }
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
                }
            }
        }
    }
}

