/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.special;

import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import techguns.TGRadiationSystem;

public class EntityRadiation
extends Entity {
    public static final int RAD_INTERVAL = 20;
    protected int duration;
    protected float radius;
    protected float inner_radius;
    protected int strength;
    protected int strength_outer;
    protected int strength_original;
    protected int strength_outer_original;

    public EntityRadiation(World worldIn) {
        super(worldIn);
    }

    public EntityRadiation(World worldIn, double posX, double posY, double posZ, int duration, float innter_radius, int strength, float radius, int strength_outer) {
        super(worldIn);
        this.func_70107_b(posX, posY, posZ);
        this.setRadiationValues(duration, innter_radius, strength, radius, strength_outer);
    }

    public EntityRadiation(Entity otherEntPos, int duration, float innter_radius, int strength, float radius, int strength_outer) {
        super(otherEntPos.field_70170_p);
        this.func_70107_b(otherEntPos.field_70165_t, otherEntPos.field_70163_u, otherEntPos.field_70161_v);
        this.setRadiationValues(duration, innter_radius, strength, radius, strength_outer);
    }

    public EntityRadiation(TileEntity tilePos, int duration, float innter_radius, int strength, float radius, int strength_outer) {
        super(tilePos.func_145831_w());
        this.func_70107_b((double)tilePos.func_174877_v().func_177958_n() + 0.5, (double)tilePos.func_174877_v().func_177956_o() + 0.5, (double)tilePos.func_174877_v().func_177952_p() + 0.5);
        this.setRadiationValues(duration, innter_radius, strength, radius, strength_outer);
    }

    public EntityRadiation setRadiationValues(int duration, float innter_radius, int strength, float radius, int strength_outer) {
        this.duration = duration;
        this.inner_radius = innter_radius;
        this.strength = strength;
        this.radius = radius;
        this.strength_outer = strength_outer;
        this.strength_original = strength;
        this.strength_outer_original = strength_outer;
        return this;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.radius = compound.func_74760_g("radius");
        this.inner_radius = compound.func_74760_g("inner_radius");
        this.strength = compound.func_74765_d("strength");
        this.strength_outer = compound.func_74765_d("strength_outer");
        this.strength_original = compound.func_74765_d("strength_original");
        this.strength_outer_original = compound.func_74765_d("strength_outer_original");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74776_a("radius", this.radius);
        compound.func_74776_a("inner_radius", this.inner_radius);
        compound.func_74777_a("strength", (short)this.strength);
        compound.func_74777_a("strength_outer", (short)this.strength_outer);
        compound.func_74777_a("strength_original", (short)this.strength_original);
        compound.func_74777_a("strength_outer_original", (short)this.strength_outer_original);
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_71061_d_() {
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > this.duration) {
            this.func_70106_y();
            return;
        }
        if (this.field_70173_aa % 20 == 0 && !this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa * 2 >= this.duration) {
                double factor = 1.0 - ((double)this.field_70173_aa - (double)this.duration * 0.5) / ((double)this.duration * 0.5);
                this.strength = Math.max((int)Math.round((double)this.strength_original * factor), 0);
                this.strength_outer = Math.max((int)Math.round((double)this.strength_outer_original * factor), 0);
            }
            TGRadiationSystem.applyRadToEntities(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.radius, 22, this.strength, this.inner_radius, this.strength_outer);
        }
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

