/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.AbstractBeamProjectile;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;

public class TeslaProjectile
extends AbstractBeamProjectile {
    public static final int TTL = 10;
    public static final float CHAIN_RANGE = 8.0f;
    public static final int CHAIN_TARGETS = 4;
    public static final float CHAIN_DAMAGE_FACTOR = 0.75f;
    public long seed = 0L;
    protected int chainTargets = 4;
    protected Entity prevTarget = null;

    public TeslaProjectile(World worldIn) {
        super(worldIn);
        this.seed = worldIn.field_73012_v.nextLong();
    }

    public TeslaProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, int chainTargets) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.chainTargets = chainTargets;
        this.trace();
    }

    public TeslaProjectile(World world, EntityLivingBase shooter, Entity source, EntityLivingBase target, int chainTargets, float damage, float speed, int TTL, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(world, shooter, damage, speed, TTL, 0.0f, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, EnumBulletFirePos.CENTER);
        RayTraceResult raytraceresult;
        this.maxTicks = (short)this.ticksToLive;
        this.chainTargets = chainTargets;
        this.prevTarget = target;
        this.field_70165_t = source.field_70165_t;
        this.field_70163_u = source.field_70163_u + (double)(source.func_70047_e() * 0.5f);
        this.field_70161_v = source.field_70161_v;
        Vec3d src = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d tgt = new Vec3d(target.field_70165_t, target.field_70163_u + (double)(target.func_70047_e() * 0.5f), target.field_70161_v);
        Vec3d dir = tgt.func_178788_d(src).func_72432_b();
        this.distance = src.func_72438_d(tgt);
        this.laserPitch = (float)(Math.asin(-dir.field_72448_b) * 57.29577951308232);
        this.laserYaw = (float)(Math.atan2(dir.field_72450_a, dir.field_72449_c) * 57.29577951308232);
        this.field_70125_A = this.laserPitch;
        this.field_70177_z = this.laserYaw;
        this.field_70159_w = dir.field_72450_a * (double)this.speed;
        this.field_70181_x = dir.field_72448_b * (double)this.speed;
        this.field_70179_y = dir.field_72449_c * (double)this.speed;
        if (this.distance <= 0.0) {
            this.distance = this.speed;
        }
        if ((raytraceresult = new RayTraceResult((Entity)target)) != null) {
            this.onHit(raytraceresult);
            this.field_70128_L = false;
        }
    }

    @Override
    protected void onHit(RayTraceResult raytraceResultIn) {
        EntityLivingBase nextTarget;
        Entity lastTarget;
        super.onHit(raytraceResultIn);
        if (!this.field_70170_p.field_72995_K && (lastTarget = raytraceResultIn.field_72308_g) != null && this.chainTargets > 0 && (nextTarget = this.findNextTarget(lastTarget)) != null) {
            TeslaProjectile proj = new TeslaProjectile(this.field_70170_p, this.shooter, lastTarget, nextTarget, this.chainTargets - 1, this.damage * 0.75f, this.speed, 10, this.damageDropStart, this.damageDropEnd, this.damageMin, this.penetration, this.blockdamage);
            this.field_70170_p.func_72838_d((Entity)proj);
        }
    }

    private EntityLivingBase findNextTarget(Entity lastTarget) {
        List list = this.field_70170_p.func_175674_a(lastTarget, new AxisAlignedBB(lastTarget.field_70165_t - 8.0, lastTarget.field_70163_u - 8.0, lastTarget.field_70161_v - 8.0, lastTarget.field_70165_t + 8.0, lastTarget.field_70163_u + 8.0, lastTarget.field_70161_v + 8.0), BULLET_TARGETS);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            Vec3d vec3d2;
            Vec3d vec3d1;
            RayTraceResult raytraceresult;
            EntityLivingBase entity;
            double distance;
            Entity e = (Entity)list.get(i1);
            if (!(e instanceof EntityLivingBase) || !((distance = (entity = (EntityLivingBase)e).func_70011_f(lastTarget.field_70165_t, lastTarget.field_70163_u + (double)(lastTarget.func_70047_e() * 0.5f), lastTarget.field_70161_v)) < 8.0) || !entity.func_70089_S() || entity == lastTarget || entity.equals((Object)this.shooter) || entity.equals((Object)this.prevTarget) || (raytraceresult = this.field_70170_p.func_147447_a(vec3d1 = new Vec3d(lastTarget.field_70165_t, lastTarget.field_70163_u + (double)(lastTarget.func_70047_e() * 0.5f), lastTarget.field_70161_v), vec3d2 = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)(entity.func_70047_e() * 0.5f), entity.field_70161_v), false, true, false)) != null) continue;
            return entity;
        }
        return null;
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeLightningDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        src.goreChance = 0.5f;
        return src;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public static class Factory
    implements IProjectileFactory<TeslaProjectile> {
        @Override
        public TeslaProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new TeslaProjectile(world, p, damage, speed, 10, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, 4);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.LIGHTNING;
        }
    }
}

