/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import techguns.TGPackets;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticle;

public class SonicShotgunProjectile
extends GenericProjectile
implements IEntityAdditionalSpawnData {
    public ArrayList<Entity> entitiesHit;
    public boolean mainProjectile = false;

    public SonicShotgunProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public SonicShotgunProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
    }

    public SonicShotgunProjectile(World worldIn) {
        super(worldIn);
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = new TGDamageSource("tg_sonic", this, (Entity)this.shooter, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        src.ignoreHurtresistTime = true;
        src.armorPenetration = this.penetration;
        src.setKnockback(2.0f);
        src.goreChance = 1.0f;
        return src;
    }

    public boolean shouldRenderInPass(int pass) {
        if (pass == 1) {
            return this.mainProjectile;
        }
        return !this.mainProjectile;
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        if (this.mainProjectile && !this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("SonicShotgunImpact", this.field_70165_t, this.field_70163_u, this.field_70161_v), TGPackets.targetPointAroundEnt(this, 50.0));
        }
    }

    @Override
    protected void onHit(RayTraceResult mop) {
        if (mop.field_72308_g != null) {
            if (this.entitiesHit != null && !this.entitiesHit.contains(mop.field_72308_g)) {
                TGDamageSource src = this.getProjectileDamageSource();
                TGDamageSource knockback = TGDamageSource.getKnockbackDummyDmgSrc(this, (Entity)this.shooter);
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase ent = (EntityLivingBase)mop.field_72308_g;
                    float dmg = DamageSystem.getDamageFactor(this.shooter, ent);
                    if (dmg > 0.0f) {
                        ent.func_70097_a((DamageSource)knockback, 0.01f);
                        ent.func_70097_a((DamageSource)src, this.getDamage() * dmg);
                        if (src.wasSuccessful()) {
                            if (ent instanceof EntityLiving) {
                                this.setAIRevengeTarget((EntityLiving)ent);
                            }
                            this.onHitEffect(ent, mop);
                        }
                    }
                } else {
                    mop.field_72308_g.func_70097_a((DamageSource)src, this.getDamage());
                }
                this.entitiesHit.add(mop.field_72308_g);
            }
        } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.hitBlock(mop);
            this.func_70106_y();
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.mainProjectile);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        this.mainProjectile = additionalData.readBoolean();
    }

    public static class Factory
    implements IProjectileFactory<SonicShotgunProjectile> {
        @Override
        public SonicShotgunProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new SonicShotgunProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.PHYSICAL;
        }
    }
}

