/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.client.ClientProxy;
import techguns.damagesystem.TGDamageSource;
import techguns.damagesystem.TGExplosion;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IProjectileFactory;
import techguns.packets.PacketSpawnParticle;
import techguns.util.MathUtil;

@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")
public class RocketProjectile
extends GenericProjectile
implements ILightProvider {
    public RocketProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.radius = radius;
        this.gravity = gravity;
    }

    public RocketProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, float radius, double gravity) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.radius = radius;
        this.gravity = gravity;
    }

    public RocketProjectile(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            this.createTrailFX();
        }
    }

    protected void createTrailFX() {
        ClientProxy.get().createFXOnEntity("RocketLauncherExhaust", this);
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        this.explodeRocket();
    }

    @Override
    protected void hitBlock(RayTraceResult raytraceResultIn) {
        this.explodeRocket();
    }

    protected void explodeRocket() {
        if (!this.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("RocketExplosion", this.field_70165_t, this.field_70163_u, this.field_70161_v), TGPackets.targetPointAroundEnt(this, 50.0));
            TGExplosion explosion = new TGExplosion(this.field_70170_p, (Entity)this.shooter, this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.damage, this.damageMin, this.damageDropStart, this.damageDropEnd, this.blockdamage ? 0.5 : 0.0);
            explosion.doExplosion(true);
        } else {
            Techguns.proxy.createLightPulse(this.field_70165_t, this.field_70163_u, this.field_70161_v, 5, 15, 10.0f, 1.0f, 1.0f, 0.9f, 0.5f);
        }
        this.func_70106_y();
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource dmgsrc = TGDamageSource.causeExplosionDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.GORE);
        dmgsrc.goreChance = 1.0f;
        dmgsrc.knockbackMultiplier = 3.0f;
        return dmgsrc;
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        return Light.builder().pos(MathUtil.getInterpolatedEntityPos(this)).color(1.0f, 1.0f, 1.0f).radius(3.0f).build();
    }

    @Optional.Method(modid="albedo")
    public void gatherLights(GatherLightsEvent evt, Entity ent) {
    }

    public static class Factory
    implements IProjectileFactory<RocketProjectile> {
        @Override
        public RocketProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return new RocketProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, radius, gravity);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.EXPLOSION;
        }
    }
}

